/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ChunkedInputStream
extends InputStream {
    private static final int PUSHBBACK_BUFFER_SIZE = 2;
    private volatile long chunkSize;
    private volatile boolean done;
    private volatile boolean initialized;
    private volatile long position;
    private final PushbackInputStream source;

    public ChunkedInputStream(InputStream source) {
        this.source = new PushbackInputStream(source, 2);
        this.initialized = false;
        this.done = false;
        this.position = 0L;
        this.chunkSize = 0L;
    }

    private void checkCRLF() throws IOException {
        int cr = this.source.read();
        int lf = this.source.read();
        if (cr != 13 && lf != 10) {
            this.source.unread(lf);
            this.source.unread(cr);
        }
    }

    private boolean chunkAvailable() {
        return this.position < this.chunkSize;
    }

    public void close() throws IOException {
        super.close();
        this.initialized = true;
        this.done = true;
    }

    private void initialize() throws IOException {
        if (!this.initialized) {
            this.checkCRLF();
            this.initialized = true;
        }
    }

    private void initializeChunk() throws IOException {
        this.chunkSize = this.readChunkSize();
        this.position = 0L;
        if (this.chunkSize == 0L) {
            this.done = true;
        }
    }

    public int read() throws IOException {
        int result = -1;
        this.initialize();
        if (!this.done) {
            if (this.chunkAvailable()) {
                result = this.source.read();
                ++this.position;
            } else {
                this.initializeChunk();
                return this.read();
            }
        }
        return result;
    }

    private long readChunkSize() throws IOException {
        String line = this.readChunkSizeLine();
        int index = line.indexOf(59);
        line = index == -1 ? line : line.substring(0, index);
        try {
            return Long.parseLong(line.trim(), 16);
        }
        catch (NumberFormatException ex) {
            throw new IOException("<" + line + "> is an invalid chunk size");
        }
    }

    private String readChunkSizeLine() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.checkCRLF();
        while (true) {
            int b;
            if ((b = this.source.read()) == -1) {
                throw new IOException("Invalid chunk size specified. End of stream reached");
            }
            if (b == 13) {
                int lf = this.source.read();
                if (lf == 10) break;
                throw new IOException("Invalid chunk size specified.  Expected crlf, only saw cr");
            }
            buffer.write(b);
        }
        return new String(buffer.toByteArray());
    }
}

