/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import com.noelios.restlet.http.HttpUtils;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends OutputStream {
    private static final int DEFAULT_CHUNK_SIZE = 2048;
    private final byte[] buffer;
    private volatile int bytesWritten;
    private volatile boolean closed;
    private final OutputStream destination;

    public ChunkedOutputStream(OutputStream destination) {
        this(destination, 2048);
    }

    public ChunkedOutputStream(OutputStream destination, int chunkSize) {
        this.destination = destination;
        this.buffer = new byte[chunkSize];
        this.bytesWritten = 0;
        this.closed = false;
    }

    private boolean chunkFull() {
        return this.bytesWritten == this.buffer.length;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.writeChunk();
            this.writeFinalChunk();
            super.close();
            this.closed = true;
            this.destination.flush();
        }
    }

    public void flush() throws IOException {
        this.writeChunk();
        this.destination.flush();
    }

    private void reset() {
        this.bytesWritten = 0;
    }

    public void write(int b) throws IOException {
        if (this.chunkFull()) {
            this.writeChunk();
        }
        this.buffer[this.bytesWritten++] = (byte)b;
    }

    private void writeBuffer() throws IOException {
        this.destination.write(this.buffer, 0, this.bytesWritten);
        HttpUtils.writeCRLF(this.destination);
    }

    private void writeChunk() throws IOException {
        if (this.bytesWritten > 0) {
            this.writePosition();
            this.writeBuffer();
            this.reset();
        }
    }

    private void writeFinalChunk() throws IOException {
        this.destination.write(48);
        HttpUtils.writeCRLF(this.destination);
        HttpUtils.writeCRLF(this.destination);
    }

    private void writePosition() throws IOException {
        this.destination.write(Integer.toHexString(this.bytesWritten).getBytes());
        HttpUtils.writeCRLF(this.destination);
    }
}

