/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import com.noelios.restlet.util.FormReader;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.resource.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormUtils {
    public static void parse(Logger logger, Form form, String parametersString, CharacterSet characterSet, boolean decode, char separator) {
        FormReader fr = null;
        fr = decode ? new FormReader(logger, parametersString, characterSet, separator) : new FormReader(logger, parametersString, separator);
        fr.addParameters(form);
    }

    public static void parse(Logger logger, Form form, Representation post) {
        if (post.isAvailable()) {
            FormReader fr;
            block5: {
                fr = null;
                try {
                    fr = new FormReader(logger, post);
                }
                catch (IOException ioe) {
                    if (logger == null) break block5;
                    logger.log(Level.WARNING, "Unable to create a form reader. Parsing aborted.", ioe);
                }
            }
            if (fr != null) {
                fr.addParameters(form);
            }
        } else {
            throw new IllegalStateException("The Web form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
        }
    }

    public static void getParameters(Logger logger, String parametersString, Map<String, Object> parameters, CharacterSet characterSet, char separator) throws IOException {
        new FormReader(logger, parametersString, characterSet, separator).readParameters(parameters);
    }

    public static void getParameters(Logger logger, Representation post, Map<String, Object> parameters) throws IOException {
        if (!post.isAvailable()) {
            throw new IllegalStateException("The Web form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
        }
        new FormReader(logger, post).readParameters(parameters);
    }

    public static Parameter getFirstParameter(Logger logger, String query, String name, CharacterSet characterSet, char separator) throws IOException {
        return new FormReader(logger, query, characterSet, separator).readFirstParameter(name);
    }

    public static Parameter getFirstParameter(Logger logger, Representation post, String name) throws IOException {
        if (!post.isAvailable()) {
            throw new IllegalStateException("The Web form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
        }
        return new FormReader(logger, post).readFirstParameter(name);
    }

    public static Object getParameter(Logger logger, String query, String name, CharacterSet characterSet, char separator) throws IOException {
        return new FormReader(logger, query, characterSet, separator).readParameter(name);
    }

    public static Object getParameter(Logger logger, Representation form, String name) throws IOException {
        if (!form.isAvailable()) {
            throw new IllegalStateException("The Web form cannot be parsed as no fresh content is available. If this entity has been already read once, caching of the entity is required");
        }
        return new FormReader(logger, form).readParameter(name);
    }

    public static Parameter create(CharSequence name, CharSequence value, boolean decode, CharacterSet characterSet) {
        Parameter result = null;
        if (name != null) {
            String nameStr = decode ? Reference.decode((String)((Object)name).toString(), (CharacterSet)characterSet) : ((Object)name).toString();
            if (value != null) {
                String valueStr = decode ? Reference.decode((String)((Object)value).toString(), (CharacterSet)characterSet) : ((Object)value).toString();
                result = new Parameter(nameStr, valueStr);
            } else {
                result = new Parameter(nameStr, null);
            }
        }
        return result;
    }
}

