/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import com.noelios.restlet.util.PreferenceReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceUtils {
    public static String format(List<? extends Preference<?>> prefs) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < prefs.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            Preference<?> pref = prefs.get(i);
            PreferenceUtils.format(pref, sb);
        }
        return sb.toString();
    }

    public static void format(Preference pref, Appendable destination) throws IOException {
        MediaType mediaType;
        destination.append(pref.getMetadata().getName());
        if (pref.getMetadata() instanceof MediaType && (mediaType = (MediaType)pref.getMetadata()).getParameters() != null) {
            for (Parameter param : mediaType.getParameters()) {
                if (param.getName() == null) continue;
                destination.append(';').append(param.getName());
                if (param.getValue() == null || param.getValue().length() <= 0) continue;
                destination.append('=').append(param.getValue());
            }
        }
        if (pref.getQuality() < 1.0f) {
            destination.append(";q=");
            PreferenceUtils.formatQuality(pref.getQuality(), destination);
        }
        if (pref.getParameters() != null) {
            for (Parameter param : pref.getParameters()) {
                if (param.getName() == null) continue;
                destination.append(';').append(param.getName());
                if (param.getValue() == null || param.getValue().length() <= 0) continue;
                destination.append('=').append(param.getValue());
            }
        }
    }

    public static void formatQuality(float quality, Appendable destination) throws IOException {
        if (!PreferenceUtils.isQuality(quality)) {
            throw new IllegalArgumentException("Invalid quality value detected. Value must be between 0 and 1.");
        }
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.US);
        formatter.setMaximumFractionDigits(2);
        destination.append(formatter.format(quality));
    }

    public static float parseQuality(String quality) {
        try {
            float result = Float.valueOf(quality).floatValue();
            if (PreferenceUtils.isQuality(result)) {
                return result;
            }
            throw new IllegalArgumentException("Invalid quality value detected. Value must be between 0 and 1.");
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid quality value detected. Value must be between 0 and 1.");
        }
    }

    public static boolean isQuality(float quality) {
        return quality >= 0.0f && quality <= 1.0f;
    }

    public static void parseCharacterSets(String acceptCharsetHeader, ClientInfo client) {
        if (acceptCharsetHeader != null) {
            if (acceptCharsetHeader.length() == 0) {
                client.getAcceptedCharacterSets().add(new Preference((Metadata)CharacterSet.ISO_8859_1));
            } else {
                try {
                    PreferenceReader pr = new PreferenceReader(1, acceptCharsetHeader);
                    Preference currentPref = pr.readPreference();
                    while (currentPref != null) {
                        client.getAcceptedCharacterSets().add(currentPref);
                        currentPref = pr.readPreference();
                    }
                }
                catch (IOException ioe) {
                    throw new IllegalArgumentException("An exception occurred during character set preferences parsing. Header: " + acceptCharsetHeader + ". Ignoring header.");
                }
            }
        } else {
            client.getAcceptedCharacterSets().add(new Preference((Metadata)CharacterSet.ALL));
        }
    }

    public static void parseEncodings(String acceptEncodingHeader, ClientInfo preference) {
        if (acceptEncodingHeader != null) {
            try {
                PreferenceReader pr = new PreferenceReader(2, acceptEncodingHeader);
                Preference currentPref = pr.readPreference();
                while (currentPref != null) {
                    preference.getAcceptedEncodings().add(currentPref);
                    currentPref = pr.readPreference();
                }
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("An exception occurred during encoding preferences parsing. Header: " + acceptEncodingHeader + ". Ignoring header.");
            }
        } else {
            preference.getAcceptedEncodings().add(new Preference((Metadata)Encoding.IDENTITY));
        }
    }

    public static void parseLanguages(String acceptLanguageHeader, ClientInfo preference) {
        if (acceptLanguageHeader != null) {
            try {
                PreferenceReader pr = new PreferenceReader(3, acceptLanguageHeader);
                Preference currentPref = pr.readPreference();
                while (currentPref != null) {
                    preference.getAcceptedLanguages().add(currentPref);
                    currentPref = pr.readPreference();
                }
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("An exception occurred during language preferences parsing. Header: " + acceptLanguageHeader + ". Ignoring header.");
            }
        } else {
            preference.getAcceptedLanguages().add(new Preference((Metadata)Language.ALL));
        }
    }

    public static void parseMediaTypes(String acceptMediaTypeHeader, ClientInfo preference) {
        if (acceptMediaTypeHeader != null) {
            try {
                PreferenceReader pr = new PreferenceReader(4, acceptMediaTypeHeader);
                Preference currentPref = pr.readPreference();
                while (currentPref != null) {
                    preference.getAcceptedMediaTypes().add(currentPref);
                    currentPref = pr.readPreference();
                }
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("An exception occurred during media type preferences parsing. Header: " + acceptMediaTypeHeader + ". Ignoring header.");
            }
        } else {
            preference.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.ALL));
        }
    }
}

