/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.cluster;

import com.novemberain.quartz.mongodb.LockManager;
import com.novemberain.quartz.mongodb.TriggerAndJobPersister;
import com.novemberain.quartz.mongodb.cluster.RecoveryTriggerFactory;
import com.novemberain.quartz.mongodb.dao.JobDao;
import com.novemberain.quartz.mongodb.dao.LocksDao;
import com.novemberain.quartz.mongodb.dao.TriggerDao;
import com.novemberain.quartz.mongodb.trigger.MisfireHandler;
import org.quartz.JobPersistenceException;
import org.quartz.TriggerKey;
import org.quartz.spi.OperableTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerRecoverer {
    private static final Logger log = LoggerFactory.getLogger(TriggerRecoverer.class);
    private final LocksDao locksDao;
    private final TriggerAndJobPersister persister;
    private final LockManager lockManager;
    private final TriggerDao triggerDao;
    private final JobDao jobDao;
    private final RecoveryTriggerFactory recoveryTriggerFactory;
    private final MisfireHandler misfireHandler;

    public TriggerRecoverer(LocksDao locksDao, TriggerAndJobPersister persister, LockManager lockManager, TriggerDao triggerDao, JobDao jobDao, RecoveryTriggerFactory recoveryTriggerFactory, MisfireHandler misfireHandler) {
        this.locksDao = locksDao;
        this.persister = persister;
        this.lockManager = lockManager;
        this.triggerDao = triggerDao;
        this.jobDao = jobDao;
        this.recoveryTriggerFactory = recoveryTriggerFactory;
        this.misfireHandler = misfireHandler;
    }

    public void recover() throws JobPersistenceException {
        for (TriggerKey key : this.locksDao.findOwnTriggersLocks()) {
            OperableTrigger trigger = this.triggerDao.getTrigger(key);
            if (trigger == null || !this.locksDao.updateOwnLock(trigger.getKey())) continue;
            this.doRecovery(trigger);
            this.lockManager.unlockAcquiredTrigger(trigger);
        }
    }

    public OperableTrigger doRecovery(OperableTrigger trigger) throws JobPersistenceException {
        OperableTrigger recoveryTrigger = null;
        if (this.jobDao.requestsRecovery(trigger.getJobKey())) {
            recoveryTrigger = this.recoverTrigger(trigger);
            if (!this.wasOneShotTrigger(trigger)) {
                this.updateMisfires(trigger);
            }
        } else if (this.wasOneShotTrigger(trigger)) {
            this.cleanUpFailedRun(trigger);
        } else {
            this.updateMisfires(trigger);
        }
        return recoveryTrigger;
    }

    private OperableTrigger recoverTrigger(OperableTrigger trigger) throws JobPersistenceException {
        log.info("Recovering trigger: {}", (Object)trigger.getKey());
        OperableTrigger recoveryTrigger = this.recoveryTriggerFactory.from(trigger);
        this.persister.storeTrigger(recoveryTrigger, false);
        return recoveryTrigger;
    }

    private void updateMisfires(OperableTrigger trigger) throws JobPersistenceException {
        if (this.misfireHandler.applyMisfireOnRecovery(trigger)) {
            log.info("Misfire applied. Replacing trigger: {}", (Object)trigger.getKey());
            this.persister.storeTrigger(trigger, true);
        } else {
            log.warn("Recovery misfire not applied for trigger: {}", (Object)trigger.getKey());
        }
    }

    private void cleanUpFailedRun(OperableTrigger trigger) {
        this.persister.removeTrigger(trigger.getKey());
    }

    private boolean wasOneShotTrigger(OperableTrigger trigger) {
        return trigger.getNextFireTime() == null && trigger.getStartTime().equals(trigger.getFinalFireTime());
    }
}

