/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.trigger;

import com.novemberain.quartz.mongodb.dao.CalendarDao;
import java.util.Date;
import org.quartz.Calendar;
import org.quartz.JobPersistenceException;
import org.quartz.Trigger;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;

public class MisfireHandler {
    private final CalendarDao calendarDao;
    private final SchedulerSignaler signaler;
    private final long misfireThreshold;

    public MisfireHandler(CalendarDao calendarDao, SchedulerSignaler signaler, long misfireThreshold) {
        this.calendarDao = calendarDao;
        this.signaler = signaler;
        this.misfireThreshold = misfireThreshold;
    }

    public boolean applyMisfireOnRecovery(OperableTrigger trigger) throws JobPersistenceException {
        if (trigger.getMisfireInstruction() == -1) {
            return false;
        }
        Calendar cal = null;
        if (trigger.getCalendarName() != null) {
            cal = this.retrieveCalendar(trigger);
        }
        this.signaler.notifyTriggerListenersMisfired((Trigger)trigger);
        trigger.updateAfterMisfire(cal);
        return trigger.getNextFireTime() != null;
    }

    public boolean applyMisfire(OperableTrigger trigger) throws JobPersistenceException {
        Date fireTime = trigger.getNextFireTime();
        if (this.misfireIsNotApplicable(trigger, fireTime)) {
            return false;
        }
        Calendar cal = this.retrieveCalendar(trigger);
        this.signaler.notifyTriggerListenersMisfired((Trigger)((OperableTrigger)trigger.clone()));
        trigger.updateAfterMisfire(cal);
        if (trigger.getNextFireTime() == null) {
            this.signaler.notifySchedulerListenersFinalized((Trigger)trigger);
        } else if (fireTime.equals(trigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    private long calculateMisfireTime() {
        long misfireTime = System.currentTimeMillis();
        if (this.misfireThreshold > 0L) {
            misfireTime -= this.misfireThreshold;
        }
        return misfireTime;
    }

    private boolean misfireIsNotApplicable(OperableTrigger trigger, Date fireTime) {
        return fireTime == null || this.isNotMisfired(fireTime) || trigger.getMisfireInstruction() == -1;
    }

    private boolean isNotMisfired(Date fireTime) {
        return this.calculateMisfireTime() < fireTime.getTime();
    }

    private Calendar retrieveCalendar(OperableTrigger trigger) throws JobPersistenceException {
        return this.calendarDao.retrieveCalendar(trigger.getCalendarName());
    }
}

