/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.edgecache.component;

import com.nuxeo.edgecache.service.EdgeCacheServer;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class EdgeCacheServerWriter
extends AbstractJsonWriter<EdgeCacheServer> {
    public static final String ENTITY_TYPE = "edgecacheserver";

    public void write(EdgeCacheServer token, JsonGenerator jg) throws IOException {
        EdgeCacheServerWriter.writeObject(token, jg);
    }

    public static void writeObject(EdgeCacheServer token, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", ENTITY_TYPE);
        jg.writeStringField("id", token.getId());
        jg.writeStringField("deviceId", token.getDeviceId());
        jg.writeStringField("ipRanges", token.getIpRanges());
        jg.writeStringField("url", token.getUrl());
        DateTimeFormatter dateTime = ISODateTimeFormat.dateTime();
        jg.writeStringField("creationDate", dateTime.print((ReadableInstant)new DateTime((Object)token.getCreationDate())));
        jg.writeNumberField("ttl", token.getTTL().intValue());
        jg.writeStringField("lastPing", dateTime.print((ReadableInstant)new DateTime((Object)token.getLastPing())));
        jg.writeBooleanField("alive", token.alive());
        jg.writeEndObject();
    }
}

