/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.edgecache.download;

import com.google.gson.Gson;
import com.nuxeo.edgecache.service.EdgeCacheServer;
import com.nuxeo.edgecache.service.EdgeCacheService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Map;
import javax.crypto.NoSuchPaddingException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.io.download.DownloadHelper;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.runtime.api.Framework;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DownloadServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.handleDownload(req, resp);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (IOException ioe) {
            DownloadHelper.handleClientDisconnect((IOException)ioe);
        }
    }

    protected void handleDownload(HttpServletRequest request, HttpServletResponse response) throws IOException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidKeySpecException, InvalidParameterSpecException {
        EdgeCacheService edgeCacheService = (EdgeCacheService)Framework.getService(EdgeCacheService.class);
        String tokenId = request.getHeader("X-Authentication-Token");
        if (tokenId == null) {
            response.sendError(403);
            return;
        }
        EdgeCacheServer edgeCacheServer = edgeCacheService.getServer(tokenId);
        if (edgeCacheServer == null) {
            response.sendError(403);
            return;
        }
        try {
            long contentLength;
            DownloadService.ByteRange byteRange;
            String digest = request.getRequestURI().substring(request.getRequestURI().lastIndexOf(47) + 1);
            String token = request.getParameter("token");
            if (token == null) {
                return;
            }
            Map tokenInfo = (Map)new Gson().fromJson(edgeCacheService.decryptString(edgeCacheService.getTokenKey(edgeCacheServer, digest), token), Map.class);
            if (!tokenInfo.containsKey("providerId")) {
                return;
            }
            String providerId = (String)tokenInfo.get("providerId");
            BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
            Binary binary = blobManager.getBlobProvider(providerId).getBinaryManager().getBinary(digest);
            OutputStream output = edgeCacheService.encryptStream(edgeCacheService.getBinaryKey(digest), (OutputStream)response.getOutputStream());
            String etag = '\"' + binary.getDigest() + '\"';
            response.setHeader("ETag", etag);
            String ifNoneMatch = request.getHeader("If-None-Match");
            if (ifNoneMatch != null) {
                boolean match = false;
                if (ifNoneMatch.equals("*")) {
                    match = true;
                } else {
                    for (String previousEtag : StringUtils.split((String)ifNoneMatch, (String)", ")) {
                        if (!previousEtag.equals(etag)) continue;
                        match = true;
                        break;
                    }
                }
                if (match) {
                    String method = request.getMethod();
                    if (method.equals("GET") || method.equals("HEAD")) {
                        response.sendError(304);
                    } else {
                        response.sendError(412);
                    }
                    return;
                }
            }
            long length = 0L;
            response.setHeader("Accept-Ranges", "bytes");
            String range = request.getHeader("Range");
            if (length <= 0L) {
                range = null;
            }
            if (StringUtils.isBlank((String)range)) {
                byteRange = null;
            } else {
                byteRange = DownloadHelper.parseRange((String)range, (long)length);
                if (byteRange == null) {
                    log.error((Object)("Invalid byte range received: " + range));
                } else {
                    response.setHeader("Content-Range", "bytes " + byteRange.getStart() + "-" + byteRange.getEnd() + "/" + length);
                    response.setStatus(206);
                }
            }
            long l = contentLength = byteRange == null ? length : byteRange.getLength();
            if (contentLength < Integer.MAX_VALUE && contentLength > 0L) {
                response.setContentLength((int)contentLength);
            }
            IOUtils.copy((InputStream)binary.getStream(), (OutputStream)output);
            output.close();
        }
        catch (IOException ioe) {
            DownloadHelper.handleClientDisconnect((IOException)ioe);
        }
    }
}

