/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.edgecache.download;

import com.nuxeo.edgecache.service.EdgeCacheServer;
import com.nuxeo.edgecache.service.EdgeCacheService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.io.download.DefaultRedirectResolver;
import org.nuxeo.runtime.api.Framework;

public class EdgeCacheRedirectResolver
extends DefaultRedirectResolver {
    private static final Log log = LogFactory.getLog(EdgeCacheRedirectResolver.class);

    public URI getURI(Blob blob, BlobManager.UsageHint usage, HttpServletRequest request) throws IOException {
        EdgeCacheService service = (EdgeCacheService)Framework.getLocalService(EdgeCacheService.class);
        String address = request.getRemoteAddr();
        if (request.getHeader("X-Real-IP") != null) {
            address = request.getHeader("X-Real-IP").trim();
        }
        if (request.getHeader("X-Forwarded-For") != null) {
            String[] values = request.getHeader("X-Forwarded-For").split(",");
            address = values[0].trim();
        }
        EdgeCacheServer server = service.getEdgeCacheServerForIpV4(address);
        String downloadToken = service.getDownloadToken(server, blob);
        if (server != null && downloadToken != null) {
            try {
                String url = server.getUrl();
                if (!url.startsWith("http")) {
                    url = "http://" + url;
                }
                return new URL(url + "/" + blob.getDigest() + "?token=" + URLEncoder.encode(downloadToken, "UTF-8")).toURI();
            }
            catch (MalformedURLException | URISyntaxException | PropertyException e) {
                log.warn((Object)"Can't redirect to EdgeCacheServer", e);
            }
        }
        return super.getURI(blob, usage, request);
    }
}

