/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.edgecache.service;

import java.util.Calendar;
import java.util.UUID;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Session;

public class EdgeCacheServer {
    public static final String DIRECTORY_SCHEMA = "edgecachetoken";
    public static final String TOKEN_FIELD = "token";
    public static final String DEVICE_ID_FIELD = "deviceId";
    public static final String IPRANGE_FIELD = "ipRanges";
    public static final String URL_FIELD = "url";
    public static final String CREATION_DATE_FIELD = "creationDate";
    public static final String LAST_PING_FIELD = "lastTTL";
    private static final String TTL_FIELD = "ttl";
    protected final DocumentModel doc;

    public EdgeCacheServer(String deviceId, String url, String ipRanges, Integer ttl, Session session) {
        UUID uuid = UUID.randomUUID();
        DocumentModel entry = BaseSession.createEntryModel(null, (String)DIRECTORY_SCHEMA, null, null);
        entry.setProperty(DIRECTORY_SCHEMA, TOKEN_FIELD, (Object)uuid.toString());
        entry.setProperty(DIRECTORY_SCHEMA, DEVICE_ID_FIELD, (Object)deviceId);
        entry.setProperty(DIRECTORY_SCHEMA, URL_FIELD, (Object)url);
        entry.setProperty(DIRECTORY_SCHEMA, IPRANGE_FIELD, (Object)ipRanges);
        Calendar creationDate = Calendar.getInstance();
        creationDate.setTimeInMillis(System.currentTimeMillis());
        entry.setProperty(DIRECTORY_SCHEMA, CREATION_DATE_FIELD, (Object)creationDate);
        entry.setProperty(DIRECTORY_SCHEMA, LAST_PING_FIELD, (Object)creationDate);
        entry.setProperty(DIRECTORY_SCHEMA, TTL_FIELD, (Object)ttl);
        this.doc = session != null ? session.createEntry(entry) : entry;
    }

    public void ping() {
        Calendar creationDate = Calendar.getInstance();
        creationDate.setTimeInMillis(System.currentTimeMillis());
        this.doc.setProperty(DIRECTORY_SCHEMA, LAST_PING_FIELD, (Object)creationDate);
    }

    public Calendar getLastPing() {
        return (Calendar)this.doc.getPropertyValue("edgecachetoken:lastTTL");
    }

    public boolean alive() {
        Calendar ttl = (Calendar)this.doc.getProperty(DIRECTORY_SCHEMA, LAST_PING_FIELD);
        ttl.add(13, this.getTTL());
        return ttl.after(Calendar.getInstance());
    }

    public EdgeCacheServer(DocumentModel doc) {
        this.doc = doc;
    }

    public DocumentModel getDoc() {
        return this.doc;
    }

    public String getToken(Blob blob) {
        return "";
    }

    public void save(Session session) {
        session.updateEntry(this.doc);
    }

    public String getIpRanges() {
        return (String)((Object)this.doc.getPropertyValue("edgecachetoken:ipRanges"));
    }

    public void setIpRanges(String ipRanges) {
        this.doc.setProperty(DIRECTORY_SCHEMA, IPRANGE_FIELD, (Object)ipRanges);
    }

    public String getId() {
        return this.doc.getId();
    }

    public void setUrl(String url) {
        this.doc.setProperty(DIRECTORY_SCHEMA, URL_FIELD, (Object)url);
    }

    public String getUrl() {
        return (String)((Object)this.doc.getPropertyValue("edgecachetoken:url"));
    }

    public String getDeviceId() {
        return (String)((Object)this.doc.getPropertyValue("edgecachetoken:deviceId"));
    }

    public void setDeviceId(String deviceId) {
        this.doc.setProperty(DIRECTORY_SCHEMA, DEVICE_ID_FIELD, (Object)deviceId);
    }

    public Calendar getCreationDate() {
        return (Calendar)this.doc.getPropertyValue("edgecachetoken:creationDate");
    }

    public void setTTL(Integer ttl) {
        this.doc.setProperty(DIRECTORY_SCHEMA, TTL_FIELD, (Object)ttl);
    }

    public Integer getTTL() {
        return ((Long)this.doc.getPropertyValue("edgecachetoken:ttl")).intValue();
    }
}

