/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.edgecache.service;

import com.google.gson.Gson;
import com.nuxeo.edgecache.model.EdgeServerConfiguration;
import com.nuxeo.edgecache.service.EdgeCacheServer;
import com.nuxeo.edgecache.service.EdgeCacheService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.xerces.impl.dv.util.Base64;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class EdgeCacheServiceImpl
extends DefaultComponent
implements EdgeCacheService {
    private static final long serialVersionUID = 14861634984034462L;
    private static final Log log = LogFactory.getLog(EdgeCacheServiceImpl.class);
    public static final String DIRECTORY_NAME = "edgeCacheTokens";
    private static final String AES = "AES";
    protected static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5Padding";
    protected long expirationInterval = 3600000L;

    public EdgeCacheServiceImpl() {
        EdgeCacheServiceImpl.setUnlimitedJCEPolicy();
    }

    protected static void setUnlimitedJCEPolicy() {
        try {
            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            field.setAccessible(true);
            if (Boolean.TRUE.equals(field.get(null))) {
                log.info((Object)"Setting JCE Unlimited Strength");
                field.set(null, Boolean.FALSE);
            }
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            log.debug((Object)"Cannot check/set JCE Unlimited Strength", (Throwable)e);
        }
    }

    @Override
    public EdgeServerConfiguration pingServer(String tokenId) {
        this.updateServer(tokenId, null, null, null);
        return EdgeServerConfiguration.getSingleton();
    }

    @Override
    public void updateServer(String tokenId, String ipRanges, String url, Integer ttl) {
        EdgeCacheServer currentToken = this.getToken(tokenId, "token");
        if (currentToken == null) {
            return;
        }
        if (url != null) {
            currentToken.setUrl(url);
        }
        if (ipRanges != null) {
            if (!this.validateRanges(ipRanges)) {
                throw new IllegalArgumentException("ipRanges");
            }
            currentToken.setIpRanges(ipRanges);
        }
        if (ttl != null) {
            currentToken.setTTL(ttl);
        }
        currentToken.ping();
        Framework.doPrivileged(() -> {
            DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
            try (Session session = directoryService.open(DIRECTORY_NAME);){
                currentToken.save(session);
            }
        });
    }

    @Override
    public EdgeCacheServer registerServer(String deviceId, String ipRanges, String url, Integer ttl) {
        EdgeCacheServer currentToken = this.getToken(deviceId, "deviceId");
        if (currentToken != null) {
            return currentToken;
        }
        if (!this.validateRanges(ipRanges)) {
            throw new IllegalArgumentException("IP Ranges is invalid");
        }
        return (EdgeCacheServer)Framework.doPrivileged(() -> {
            DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
            try (Session session = directoryService.open(DIRECTORY_NAME);){
                EdgeCacheServer token = new EdgeCacheServer(deviceId, url, ipRanges, ttl, session);
                log.debug((Object)String.format("Generated unique token for a Edge Cache (url, ipRanges, deviceId) triplet: ('%s', '%s', '%s'), returning it.", url, ipRanges, deviceId));
                EdgeCacheServer edgeCacheServer = token;
                return edgeCacheServer;
            }
        });
    }

    public boolean validateRanges(String ipRanges) {
        Boolean result = true;
        Pattern p = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})(\\/(\\d{1,2}))?");
        for (String range : ipRanges.split(";")) {
            Matcher m = p.matcher(range.trim());
            if (!m.matches() || m.group(0).length() != range.trim().length()) {
                result = false;
                break;
            }
            for (int i = 1; i < 5; ++i) {
                result = result & Integer.valueOf(m.group(i)) < 256;
            }
            if (m.group(6) == null) continue;
            result = result & Integer.valueOf(m.group(6)) < 33;
        }
        return result;
    }

    @Override
    public EdgeCacheServer getServer(String tokenId) {
        return this.getToken(tokenId, "token");
    }

    public EdgeCacheServer getToken(String tokenId, String field) {
        return (EdgeCacheServer)Framework.doPrivileged(() -> {
            try (Session session = ((DirectoryService)Framework.getService(DirectoryService.class)).open(DIRECTORY_NAME);){
                HashMap<String, String> filter = new HashMap<String, String>();
                filter.put(field, tokenId);
                DocumentModelList tokens = session.query(filter);
                if (!tokens.isEmpty()) {
                    if (tokens.size() > 1) {
                        throw new NuxeoException(String.format("Found multiple tokens for the tokenId '%s', this is inconsistent.", tokenId));
                    }
                    EdgeCacheServer edgeCacheServer = new EdgeCacheServer((DocumentModel)tokens.get(0));
                    return edgeCacheServer;
                }
                log.debug((Object)String.format("No Edge Cache registration found for tokenId: '%s', returning null.", tokenId));
                EdgeCacheServer edgeCacheServer = null;
                return edgeCacheServer;
            }
        });
    }

    @Override
    public void unregisterServer(String token) {
        Framework.doPrivileged(() -> {
            try (Session session = ((DirectoryService)Framework.getService(DirectoryService.class)).open(DIRECTORY_NAME);){
                session.deleteEntry(token);
                log.info((Object)String.format("Unregister Edge Cache: '%s' from the back-end.", token));
            }
        });
    }

    protected Integer inRange(String range, String ip) {
        String mask = "32";
        if (range.contains("/")) {
            mask = range.split("/")[1];
            range = range.split("/")[0];
        } else if (ip.equals(range)) {
            return 32;
        }
        if (new SubnetUtils(range + "/" + mask).getInfo().isInRange(ip)) {
            return Integer.valueOf(mask);
        }
        return 0;
    }

    protected Integer inRanges(String ranges, String ip) {
        Integer result = 0;
        for (String range : ranges.split(";")) {
            Integer current = this.inRange(range, ip);
            if (current <= result) continue;
            result = current;
        }
        return result;
    }

    @Override
    public EdgeCacheServer getEdgeCacheServerForIpV4(String ip) {
        List<EdgeCacheServer> servers = this.getEdgeCacheServers();
        Integer current = 0;
        EdgeCacheServer result = null;
        Integer resultDistance = 0;
        for (EdgeCacheServer server : servers) {
            String ranges;
            if (!server.alive() || (current = this.inRanges(ranges = server.getIpRanges(), ip)) <= resultDistance) continue;
            resultDistance = current;
            result = server;
        }
        return result;
    }

    @Override
    public List<EdgeCacheServer> getEdgeCacheServers() {
        return (List)Framework.doPrivileged(() -> {
            try (Session session = ((DirectoryService)Framework.getService(DirectoryService.class)).open(DIRECTORY_NAME);){
                HashMap filter = new HashMap();
                HashMap<String, String> orderBy = new HashMap<String, String>();
                orderBy.put("creationDate", "desc");
                LinkedList<EdgeCacheServer> list = new LinkedList<EdgeCacheServer>();
                for (DocumentModel doc : session.query(filter, Collections.emptySet(), orderBy)) {
                    list.add(new EdgeCacheServer(doc));
                }
                LinkedList<EdgeCacheServer> linkedList = list;
                return linkedList;
            }
        });
    }

    @Override
    public byte[] getBinaryKey(String digest) {
        try {
            return DigestUtils.sha256((String)(LogicalInstanceIdentifier.instance().getCLID2() + digest));
        }
        catch (LogicalInstanceIdentifier.NoCLID e) {
            log.error((Object)"EdgeCache Service requires a registered instance of Nuxeo");
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public String getDownloadToken(EdgeCacheServer server, Blob blob) {
        return this.getDownloadToken(server, blob, BlobManager.UsageHint.DOWNLOAD);
    }

    @Override
    public String getDownloadToken(EdgeCacheServer server, Blob blob, BlobManager.UsageHint usage) {
        if (!(blob instanceof ManagedBlob) || server == null) {
            return null;
        }
        ManagedBlob managedBlob = (ManagedBlob)blob;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("binaryKey", Base64.encode((byte[])this.getBinaryKey(blob.getDigest())));
        params.put("digest", blob.getDigest());
        params.put("providerId", managedBlob.getProviderId());
        params.put("mimetype", blob.getMimeType());
        params.put("filename", blob.getFilename());
        params.put("expire", String.valueOf(new Date().getTime() + this.expirationInterval));
        params.put("usage", usage.name());
        return this.encryptString(this.getTokenKey(server, blob.getDigest()), new Gson().toJson(params));
    }

    @Override
    public byte[] getTokenKey(EdgeCacheServer server, String digest) {
        return DigestUtils.sha256((String)(server.getDeviceId() + digest));
    }

    private SecretKeySpec getKey(byte[] key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new SecretKeySpec(key, AES);
    }

    @Override
    public String decryptString(byte[] key, String value) {
        try {
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(2, this.getKey(key));
            return new String(cipher.doFinal(Base64.decode((String)value)), "UTF-8");
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public String encryptString(byte[] key, String value) {
        try {
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(1, this.getKey(key));
            byte[] encrypted = cipher.doFinal(value.getBytes("UTF-8"));
            return Base64.encode((byte[])encrypted);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public OutputStream encryptStream(byte[] key, OutputStream output) {
        try {
            DataOutputStream data = new DataOutputStream(output);
            Cipher enc = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
            enc.init(1, this.getKey(key));
            byte[] iv = enc.getIV();
            data.writeInt(iv.length);
            data.write(iv);
            return new CipherOutputStream(output, enc);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void decryptStream(byte[] key, InputStream input, OutputStream output) {
        try {
            DataInputStream data = new DataInputStream(input);
            int ivLen = data.readInt();
            if (ivLen <= 0) {
                throw new NuxeoException("Invalid IV length: " + ivLen);
            }
            byte[] iv = new byte[ivLen];
            data.read(iv, 0, ivLen);
            Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
            cipher.init(2, (Key)this.getKey(key), new IvParameterSpec(iv));
            try (CipherInputStream cipherIn = new CipherInputStream(input, cipher);){
                IOUtils.copy((InputStream)cipherIn, (OutputStream)output);
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof BadPaddingException) {
                    throw new NuxeoException(cause.getMessage(), (Throwable)e);
                }
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
            throw new NuxeoException((Throwable)e);
        }
    }
}

