/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.edgecache;

import com.nuxeo.edgecache.model.EdgeServerConfiguration;
import com.nuxeo.edgecache.service.EdgeCacheServer;
import com.nuxeo.edgecache.service.EdgeCacheService;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="edgecache")
@Produces(value={"application/json"})
public class EdgeCacheServerObject
extends AbstractResource<ResourceTypeImpl> {
    private EdgeCacheService edgeCacheService;

    protected void initialize(Object ... args) {
        this.edgeCacheService = (EdgeCacheService)Framework.getService(EdgeCacheService.class);
    }

    @POST
    public Response registerServer(@QueryParam(value="deviceId") String deviceId, @QueryParam(value="ipRanges") String ipRanges, @QueryParam(value="url") String url, @QueryParam(value="ttl") Integer ttl) {
        if (!((NuxeoPrincipal)this.ctx.getPrincipal()).isAdministrator()) {
            return Response.ok().status(Response.Status.FORBIDDEN).build();
        }
        try {
            EdgeCacheServer token = this.edgeCacheService.registerServer(deviceId, ipRanges, url, Integer.valueOf(ttl == null ? 30 : ttl));
            return Response.ok((Object)token).status(Response.Status.CREATED).build();
        }
        catch (IllegalArgumentException e) {
            return Response.ok().status(Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    public List<EdgeCacheServer> getServers(@QueryParam(value="deviceId") String deviceId, @QueryParam(value="ipRanges") String ipRanges, @QueryParam(value="url") String url) {
        return this.edgeCacheService.getEdgeCacheServers();
    }

    @DELETE
    @Path(value="{uid}")
    public Response unregisterServer(@PathParam(value="uid") String tokenId) {
        if (tokenId == null) {
            return Response.ok().status(Response.Status.NOT_FOUND).build();
        }
        this.edgeCacheService.unregisterServer(tokenId);
        return Response.ok().status(Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="{uid}/ping")
    @Produces(value={"application/json"})
    public Response pingServer(@PathParam(value="uid") String tokenId) {
        EdgeServerConfiguration result;
        if (tokenId == null) {
            return Response.ok().status(Response.Status.NOT_FOUND).build();
        }
        try {
            result = this.edgeCacheService.pingServer(tokenId);
        }
        catch (IllegalArgumentException e) {
            return Response.ok().status(Response.Status.BAD_REQUEST).build();
        }
        return Response.ok((Object)result).build();
    }

    @PUT
    @Path(value="{uid}")
    public Response updateServer(@PathParam(value="uid") String tokenId, @QueryParam(value="ipRanges") String ipRanges, @QueryParam(value="url") String url, @QueryParam(value="ttl") Integer ttl) {
        if (tokenId == null) {
            return Response.ok().status(Response.Status.NOT_FOUND).build();
        }
        try {
            this.edgeCacheService.updateServer(tokenId, ipRanges, url, Integer.valueOf(ttl == null ? 30 : ttl));
        }
        catch (IllegalArgumentException e) {
            return Response.ok().status(Response.Status.BAD_REQUEST).build();
        }
        return Response.ok().status(Response.Status.NO_CONTENT).build();
    }
}

