/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.intranet.jenkins.web;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

@Name(value="jenkinsJobsActions")
@Scope(value=ScopeType.EVENT)
public class JenkinsJobsActions {
    public String getConvertedJobComment(String toConvert, String jiraURL, String[] jiraProjects) {
        if (toConvert == null) {
            return null;
        }
        if (StringUtils.isBlank((String)jiraURL) || jiraProjects == null || jiraProjects.length == 0) {
            toConvert = toConvert.replace("\n", "<br />\n");
            return toConvert;
        }
        String res = "";
        String regexp = "\\b(" + StringUtils.join((Object[])jiraProjects, (String)"|") + ")-\\d+\\b";
        Pattern pattern = Pattern.compile(regexp, 2);
        Matcher m = pattern.matcher(toConvert);
        int lastIndex = 0;
        boolean done = false;
        while (m.find()) {
            String jiraIssue = m.group(0);
            res = res + toConvert.substring(lastIndex, m.start()) + this.getJiraUrlTag(jiraURL, jiraIssue);
            lastIndex = m.end();
            done = true;
        }
        res = done ? res + toConvert.substring(lastIndex) : toConvert;
        res = res.replace("\n", "<br />\n");
        return res;
    }

    protected String getJiraUrlTag(String jiraURL, String jiraIssue) {
        return "<a href=\"" + jiraURL + jiraIssue.toUpperCase() + "\" target=\"_blank\">" + jiraIssue.toUpperCase() + "</a>";
    }
}

