/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.beans;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.QueryParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.util.FacesElUtils;
import com.ocpsoft.pretty.faces.util.FacesStateUtils;
import com.ocpsoft.pretty.faces.util.NullComponent;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

public class ParameterInjector {
    private static final Log log = LogFactory.getLog(ParameterInjector.class);
    private static final FacesElUtils elUtils = new FacesElUtils();

    public void injectParameters(FacesContext context) {
        log.trace("Injecting parameters");
        PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
        URL url = prettyContext.getRequestURL();
        UrlMapping mapping = prettyContext.getConfig().getMappingForUrl(url);
        if (mapping != null) {
            this.injectPathParams(context, url, mapping);
            this.injectQueryParams(context, mapping, prettyContext);
        }
    }

    private void injectPathParams(FacesContext context, URL url, UrlMapping mapping) {
        if (!mapping.isOnPostback() && FacesStateUtils.isPostback(context)) {
            return;
        }
        List<PathParameter> params = mapping.getPatternParser().parse(url);
        for (PathParameter param : params) {
            String el = param.getExpression().getELExpression();
            if (el == null || "".equals(el.trim())) continue;
            String valueAsString = param.getValue();
            try {
                Class<?> expectedType = elUtils.getExpectedType(context, el);
                Converter converter = context.getApplication().createConverter(expectedType);
                if (converter != null) {
                    Object convertedValue = converter.getAsObject(context, (UIComponent)new NullComponent(), valueAsString);
                    elUtils.setValue(context, el, convertedValue);
                    continue;
                }
                elUtils.setValue(context, el, valueAsString);
            }
            catch (Exception e) {
                throw new PrettyException("PrettyFaces: Exception occurred while processing <" + mapping.getId() + ":" + el + "> for URL <" + url + ">", e);
            }
        }
    }

    private void injectQueryParams(FacesContext context, UrlMapping mapping, PrettyContext prettyContext) {
        boolean isPostback = FacesStateUtils.isPostback(context);
        List<QueryParameter> params = mapping.getQueryParams();
        QueryString queryString = prettyContext.getRequestQueryString();
        for (QueryParameter param : params) {
            String el;
            if (!param.isOnPostback() && isPostback || (el = param.getExpression().getELExpression()) == null || "".equals(el.trim())) continue;
            String name = param.getName();
            if (!queryString.getParameterMap().containsKey(name)) continue;
            try {
                if (elUtils.getExpectedType(context, el).isArray()) {
                    String[] values = queryString.getParameterValues(name);
                    elUtils.setValue(context, el, values);
                    continue;
                }
                String valueAsString = queryString.getParameter(name);
                Class<?> expectedType = elUtils.getExpectedType(context, el);
                Converter converter = context.getApplication().createConverter(expectedType);
                if (converter != null) {
                    Object convertedValue = converter.getAsObject(context, (UIComponent)new NullComponent(), valueAsString);
                    elUtils.setValue(context, el, convertedValue);
                    continue;
                }
                elUtils.setValue(context, el, valueAsString);
            }
            catch (Exception e) {
                throw new PrettyException("PrettyFaces: Exception occurred while processing mapping<" + mapping.getId() + ":" + el + "> for query parameter named<" + name + "> " + e.getMessage(), e);
            }
        }
    }
}

