/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config;

import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import com.ocpsoft.pretty.faces.url.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyConfig {
    public static final String CONFIG_REQUEST_KEY = "pretty_CONFIG_REQUEST_KEY";
    private List<UrlMapping> mappings = new ArrayList<UrlMapping>();
    private List<RewriteRule> globalRewriteRules = new ArrayList<RewriteRule>();
    private String dynaviewId = "";
    private Map<String, UrlMapping> cachedMappings = new HashMap<String, UrlMapping>();

    public void setDynaviewId(String facesDynaViewId) {
        this.dynaviewId = facesDynaViewId;
    }

    public String getDynaviewId() {
        return this.dynaviewId;
    }

    public List<RewriteRule> getGlobalRewriteRules() {
        return this.globalRewriteRules;
    }

    public void setGlobalRewriteRules(List<RewriteRule> rules) {
        this.globalRewriteRules = Collections.unmodifiableList(rules);
    }

    public List<UrlMapping> getMappings() {
        return Collections.unmodifiableList(this.mappings);
    }

    public void setMappings(List<UrlMapping> mappings) {
        this.mappings = Collections.unmodifiableList(mappings);
    }

    public UrlMapping getMappingForUrl(URL url) {
        String mappingKey = url.toURL();
        if (this.cachedMappings.containsKey(mappingKey)) {
            return this.cachedMappings.get(mappingKey);
        }
        for (UrlMapping mapping : this.getMappings()) {
            if (!mapping.matches(url)) continue;
            if (!mapping.getPatternParser().isElPattern()) {
                this.cachedMappings.put(mappingKey, mapping);
            }
            return mapping;
        }
        return null;
    }

    public boolean isMappingId(String id) {
        UrlMapping mapping = this.getMappingById(id);
        return mapping instanceof UrlMapping;
    }

    public boolean isURLMapped(URL url) {
        UrlMapping mapping = this.getMappingForUrl(url);
        return mapping != null;
    }

    public boolean isViewMapped(String viewId) {
        if (viewId != null) {
            viewId = viewId.trim();
            for (UrlMapping mapping : this.mappings) {
                if (!viewId.equals(mapping.getViewId()) && (!viewId.startsWith("/") || !viewId.substring(1).equals(mapping.getViewId()))) continue;
                return true;
            }
        }
        return false;
    }

    public UrlMapping getMappingById(String id) {
        if (id != null) {
            if (id.startsWith("pretty:")) {
                id = id.substring("pretty:".length());
            }
            for (UrlMapping mapping : this.getMappings()) {
                if (!mapping.getId().equals(id)) continue;
                return mapping;
            }
        }
        return null;
    }

    public String toString() {
        return "PrettyConfig [mappings=" + this.mappings + ", globalRewriteRules=" + this.globalRewriteRules + "]";
    }
}

