/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.el.resolver;

import com.ocpsoft.pretty.faces.spi.ELBeanNameResolver;
import com.ocpsoft.shade.org.apache.commons.logging.Log;
import com.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamBeanNameResolver
implements ELBeanNameResolver {
    private static final Log log = LogFactory.getLog(SeamBeanNameResolver.class);
    private static final String SEAM_CLASS = "org.jboss.seam.Seam";
    private static final String GET_COMPONENT_NAME_METHOD = "getComponentName";
    private Method getComponentNameMethod = null;

    @Override
    public boolean init(ServletContext servletContext, ClassLoader classLoader) {
        try {
            Class<?> seamClass = classLoader.loadClass(SEAM_CLASS);
            this.getComponentNameMethod = seamClass.getMethod(GET_COMPONENT_NAME_METHOD, Class.class);
            if (log.isDebugEnabled()) {
                log.debug("Seam environment detected. Enabling bean name resolving via Seam.");
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug("Seam class has not been found. Seam resolver will be disabled.");
            }
        }
        catch (NoSuchMethodException e) {
            log.warn("Cannot find method getComponentName() on Seam class.", e);
        }
        catch (SecurityException e) {
            log.warn("Unable to init resolver due to security restrictions", e);
        }
        return false;
    }

    @Override
    public String getBeanName(Class<?> clazz) {
        try {
            String result = (String)this.getComponentNameMethod.invoke(null, clazz);
            if (log.isTraceEnabled() && result != null) {
                log.trace("Seam returned name '" + result + "' for class: " + clazz.getName());
            }
            return result;
        }
        catch (IllegalAccessException e) {
            log.warn("Unable to call Seam.getComponentName() due to security restrictions", e);
        }
        catch (InvocationTargetException e) {
            log.error("Failed to invoke Seam.getComponentName()", e);
        }
        return null;
    }
}

