/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.url;

import com.ocpsoft.pretty.faces.url.Metadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URL {
    private Metadata metadata = new Metadata();
    private String originalURL = "";
    private List<String> segments;
    private final Map<String, List<String>> decodedSegments = new HashMap<String, List<String>>();

    public URL(String url) {
        if (url != null) {
            this.originalURL = url.trim();
            if (this.originalURL.endsWith("/")) {
                this.metadata.setTrailingSlash(true);
            }
            if (this.originalURL.startsWith("/")) {
                this.metadata.setLeadingSlash(true);
            }
        } else {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        String trimmedUrl = this.trimSurroundingSlashes(url);
        String[] segments = trimmedUrl.split("/");
        this.segments = Arrays.asList(segments);
    }

    public static URL build(String url) {
        return new URL(url);
    }

    public URL(List<String> segments, Metadata metadata) {
        this.metadata = metadata;
        this.segments = segments;
        this.originalURL = metadata.buildURLFromSegments(segments);
    }

    public static URL build(List<String> segments, Metadata metadata) {
        return new URL(segments, metadata);
    }

    public List<String> getDecodedSegments() {
        String encoding = this.metadata.getEncoding();
        if (!this.decodedSegments.containsKey(encoding)) {
            ArrayList<String> result = new ArrayList<String>();
            for (String segment : this.segments) {
                result.add(URL.decodeSegment(segment));
            }
            this.decodedSegments.put(encoding, Collections.unmodifiableList(result));
        }
        return this.decodedSegments.get(encoding);
    }

    public List<String> getEncodedSegments() {
        ArrayList<String> resultSegments = new ArrayList<String>();
        for (String segment : this.segments) {
            resultSegments.add(URL.encodeSegment(segment));
        }
        return resultSegments;
    }

    private static String encodeSegment(String segment) {
        try {
            URI uri = new URI("http", "localhost", "/" + segment, null);
            return uri.toASCIIString().substring(17);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String decodeSegment(String segment) {
        try {
            URI uri = new URI(("http://localhost/" + segment).replace(" ", "%20").replace("\"", "%22"));
            return uri.getPath().substring(1);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public URL decode() {
        return new URL(this.getDecodedSegments(), this.metadata);
    }

    public URL encode() {
        return new URL(this.getEncodedSegments(), this.metadata);
    }

    public int numSegments() {
        return this.segments.size();
    }

    public String toString() {
        return this.toURL();
    }

    public String toURL() {
        return this.originalURL;
    }

    public List<String> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public boolean hasLeadingSlash() {
        return this.metadata.hasLeadingSlash();
    }

    public boolean hasTrailingSlash() {
        return this.metadata.hasTrailingSlash();
    }

    public String getEncoding() {
        return this.metadata.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.metadata.setEncoding(encoding);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    private String trimSurroundingSlashes(String url) {
        String result = null;
        if (url != null) {
            result = url.trim();
            if (result.startsWith("/")) {
                result = result.substring(1);
            }
            if (result.endsWith("/")) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }
}

