/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.helper;

public final class Range {
    private Integer from = null;
    private Integer to = null;

    private Range() {
    }

    private Range setFrom(int from) {
        if (from < 0) {
            throw new IllegalArgumentException("from value must be greater or equal null.");
        }
        this.from = new Integer(from);
        return this;
    }

    private Range setTo(int to) {
        if (to < 0) {
            throw new IllegalArgumentException("to must be greater or equal null.");
        }
        this.to = new Integer(to);
        return this;
    }

    public String getRangeString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.from != null) {
            sb.append(String.format("%d", this.from));
        }
        sb.append(',');
        if (this.to != null) {
            sb.append(String.format("%d", this.to));
        }
        sb.append('}');
        return sb.toString();
    }

    public static Builder build() {
        return new Builder();
    }

    public static final class Builder {
        private Range range = new Range();

        protected Builder() {
        }

        public FromBuilder from(int f) {
            this.range.setFrom(f);
            return new FromBuilder(this.range);
        }

        public ToBuilder to(int t) {
            this.range.setTo(t);
            return new ToBuilder(this.range);
        }

        public Range only(int only) {
            this.range.from = new Integer(only);
            this.range.to = new Integer(only + 1);
            return this.range;
        }
    }

    public static final class ToBuilder {
        private Range range;

        public ToBuilder(Range range) {
            this.range = range;
        }

        public Range build() {
            return this.range;
        }
    }

    public static final class FromBuilder {
        private Range range;

        public FromBuilder(Range range) {
            this.range = range;
        }

        public Range to(int t) {
            this.range.setTo(t);
            if (this.range.to <= this.range.from) {
                throw new IllegalArgumentException("to must be greater than from");
            }
            return this.range;
        }

        public Range build() {
            return this.range;
        }
    }
}

