/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.CatalogApplication;
import com.okta.sdk.resource.model.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RoleTargetApi {
    private ApiClient apiClient;

    public RoleTargetApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleTargetApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void assignAllAppsAsTargetToRoleForUser(String userId, String roleId) throws ApiException {
        this.assignAllAppsAsTargetToRoleForUser(userId, roleId, Collections.emptyMap());
    }

    public void assignAllAppsAsTargetToRoleForUser(String userId, String roleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling assignAllAppsAsTargetToRoleForUser");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling assignAllAppsAsTargetToRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleId, String appName, String appId) throws ApiException {
        this.assignAppInstanceTargetToAppAdminRoleForGroup(groupId, roleId, appName, appId, Collections.emptyMap());
    }

    public void assignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleId, String appName, String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}/{appId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignAppInstanceTargetToAppAdminRoleForUser(String userId, String roleId, String appName, String appId) throws ApiException {
        this.assignAppInstanceTargetToAppAdminRoleForUser(userId, roleId, appName, appId, Collections.emptyMap());
    }

    public void assignAppInstanceTargetToAppAdminRoleForUser(String userId, String roleId, String appName, String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}/{appId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignAppTargetToAdminRoleForGroup(String groupId, String roleId, String appName) throws ApiException {
        this.assignAppTargetToAdminRoleForGroup(groupId, roleId, appName, Collections.emptyMap());
    }

    public void assignAppTargetToAdminRoleForGroup(String groupId, String roleId, String appName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignAppTargetToAdminRoleForGroup");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling assignAppTargetToAdminRoleForGroup");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling assignAppTargetToAdminRoleForGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignAppTargetToAdminRoleForUser(String userId, String roleId, String appName) throws ApiException {
        this.assignAppTargetToAdminRoleForUser(userId, roleId, appName, Collections.emptyMap());
    }

    public void assignAppTargetToAdminRoleForUser(String userId, String roleId, String appName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling assignAppTargetToAdminRoleForUser");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling assignAppTargetToAdminRoleForUser");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling assignAppTargetToAdminRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignGroupTargetToGroupAdminRole(String groupId, String roleId, String targetGroupId) throws ApiException {
        this.assignGroupTargetToGroupAdminRole(groupId, roleId, targetGroupId, Collections.emptyMap());
    }

    public void assignGroupTargetToGroupAdminRole(String groupId, String roleId, String targetGroupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignGroupTargetToGroupAdminRole");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling assignGroupTargetToGroupAdminRole");
        }
        if (targetGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'targetGroupId' when calling assignGroupTargetToGroupAdminRole");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleId}/targets/groups/{targetGroupId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{targetGroupId\\}", this.apiClient.escapeString(targetGroupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignGroupTargetToUserRole(String userId, String roleId, String groupId) throws ApiException {
        this.assignGroupTargetToUserRole(userId, roleId, groupId, Collections.emptyMap());
    }

    public void assignGroupTargetToUserRole(String userId, String roleId, String groupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling assignGroupTargetToUserRole");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling assignGroupTargetToUserRole");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignGroupTargetToUserRole");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForGroup(String groupId, String roleId, String after, Integer limit) throws ApiException {
        return this.listApplicationTargetsForApplicationAdministratorRoleForGroup(groupId, roleId, after, limit, Collections.emptyMap());
    }

    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForGroup(String groupId, String roleId, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<CatalogApplication>> localVarReturnType = new TypeReference<List<CatalogApplication>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForUser(String userId, String roleId, String after, Integer limit) throws ApiException {
        return this.listApplicationTargetsForApplicationAdministratorRoleForUser(userId, roleId, after, limit, Collections.emptyMap());
    }

    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForUser(String userId, String roleId, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<CatalogApplication>> localVarReturnType = new TypeReference<List<CatalogApplication>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Group> listGroupTargetsForGroupRole(String groupId, String roleId, String after, Integer limit) throws ApiException {
        return this.listGroupTargetsForGroupRole(groupId, roleId, after, limit, Collections.emptyMap());
    }

    public List<Group> listGroupTargetsForGroupRole(String groupId, String roleId, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling listGroupTargetsForGroupRole");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling listGroupTargetsForGroupRole");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleId}/targets/groups".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Group>> localVarReturnType = new TypeReference<List<Group>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Group> listGroupTargetsForRole(String userId, String roleId, String after, Integer limit) throws ApiException {
        return this.listGroupTargetsForRole(userId, roleId, after, limit, Collections.emptyMap());
    }

    public List<Group> listGroupTargetsForRole(String userId, String roleId, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listGroupTargetsForRole");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling listGroupTargetsForRole");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleId}/targets/groups".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Group>> localVarReturnType = new TypeReference<List<Group>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void unassignAppInstanceTargetFromAdminRoleForUser(String userId, String roleId, String appName, String appId) throws ApiException {
        this.unassignAppInstanceTargetFromAdminRoleForUser(userId, roleId, appName, appId, Collections.emptyMap());
    }

    public void unassignAppInstanceTargetFromAdminRoleForUser(String userId, String roleId, String appName, String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}/{appId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unassignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleId, String appName, String appId) throws ApiException {
        this.unassignAppInstanceTargetToAppAdminRoleForGroup(groupId, roleId, appName, appId, Collections.emptyMap());
    }

    public void unassignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleId, String appName, String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}/{appId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unassignAppTargetFromAppAdminRoleForUser(String userId, String roleId, String appName) throws ApiException {
        this.unassignAppTargetFromAppAdminRoleForUser(userId, roleId, appName, Collections.emptyMap());
    }

    public void unassignAppTargetFromAppAdminRoleForUser(String userId, String roleId, String appName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unassignAppTargetFromAppAdminRoleForUser");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling unassignAppTargetFromAppAdminRoleForUser");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling unassignAppTargetFromAppAdminRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleId}/targets/catalog/apps/{appName}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unassignAppTargetToAdminRoleForGroup(String groupId, String roleId, String appName) throws ApiException {
        this.unassignAppTargetToAdminRoleForGroup(groupId, roleId, appName, Collections.emptyMap());
    }

    public void unassignAppTargetToAdminRoleForGroup(String groupId, String roleId, String appName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignAppTargetToAdminRoleForGroup");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling unassignAppTargetToAdminRoleForGroup");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling unassignAppTargetToAdminRoleForGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleId}/targets/catalog/apps/{appName}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unassignGroupTargetFromGroupAdminRole(String groupId, String roleId, String targetGroupId) throws ApiException {
        this.unassignGroupTargetFromGroupAdminRole(groupId, roleId, targetGroupId, Collections.emptyMap());
    }

    public void unassignGroupTargetFromGroupAdminRole(String groupId, String roleId, String targetGroupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignGroupTargetFromGroupAdminRole");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling unassignGroupTargetFromGroupAdminRole");
        }
        if (targetGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'targetGroupId' when calling unassignGroupTargetFromGroupAdminRole");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleId}/targets/groups/{targetGroupId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{targetGroupId\\}", this.apiClient.escapeString(targetGroupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unassignGroupTargetFromUserAdminRole(String userId, String roleId, String groupId) throws ApiException {
        this.unassignGroupTargetFromUserAdminRole(userId, roleId, groupId, Collections.emptyMap());
    }

    public void unassignGroupTargetFromUserAdminRole(String userId, String roleId, String groupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unassignGroupTargetFromUserAdminRole");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling unassignGroupTargetFromUserAdminRole");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignGroupTargetFromUserAdminRole");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleId\\}", this.apiClient.escapeString(roleId.toString())).replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

