/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.common;

import com.okta.commons.lang.Assert;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;

public class PagedList<T>
extends ArrayList<T> {
    private String self;
    private String nextPage;
    private String after;

    public PagedList() {
    }

    public PagedList(List<T> items, String self, String nextPage, String after) {
        super(items);
        this.self = self;
        this.nextPage = nextPage;
        this.after = after;
    }

    public String getSelf() {
        return this.self;
    }

    public String getNextPage() {
        return this.nextPage;
    }

    public String getAfter() {
        try {
            URL url = new URL(this.nextPage);
            this.after = PagedList.splitQuery(url).get("after");
            return this.after;
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            return null;
        }
    }

    public static <T> T constructPagedList(HttpResponse response, T value) {
        Assert.notNull((Object)response);
        Assert.isTrue((boolean)(value instanceof List));
        Header[] linkHeaders = response.getHeaders("link");
        if (linkHeaders == null || linkHeaders.length == 0) {
            return value;
        }
        String nextPage = null;
        String self = null;
        for (Header link : linkHeaders) {
            String[] parts = link.getValue().split("; *");
            String url = parts[0].replaceAll("<", "").replaceAll(">", "");
            String rel = parts[1];
            if (rel.equals("rel=\"next\"")) {
                nextPage = url;
                continue;
            }
            if (!rel.equals("rel=\"self\"")) continue;
            self = url;
        }
        if (nextPage == null && self == null) {
            return value;
        }
        return (T)new PagedList<T>((List)value, self, nextPage, null);
    }

    private static Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        String query = url.getQuery();
        for (String pair : pairs = query.split("&")) {
            int index = pair.indexOf("=");
            query_pairs.put(URLDecoder.decode(pair.substring(0, index), "UTF-8"), URLDecoder.decode(pair.substring(index + 1), "UTF-8"));
        }
        return query_pairs;
    }

    public boolean hasMoreItems() {
        return this.getAfter() != null;
    }
}

