/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.IdentityProviderCredentials;
import com.okta.sdk.resource.model.ProtocolAlgorithms;
import com.okta.sdk.resource.model.ProtocolEndpoint;
import com.okta.sdk.resource.model.ProtocolEndpoints;
import com.okta.sdk.resource.model.ProtocolRelayState;
import com.okta.sdk.resource.model.ProtocolSettings;
import com.okta.sdk.resource.model.ProtocolType;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"algorithms", "credentials", "endpoints", "issuer", "relayState", "scopes", "settings", "type"})
public class Protocol
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ALGORITHMS = "algorithms";
    private ProtocolAlgorithms algorithms;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private IdentityProviderCredentials credentials;
    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    private ProtocolEndpoints endpoints;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private ProtocolEndpoint issuer;
    public static final String JSON_PROPERTY_RELAY_STATE = "relayState";
    private ProtocolRelayState relayState;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private ProtocolSettings settings;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ProtocolType type;

    public Protocol algorithms(ProtocolAlgorithms algorithms) {
        this.algorithms = algorithms;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="algorithms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolAlgorithms getAlgorithms() {
        return this.algorithms;
    }

    @JsonProperty(value="algorithms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithms(ProtocolAlgorithms algorithms) {
        this.algorithms = algorithms;
    }

    public Protocol credentials(IdentityProviderCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IdentityProviderCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(IdentityProviderCredentials credentials) {
        this.credentials = credentials;
    }

    public Protocol endpoints(ProtocolEndpoints endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolEndpoints getEndpoints() {
        return this.endpoints;
    }

    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoints(ProtocolEndpoints endpoints) {
        this.endpoints = endpoints;
    }

    public Protocol issuer(ProtocolEndpoint issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolEndpoint getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(ProtocolEndpoint issuer) {
        this.issuer = issuer;
    }

    public Protocol relayState(ProtocolRelayState relayState) {
        this.relayState = relayState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="relayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolRelayState getRelayState() {
        return this.relayState;
    }

    @JsonProperty(value="relayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelayState(ProtocolRelayState relayState) {
        this.relayState = relayState;
    }

    public Protocol scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public Protocol addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public Protocol settings(ProtocolSettings settings) {
        this.settings = settings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolSettings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(ProtocolSettings settings) {
        this.settings = settings;
    }

    public Protocol type(ProtocolType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProtocolType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(ProtocolType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return Objects.equals(this.algorithms, protocol.algorithms) && Objects.equals(this.credentials, protocol.credentials) && Objects.equals(this.endpoints, protocol.endpoints) && Objects.equals(this.issuer, protocol.issuer) && Objects.equals(this.relayState, protocol.relayState) && Objects.equals(this.scopes, protocol.scopes) && Objects.equals(this.settings, protocol.settings) && Objects.equals((Object)this.type, (Object)protocol.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithms, this.credentials, this.endpoints, this.issuer, this.relayState, this.scopes, this.settings, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Protocol {\n");
        sb.append("    algorithms: ").append(this.toIndentedString(this.algorithms)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    relayState: ").append(this.toIndentedString(this.relayState)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

