/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import oracle.ons.BodyElement;

public class BodySegment {
    private List<BodyElement> eltList = new LinkedList<BodyElement>();
    private List<BodySegment> segList = new ArrayList<BodySegment>();
    private String segName;
    private int nameLen;
    private int level;

    public BodySegment(String segName) {
        this(segName, 0);
    }

    BodySegment(String segName, int level) {
        this.segName = segName;
        this.nameLen = segName.length();
        this.level = level;
    }

    int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.segName;
    }

    public int getNameLength() {
        return this.nameLen;
    }

    public void addElement(BodyElement bodyElement) {
        this.eltList.add(bodyElement);
    }

    public String getElementValue(String eltName) {
        BodyElement bodyElement = null;
        ListIterator<BodyElement> iterator = this.eltList.listIterator(0);
        while (iterator.hasNext() && ((bodyElement = iterator.next()).getNameLength() != eltName.length() || !bodyElement.getName().equals(eltName))) {
            bodyElement = null;
        }
        if (bodyElement == null) {
            return null;
        }
        return bodyElement.getValue();
    }

    public BodyElement getFirstElement() {
        return this.eltList.get(0);
    }

    public BodyElement getElement(int index) {
        return this.eltList.get(index);
    }

    public List getElementList() {
        return this.eltList;
    }

    public List<BodySegment> getSegmentList() {
        return this.segList;
    }

    public void addSegment(BodySegment seg) {
        if (seg == null) {
            return;
        }
        this.segList.add(seg);
    }
}

