/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import oracle.ons.Message;
import oracle.ons.Node;
import oracle.ons.Notification;
import oracle.ons.NotificationNetwork;
import oracle.ons.SubscribePermission;
import oracle.ons.Subscriber;

class SubscriptionProxy {
    private final Map<Integer, WeakReference<Subscriber>> frontendSubscribers = new ConcurrentHashMap<Integer, WeakReference<Subscriber>>();
    private final NotificationNetwork network;
    private final Map<String, Long> notificationHistory = new HashMap<String, Long>();
    private final Queue<String> notificationHistoryTimeouts = new LinkedList<String>();
    private final Object notificationHistoryLock = new Object();
    private final String subscriptionKey;
    protected final Message subscriptionMessage;
    private volatile Notification registrationNotification = null;

    public SubscriptionProxy(NotificationNetwork network, Subscriber subscriber) {
        this.add(subscriber);
        this.subscriptionKey = subscriber.getSubscriptionKey();
        this.subscriptionMessage = subscriber.getSubscriptionMessage();
        this.network = network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate(Notification n) throws InterruptedException {
        ++this.network.messageReceived;
        String nId = n.id();
        if (nId != null) {
            long tick = System.currentTimeMillis();
            Object object = this.notificationHistoryLock;
            synchronized (object) {
                long added;
                if (this.notificationHistory.containsKey(nId)) {
                    ++this.network.messageDropped;
                    return;
                }
                this.notificationHistory.put(nId, tick);
                this.notificationHistoryTimeouts.add(nId);
                tick -= this.network.config.getNotificationWindow();
                while (!this.notificationHistoryTimeouts.isEmpty() && (added = this.notificationHistory.get(nId = this.notificationHistoryTimeouts.peek()).longValue()) < tick) {
                    this.notificationHistory.remove(nId);
                    this.notificationHistoryTimeouts.remove();
                }
            }
        }
        for (WeakReference<Subscriber> s : this.frontendSubscribers.values()) {
            Subscriber subscriber = (Subscriber)s.get();
            if (subscriber == null) continue;
            subscriber.put(n);
        }
    }

    public void add(Subscriber s) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SubscribePermission("ONSUser"));
        }
        this.frontendSubscribers.put(s.id, new WeakReference<Subscriber>(s));
        if (this.registrationNotification != null) {
            try {
                s.put(this.registrationNotification);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    synchronized void setRegistrationNotification(Notification n) {
        this.registrationNotification = n;
        for (WeakReference<Subscriber> s : this.frontendSubscribers.values()) {
            Subscriber subscriber = (Subscriber)s.get();
            if (subscriber == null || subscriber.isOpen()) continue;
            try {
                subscriber.put(n);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void remove(Subscriber subscriber) {
        this.frontendSubscribers.remove(subscriber.id);
    }

    public String getSubscriptionKey() {
        return this.subscriptionKey;
    }

    public boolean isEmpty() {
        return this.frontendSubscribers.isEmpty();
    }

    protected void setServerSubscriberInfo(Node node, String sid) {
        for (WeakReference<Subscriber> s : this.frontendSubscribers.values()) {
            Subscriber subscriber = (Subscriber)s.get();
            if (subscriber == null) continue;
            subscriber.setServerSubscriberInfo(node, sid);
        }
    }
}

