/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.json.OracleJsonValue;

public abstract class OsonAbstractArray
extends OsonStructureImpl {
    public OsonAbstractArray(OsonContext osonContext, int n2) {
        super(osonContext);
        this.init(n2);
    }

    protected OsonAbstractArray(OsonContext osonContext) {
        super(osonContext);
    }

    public String getString(int n2) {
        int n3 = this.getOffsetWithError(n2);
        String string = this.getStringInternal(n3);
        if (string == null) {
            throw new ClassCastException();
        }
        return string;
    }

    public boolean getBoolean(int n2) {
        int n3 = this.getOffsetWithError(n2);
        Boolean bl = this.getBooleanInternal(n3);
        if (bl == null) {
            throw new ClassCastException();
        }
        return bl;
    }

    public boolean getBoolean(int n2, boolean bl) {
        int n3 = this.getChildOffset(n2);
        if (n3 == -1) {
            return bl;
        }
        Boolean bl2 = this.getBooleanInternal(n3);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public int getInt(int n2) {
        int n3 = this.getOffsetWithError(n2);
        return ((OracleJsonNumberImpl)this.getValueInternal(n3)).intValue();
    }

    public int getInt(int n2, int n3) {
        int n4 = this.getChildOffset(n2);
        if (n4 == -1) {
            return n3;
        }
        Object object = this.getValueInternal(n4);
        if (!(object instanceof OracleJsonNumberImpl)) {
            return n3;
        }
        OracleJsonNumberImpl oracleJsonNumberImpl = (OracleJsonNumberImpl)object;
        return oracleJsonNumberImpl.intValue();
    }

    public boolean isNull(int n2) {
        int n3 = this.getOffsetWithError(n2);
        return this.isNullInternal(n3);
    }

    public boolean contains(Object object) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object object2 = this.getValueInternal(this.getChildOffset(i2));
            if (!object2.equals(object)) continue;
            return true;
        }
        return false;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        this.copyToArray(objectArray);
        return objectArray;
    }

    public <T> T[] toArray(T[] TArray) {
        Object[] objectArray = TArray.length >= this.size ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), this.size);
        this.copyToArray(objectArray);
        if (objectArray.length >= this.size + 1) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.size() != this.size) {
            return false;
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object object2 = this.getValueInternal(this.getChildOffset(i2));
            if (object2.equals(list.get(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object object = this.getValueInternal(this.getChildOffset(i2));
            n2 = 31 * n2 + object.hashCode();
        }
        return n2;
    }

    public Object getInternal(int n2) {
        return this.getValueInternal(this.getOffsetWithError(n2));
    }

    public int indexOf(Object object) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!this.getInternal(i2).equals(object)) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!this.getInternal(i2).equals(object)) continue;
            n2 = i2;
        }
        return n2;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.ARRAY;
    }

    @Override
    protected void init(int n2) {
        super.init(n2);
        int n3 = this.ctx.b.getUB1(n2);
        this.initChildOffseUb(n3);
        int n4 = n3 & 0x18;
        this.childArrayOffset = n2 + 1;
        if (n4 == 0) {
            ++this.childArrayOffset;
            this.size = this.ctx.b.getUB1(n2 + 1);
        } else if (n4 == 8) {
            this.childArrayOffset += 2;
            this.size = this.ctx.b.getUB2(n2 + 1);
        } else if (n4 == 16) {
            this.childArrayOffset += 4;
            this.size = this.ctx.b.getUB4int(n2 + 1);
        }
    }

    @Override
    protected int getChildOffset(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            return -1;
        }
        OsonHeader osonHeader = this.ctx.getHeader();
        if (osonHeader.relativeOffsets()) {
            if (this.childOffsetUb == 2) {
                short s2 = this.ctx.b.getShort(this.childArrayOffset + n2 * 2);
                s2 = (short)(s2 + (this.pos - osonHeader.getTreeSegmentOffset()));
                return (s2 & 0xFFFF) + osonHeader.getTreeSegmentOffset();
            }
            int n3 = this.ctx.b.getInt(this.childArrayOffset + n2 * 4);
            return ((n3 += this.pos - osonHeader.getTreeSegmentOffset()) & 0xFFFFFFFF) + osonHeader.getTreeSegmentOffset();
        }
        if (this.childOffsetUb == 2) {
            return this.ctx.b.getUB2(this.childArrayOffset + n2 * 2) + osonHeader.getTreeSegmentOffset();
        }
        return this.ctx.b.getUB4int(this.childArrayOffset + n2 * 4) + osonHeader.getTreeSegmentOffset();
    }

    private void copyToArray(Object[] objectArray) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectArray[i2] = this.getValueInternal(this.getChildOffset(i2));
        }
    }

    protected int getOffsetWithError(int n2) {
        int n3 = this.getChildOffset(n2);
        if (n3 == -1) {
            throw new IndexOutOfBoundsException();
        }
        return n3;
    }

    protected <T> AbstractList<T> sublist(final int n2, final int n3) {
        if (n2 < 0 || n3 > this.size || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        return new AbstractList<T>(){

            @Override
            public T get(int n22) {
                return OsonAbstractArray.this.getValueInternal(OsonAbstractArray.this.getOffsetWithError(n22 + n2));
            }

            @Override
            public int size() {
                return n3 - n2;
            }
        };
    }

    public class ListIter<T>
    extends ValueIter<T>
    implements ListIterator<T> {
        public ListIter(int n2) {
            this.ipos = n2;
        }

        @Override
        public boolean hasPrevious() {
            return this.ipos != 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (T)OsonAbstractArray.this.getInternal(--this.ipos);
        }

        @Override
        public int nextIndex() {
            return this.ipos;
        }

        @Override
        public int previousIndex() {
            return this.ipos - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T t2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T t2) {
            throw new UnsupportedOperationException();
        }
    }

    protected class ValueIter<V>
    extends OsonStructureImpl.PositionIter<V> {
        protected ValueIter() {
            super(OsonAbstractArray.this);
        }

        @Override
        public V getValue(int n2) {
            return (V)OsonAbstractArray.this.getValueInternal(OsonAbstractArray.this.getChildOffset(n2++));
        }
    }
}

