/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.VectorMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.LobCommonAccessorPrototype;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.VectorAccessor;

class T4CVectorAccessor
extends VectorAccessor {
    T4CMAREngine mare;
    final int[] meta = new int[1];

    T4CVectorAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, 4000, form, external_type, isOutBind, false);
        this.mare = _mare;
    }

    T4CVectorAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare, long dimensionCount, byte dimensionType, byte dimensionFlag) throws SQLException {
        super(stmt, 4000, nullable, flags, precision, scale, contflag, total_elems, form, dimensionCount, dimensionType, dimensionFlag);
        this.mare = _mare;
        this.definedColumnType = _definedColumnType;
        this.definedColumnSize = _definedColumnSize;
    }

    private T4CVectorAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare, VectorMetaData metaData) throws SQLException {
        super(stmt, 4000, nullable, flags, precision, scale, contflag, total_elems, form, metaData);
        this.mare = _mare;
        this.definedColumnType = _definedColumnType;
        this.definedColumnSize = _definedColumnSize;
    }

    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    public void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray dba, OracleStatement stmt) throws SQLException {
        this.rowData = dba;
        this.mare = ((T4CConnection)stmt.connection).mare;
        this.rowNull = null;
        this.setCapacity(stmt.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean isStream = false;
        if (!this.isUseless()) {
            if (this.isUnexpected()) {
                long pos = this.rowData.getPosition();
                this.unmarshalColumnMetadata();
                this.unmarshalBytes();
                this.rowData.setPosition(pos);
                this.setNull(this.lastRowProcessed, true);
            } else if (this.isNullByDescribe()) {
                this.setNull(this.lastRowProcessed, true);
                this.unmarshalColumnMetadata();
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
            } else {
                this.unmarshalColumnMetadata();
                isStream = this.unmarshalBytes();
            }
        }
        this.previousRowProcessed = this.lastRowProcessed++;
        return isStream;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            if (this.lastCopyRow == this.previousRowProcessed) {
                this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
                this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
                if (!this.lastCopyRowIsNull) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(this.lastCopyRowOffset, this.lastCopyRowLength);
                    this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
                }
            } else {
                long previousOffset = this.getOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            }
        } else if (this.lastCopyRow == this.previousRowProcessed) {
            this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
            this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
            this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
            this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.lastCopyRow = -1;
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    boolean unmarshalBytes() throws IOException, SQLException {
        int len = (int)this.mare.unmarshalUB4();
        if (len == 0) {
            this.setNull(this.lastRowProcessed, true);
            this.processIndicator(0);
        } else {
            if (this.isPrefetched()) {
                this.unmarshalPrefetchData();
            }
            this.setOffset(this.lastRowProcessed);
            int actualLength = ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
            this.setNull(this.lastRowProcessed, actualLength == 0);
            this.setLength(this.lastRowProcessed, actualLength);
            this.processIndicator(actualLength);
        }
        return false;
    }

    void unmarshalPrefetchData() throws SQLException, IOException {
        this.setPrefetchedLength(this.lastRowProcessed, this.mare.unmarshalSB8());
        this.setPrefetchedChunkSize(this.lastRowProcessed, (int)this.mare.unmarshalUB4());
        this.setPrefetchedDataOffset(this.lastRowProcessed);
        if (this.getPrefetchLength() > 0) {
            this.setPrefetchedDataLength(this.lastRowProcessed, ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare));
        } else {
            this.setPrefetchedDataLength(this.lastRowProcessed, 0);
        }
    }

    @Override
    AccessorPrototype newPrototype(int numRows) {
        assert (numRows >= 0) : "numRows: " + numRows;
        final VectorMetaData metaData = this.getVectorMetaData();
        LobCommonAccessorPrototype p = new LobCommonAccessorPrototype(numRows, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement stmt) throws SQLException {
                T4CVectorAccessor acc = new T4CVectorAccessor(stmt, T4CVectorAccessor.this.describeMaxLength, T4CVectorAccessor.this.nullable, -1, T4CVectorAccessor.this.precision, T4CVectorAccessor.this.scale, T4CVectorAccessor.this.contflag, -1, T4CVectorAccessor.this.formOfUse, T4CVectorAccessor.this.definedColumnType, T4CVectorAccessor.this.definedColumnSize, null, metaData);
                this.initializeRowData(acc);
                return acc;
            }
        };
        return p;
    }
}

