/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.sql.BLOB;
import oracle.sql.BlobDBAccess;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;

@Deprecated
public class OracleBlob
extends DatumWithConnection
implements oracle.jdbc.internal.OracleBlob {
    private static final long serialVersionUID = -5771953664462518027L;
    private static final String CLASS_NAME = OracleBlob.class.getName();
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BlobDBAccess dbaccess;
    int dbChunkSize = -1;
    boolean isFree = false;
    boolean fromObject = false;
    private long cachedLobLength = -1L;
    private OracleLargeObject.PrefetchData<byte[]> prefetchData;
    private boolean activePrefetch = false;
    static final int KDLCTLSIZE = 16;
    static final int KDF_FLAG = 88;
    static final int KDLIDDAT = 8;
    Object acProxy;

    public OracleBlob() {
    }

    public OracleBlob(OracleConnection conn) throws SQLException {
        this(conn, null);
    }

    public OracleBlob(OracleConnection conn, byte[] lob_descriptor, boolean fromObject) throws SQLException {
        this(conn, lob_descriptor);
        this.fromObject = fromObject;
    }

    public OracleBlob(OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        super(lob_descriptor);
        OracleBlob.assertNotNull(conn);
        this.setPhysicalConnectionOf(conn);
        try (Monitor.CloseableLock lock = this.getPhysicalConnection().acquireCloseableLock();){
            this.dbaccess = this.getPhysicalConnection().createBlobDBAccess();
            this.dbaccess.incrementTempLobReferenceCount(lob_descriptor);
            if (lob_descriptor != null && !this.isTemporaryInternal(this.dbaccess)) {
                ((oracle.jdbc.internal.OracleConnection)conn).addLargeObject(this);
            }
        }
    }

    public void setFromobject(boolean fromObject) {
        this.fromObject = fromObject;
    }

    @Override
    public long length() throws SQLException {
        return this.lengthInternal();
    }

    @Override
    public final long lengthInternal() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        long ret = this.activePrefetch && this.cachedLobLength != -1L ? this.cachedLobLength : (this.canReadBasicLobDataInLocator() ? (long)this.dilLength() : this.getDBAccess().length(this));
        return ret;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (length < 0 || pos < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetBytes(pos, length);
        }
        if (length == 0) {
            return new byte[0];
        }
        byte[] ret = null;
        if (this.activePrefetch && (this.cachedLobLength == 0L || this.cachedLobLength > 0L && pos - 1L >= this.cachedLobLength)) {
            ret = null;
        } else {
            long num_bytes_read = 0L;
            byte[] bytes_read = this.activePrefetch && this.cachedLobLength != -1L ? new byte[Math.min((int)this.cachedLobLength, length)] : new byte[length];
            num_bytes_read = this.getBytes(pos, length, bytes_read);
            if (num_bytes_read > 0L) {
                if (num_bytes_read == (long)length) {
                    ret = bytes_read;
                } else {
                    ret = new byte[(int)num_bytes_read];
                    System.arraycopy(bytes_read, 0, ret, 0, (int)num_bytes_read);
                }
            }
        }
        return ret;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(false);
    }

    public InputStream getBinaryStream(boolean isInternal) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetBinaryStream(1L);
        }
        return this.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)this, this.getBufferSize(), 0L, isInternal);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().position((oracle.jdbc.internal.OracleBlob)this, (Datum)this, pattern, start);
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().position((oracle.jdbc.internal.OracleBlob)this, (Datum)this, (Datum)((Object)pattern), start);
    }

    @Override
    public int getBytes(long pos, int length, byte[] buf) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (length < 0 || pos < 1L || buf == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace();
        }
        if (buf.length < length) {
            length = buf.length;
        }
        return this.getDBAccess().getBytes(this, pos, length, buf);
    }

    @Override
    @Deprecated
    public int putBytes(long pos, byte[] bytes) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setBytes(pos, bytes);
    }

    @Override
    @Deprecated
    public int putBytes(long pos, byte[] bytes, int length) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setBytes(pos, bytes, 0, length);
    }

    @Override
    @Deprecated
    public OutputStream getBinaryOutputStream() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setBinaryStream(1L);
    }

    @Override
    public byte[] getLocator() {
        return this.getBytes();
    }

    @Override
    public void setLocator(byte[] locator) {
        super.setBytes(locator);
    }

    @Override
    public int getChunkSize() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.dbChunkSize <= 0) {
            this.dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.dbChunkSize;
    }

    @Override
    public int getBufferSize() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return OracleBlob.computeBufferSize(this.getChunkSize());
    }

    @Override
    public boolean isEmptyLob() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        boolean ret = (this.shareBytes()[5] & 0x10) != 0;
        return ret;
    }

    @Override
    public boolean isSecureFile() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        boolean ret = (this.shareBytes()[7] & 0xFFFFFF80) != 0;
        return ret;
    }

    @Override
    @Deprecated
    public OutputStream getBinaryOutputStream(long pos) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos, false);
    }

    @Override
    public InputStream getBinaryStream(long pos) throws SQLException {
        return this.getBinaryStream(pos, false);
    }

    public InputStream getBinaryStream(long pos, boolean isInternal) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'position data' should be > 0.").fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetBinaryStream(pos);
        }
        return this.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)this, this.getBufferSize(), pos, isInternal);
    }

    @Override
    @Deprecated
    public void trim(long newlen) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.truncate(newlen);
    }

    @Override
    public void freeTemporary() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.freeTemporaryInternal(this.getDBAccess());
    }

    private void freeTemporaryInternal(BlobDBAccess myDBAccess) throws SQLException {
        int refCnt = myDBAccess.decrementTempLobReferenceCount(this.shareBytes());
        if (refCnt == 0) {
            myDBAccess.freeTemporary(this, this, this.fromObject);
        }
    }

    @Override
    public boolean isTemporary() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.isTemporaryInternal(this.getDBAccess());
    }

    private boolean isTemporaryInternal(BlobDBAccess myDBAccess) throws SQLException {
        return myDBAccess.isTemporary(this);
    }

    @Override
    public short getDuration() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().getDuration(this);
    }

    @Override
    public void openLob(LargeObjectAccessMode mode) throws SQLException {
        this.openLob(mode.getCode());
    }

    public void openLob(int mode) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.getDBAccess().openLob(this, mode);
    }

    @Override
    public void closeLob() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.closeLobInternal(this.getDBAccess());
    }

    private void closeLobInternal(BlobDBAccess myDBAccess) throws SQLException {
        myDBAccess.closeLob(this);
    }

    @Override
    public boolean isOpenLob() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.isOpenLobInternal(this.getDBAccess());
    }

    private boolean isOpenLobInternal(BlobDBAccess myDBAccess) throws SQLException {
        return myDBAccess.isOpenLob(this);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().putBytes(this, pos, bytes, 0, bytes != null ? bytes.length : 0);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().putBytes(this, pos, bytes, offset, len);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'position data' should be > 0.").fillInStackTrace();
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos, true);
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (len < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'len' should be >= 0. ").fillInStackTrace();
        }
        this.getDBAccess().trim(this, len);
    }

    @Override
    public Object toJdbc() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        String class_name = jClass.getName();
        return class_name.compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.io.Reader") == 0;
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return this.characterStreamValue(false);
    }

    public Reader characterStreamValue(boolean isInternal) throws SQLException {
        try (Monitor.CloseableLock lock = this.getPhysicalConnection().acquireCloseableLock();){
            Reader reader = this.getDBAccess().newConversionReader(this, 8, isInternal);
            return reader;
        }
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.asciiStreamValue(false);
    }

    public InputStream asciiStreamValue(boolean isInternal) throws SQLException {
        try (Monitor.CloseableLock lock = this.getPhysicalConnection().acquireCloseableLock();){
            InputStream inputStream = this.getDBAccess().newConversionInputStream(this, 2, isInternal);
            return inputStream;
        }
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    @Override
    public InputStream binaryStreamValue(boolean isInternal) throws SQLException {
        return this.getBinaryStream(isInternal);
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new BLOB[arraySize];
    }

    @Override
    public BlobDBAccess getDBAccess() throws SQLException {
        oracle.jdbc.internal.OracleConnection connPhys = this.getPhysicalConnection();
        if (connPhys != null && connPhys.isClosed()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        if (this.dbaccess == null) {
            if (this.isEmptyLob()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 98).fillInStackTrace();
            }
            try (Monitor.CloseableLock lock = connPhys.acquireCloseableLock();){
                this.dbaccess = this.getInternalConnection().createBlobDBAccess();
            }
        }
        return this.dbaccess;
    }

    public static BlobDBAccess getDBAccess(Connection conn) throws SQLException {
        try (Monitor.CloseableLock lock = ((OracleConnection)conn).physicalConnectionWithin().acquireCloseableLock();){
            BlobDBAccess blobDBAccess = ((OracleConnection)conn).physicalConnectionWithin().createBlobDBAccess();
            return blobDBAccess;
        }
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return super.getJavaSqlConnection();
    }

    @Override
    public final void setLength(long _length) {
        this.cachedLobLength = _length;
    }

    @Override
    public final void setChunkSize(int _dbChunkSize) {
        this.dbChunkSize = _dbChunkSize;
    }

    @Override
    public final void setPrefetchData(OracleLargeObject.PrefetchData<byte[]> prefetchData) {
        this.prefetchData = prefetchData;
    }

    @Override
    public final OracleLargeObject.PrefetchData<byte[]> getPrefetchData() {
        return this.prefetchData;
    }

    @Override
    public final void setActivePrefetch(boolean _activePrefetch) {
        if (this.activePrefetch && !_activePrefetch) {
            this.clearCachedData();
        }
        this.activePrefetch = _activePrefetch;
    }

    @Override
    public final void clearCachedData() {
        this.cachedLobLength = -1L;
        this.prefetchData = null;
    }

    @Override
    public final boolean isActivePrefetch() {
        return this.activePrefetch;
    }

    @Override
    public boolean canReadBasicLobDataInLocator() throws SQLException {
        byte[] loc = this.shareBytes();
        if (loc == null || loc.length < 102) {
            return false;
        }
        if (!this.getPhysicalConnection().isDataInLocatorEnabled()) {
            return false;
        }
        int kol_field3 = loc[6] & 0xFF;
        int kol_field4 = loc[7] & 0xFF;
        boolean hasDILBit = (kol_field3 & 8) == 8;
        boolean hasLocalBit = (kol_field4 & 0xFFFFFF80) == -128;
        boolean hasKdfBit = false;
        if (hasDILBit && !hasLocalBit) {
            int kdf_field = loc[88] & 0xFF;
            hasKdfBit = (kdf_field & 8) == 8;
        }
        boolean canUseDILData = hasDILBit && !hasLocalBit && hasKdfBit;
        return canUseDILData;
    }

    int dilLength() {
        return this.shareBytes().length - 86 - 16;
    }

    byte[] dilGetBytes(long pos, int length) throws SQLException {
        if (length == 0) {
            return new byte[0];
        }
        if (this.dilLength() == 0) {
            return null;
        }
        int lengthAvailable = (int)Math.min((long)length, (long)this.dilLength() - (pos - 1L));
        if (lengthAvailable <= 0) {
            return null;
        }
        byte[] result = new byte[lengthAvailable];
        System.arraycopy(this.shareBytes(), (int)(pos - 1L) + 86 + 16, result, 0, lengthAvailable);
        return result;
    }

    InputStream dilGetBinaryStream(long pos) throws SQLException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        byte[] dilBytes = this.dilGetBytes(pos, this.dilLength());
        if (dilBytes == null) {
            dilBytes = new byte[]{};
        }
        return new ByteArrayInputStream(dilBytes);
    }

    @Override
    public void freeLOB() throws SQLException {
        this.freeInternal();
    }

    @Override
    public void free() throws SQLException {
        this.freeInternal();
    }

    private void freeInternal() throws SQLException {
        if (this.isFree) {
            return;
        }
        BlobDBAccess myDBAccess = this.getDBAccess();
        try (Monitor.CloseableLock lock = myDBAccess.acquireCloseableLock();){
            if (this.isOpenLobInternal(myDBAccess)) {
                this.closeLobInternal(myDBAccess);
            }
            if (this.isTemporaryInternal(myDBAccess)) {
                this.freeTemporaryInternal(myDBAccess);
            }
        }
        this.getPhysicalConnection().removeLargeObject(this);
        this.isFree = true;
        this.dbaccess = null;
    }

    @Override
    public boolean isFree() {
        return this.isFree;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetBinaryStream(pos, length);
        }
        long lobLen = this.length();
        if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        return this.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)this, this.getChunkSize(), pos, length);
    }

    InputStream dilGetBinaryStream(long pos, long length) throws SQLException {
        int lobLen = this.dilLength();
        if (pos < 1L || length < 0L || pos > (long)lobLen || pos - 1L + length > (long)lobLen) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        byte[] dilBytes = this.dilGetBytes(pos, lobLen - (int)(pos - 1L));
        return new ByteArrayInputStream(dilBytes, 0, (int)length);
    }

    @Override
    public void setBytes(byte[] locator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    @Override
    public SQLXML toSQLXML() throws SQLException {
        return this.toSQLXML(this.getPhysicalConnection().getDbCsId());
    }

    @Override
    public SQLXML toSQLXML(int csid) throws SQLException {
        return null;
    }

    private static int computeBufferSize(int chunkSize) {
        if (chunkSize >= 32768 || chunkSize <= 0) {
            return 32768;
        }
        return 32768 / chunkSize * chunkSize;
    }
}

