/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.LogicalConnectionImpl;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableStatement;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

@ProxyFor(value={OracleConnection.class})
@ProxyLocale
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableConnection
extends TxnReplayableBase
implements JDBCReplayable,
ReplayableConnection {
    private static final Method CREATEARRAY_METHOD = TxnReplayableConnection.getCreateARRAYMethod();
    private static final Method CREATEARRAYOF_METHOD = TxnReplayableConnection.getCreateArrayOfMethod();
    private static final Method CREATESTRUCT_METHOD = TxnReplayableConnection.getCreateStructMethod();
    private static final Method CREATECLOB_METHOD = TxnReplayableConnection.getCreateLobMethod("createClob");
    private static final Method CREATECLOB_WITH_LOCATOR_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createClob", byte[].class);
    private static final Method CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD = TxnReplayableConnection.getCreateClobWithLocatorAndCSFORMMethod();
    private static final Method CREATECLOB_WITH_UNPICKLEDBYTES_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createClobWithUnpickledBytes", byte[].class);
    private static final Method CREATENCLOB_METHOD = TxnReplayableConnection.getCreateLobMethod("createNClob");
    private static final Method CREATEBLOB_METHOD = TxnReplayableConnection.getCreateLobMethod("createBlob");
    private static final Method CREATEBLOB_WITH_LOCATOR_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createBlob", byte[].class);
    private static final Method CREATEBLOB_WITH_UNPICKLEDBYTES_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createBlobWithUnpickledBytes", byte[].class);
    private static final Method CREATEBFILE_WITH_LOCATOR_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createBfile", byte[].class);
    private static final Method GETDESCRIPTOR_WITH_NAME_METHOD = TxnReplayableConnection.getMethod("getDescriptor", String.class);
    OracleConnectionBuilderImpl originalConnectionBuilder;
    private Object logicalProxy = null;
    boolean autoCommitBeforeOutage = true;
    private static final String CLASS_NAME = "oracle.jdbc.replay.driver.TxnReplayableConnection";

    protected TxnReplayableConnection() {
    }

    private static final Method getCreateARRAYMethod() {
        try {
            return OracleConnection.class.getMethod("createARRAY", String.class, Object.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getCreateArrayOfMethod() {
        try {
            return Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getCreateStructMethod() {
        try {
            return Connection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getCreateLobMethod(String methodName) {
        try {
            return OracleConnection.class.getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getCreateLobWithLocatorMethod(String methodName, Class<?> argType) {
        try {
            return OracleConnection.class.getMethod(methodName, argType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getCreateClobWithLocatorAndCSFORMMethod() {
        try {
            return OracleConnection.class.getMethod("createClob", byte[].class, Short.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getMethod(String methodName, Class<?> argType) {
        try {
            return OracleConnection.class.getMethod(methodName, argType);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method m, Object receiver, Object ... args) {
        super.preForAll(m, receiver, args);
    }

    @Pre
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class}), @Signature(name="prepareCall", args={String.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class, int.class})})
    protected void preForStatementCreation(Method m, Object receiver, Object ... args) {
        this.preForAll(m, receiver, args);
    }

    @Pre
    @Methods(signatures={@Signature(name="setAutoCommit", args={Boolean.class})})
    protected void preForSetAutoCommit(Method m, Object receiver, Object ... args) {
        this.preForAll(m, receiver, args);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: {
                this.autoCommitBeforeOutage = (Boolean)args[0];
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="abort", args={Executor.class})})
    protected void preForAbort(Method m, Object receiver, Object ... args) {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForAbort", "On {0}, NO recording for abort", (String)null, (Throwable)null, (Object)this.hashCode());
    }

    @Pre
    @Methods(signatures={@Signature(name="close", args={})})
    protected void preForClosure(Method m, Object receiver, Object ... args) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        String caller = stack != null && stack.length > 4 ? stack[4].getClassName() : "";
        this.isClosedAndNoReplay = !caller.startsWith("oracle.ucp") || this.isClosedAndNoReplay || !this.abortCalledBeforeLatestClose;
        this.failoverMngr.removeReplayStatistics();
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForClosure", "On {0}, preForClosure({1}, disallow replay afterwards: {2})", (String)null, (Throwable)null, new Object[]{this.hashCode(), m.getName(), this.isClosedAndNoReplay});
    }

    @Pre
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void preForCancel(Method m, Object receiver, Object ... args) {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForCancel", "On {0}, preForCancel({1})", (String)null, (Throwable)null, new Object[]{this.hashCode(), m.getName()});
    }

    @Pre
    @Methods(signatures={@Signature(name="openProxySession", args={int.class, Properties.class})})
    protected void preForOpenProxySession(Method m, Object receiver, Object ... args) {
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForOpenProxySession", "On {0}, preForOpenProxySession({1})", (String)null, (Throwable)null, new Object[]{this.hashCode(), m.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForOpenProxySession", "On {0}, failover manager not set", (String)null, (Throwable)null, (Object)this.hashCode());
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="isValid", args={int.class}), @Signature(name="isValid", args={OracleConnection.ConnectionValidation.class, int.class}), @Signature(name="pingDatabase", args={}), @Signature(name="pingDatabase", args={int.class}), @Signature(name="isUsable", args={}), @Signature(name="isUsable", args={boolean.class})})
    protected void preForSafeDrainingAPIs(Method m, Object receiver, Object ... args) {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForSafeDrainingAPIs", "On {0}, NO recording for {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), m.getName()});
    }

    protected void preForMethodWithConcreteClass(Method m, Object receiver, Object ... args) {
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "preForMethodWithConcreteClass", "On {0}, DISABLE REPLAY in preForMethodWithConcreteClass({1})", (String)null, (Throwable)null, new Object[]{this.hashCode(), m.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m, 397, "Replay disabled because of concrete class usage", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForMethodWithConcreteClass", "On connection {0}, failover manager not set", (String)null, (Throwable)null, (Object)this.hashCode());
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="acquireCloseableLock", args={})})
    protected void preForAcquireCloseableLock(Method m, Object receiver, Object ... args) {
    }

    @Override
    @Post
    protected void postForAll(Method m) {
        this.postForAll(m, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m, Object result) {
        return super.postForAll(m, result);
    }

    @Post
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class}), @Signature(name="createStatement", args={}), @Signature(name="createStatement", args={int.class, int.class}), @Signature(name="createStatement", args={int.class, int.class, int.class})})
    protected Object postForStatementCreation(Method m, Object result) {
        Object newResult = this.postForAll(m, result);
        if (this.failoverMngr.isAutoAC && this.failoverMngr.isSSSCursorEnabled) {
            Statement stmt = (Statement)((TxnReplayableStatement)newResult).getDelegate();
            int rsetType = -1;
            try {
                rsetType = stmt.getResultSetType();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (rsetType != 1003) {
                this.failoverMngr.isSSSCursorEnabled = false;
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "postForStatementCreation", "On {0}, DISABLE SSS-cursor support due to scrollable result set use", (String)null, (Throwable)null, (Object)this.hashCode());
                if (!this.failoverMngr.isSSSQueueEmpty()) {
                    this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
                }
                return newResult;
            }
            TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    ((TxnReplayableStatement)newResult).creatorCallEntry = this.failoverMngr.getCallHistoryTail();
                    break;
                }
            }
        }
        return newResult;
    }

    @Post
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="abort", args={Executor.class})})
    protected void postForAbort(Method m) {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "postForAbort", "On {0}, postForAbort()", (String)null, (Throwable)null, (Object)this.hashCode());
        this.abortCalledBeforeLatestClose = true;
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void postForClosure(Method m) {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "postForClosure", "On {0}, postForClosure({1})", (String)null, (Throwable)null, new Object[]{this.hashCode(), m.getName()});
    }

    @Post
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void postForCancel(Method m) {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "postForCancel", "On {0}, postForCancel({1})", (String)null, (Throwable)null, new Object[]{this.hashCode(), m.getName()});
    }

    @Post
    @Methods(signatures={@Signature(name="isValid", args={int.class}), @Signature(name="isValid", args={OracleConnection.ConnectionValidation.class, int.class}), @Signature(name="isUsable", args={}), @Signature(name="isUsable", args={boolean.class})})
    protected boolean postForSafeDrainingAPIs(Method m, boolean result) {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "postForSafeDrainingAPIs", "On {0}, post for {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), m.getName()});
        OracleConnection oconn = (OracleConnection)this.getDelegate();
        if (this.failoverMngr != null) {
            if (!oconn.isUsable(false)) {
                this.failoverMngr.disableReplayInternal(m, 372, "Replay disabled because of nonreplayable call", null);
            }
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "postForSafeDrainingAPIs", "On {0}, failover manager not set", (String)null, (Throwable)null, (Object)this.hashCode());
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="pingDatabase", args={}), @Signature(name="pingDatabase", args={int.class})})
    protected int postForPingDatabase(Method m, int result) {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "postForPingDatabase", "On {0}, postForPingDatabase {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), m.getName()});
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="commit", args={}), @Signature(name="commit", args={EnumSet.class}), @Signature(name="rollback", args={})})
    protected void postForTxnCompletion(Method m) {
        this.postForAll(m);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        OracleConnection oconn = (OracleConnection)this.getDelegate();
        if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oconn.isUsable(false)) {
            try {
                this.checkImplicitRequestBoundary();
            }
            catch (Throwable error) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "postForTxnCompletion", "On {0}, implicit boundary check failed after txn completion", (String)null, (Throwable)null, (Object)this.hashCode());
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="setClientInfo", args={String.class, String.class}), @Signature(name="setClientInfo", args={Properties.class})})
    protected void postForSetClientInfo(Method m) {
        super.postForAll(m);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.failoverMngr.setStateSignatureSyncUp();
        }
    }

    @Post
    @Methods(signatures={@Signature(name="acquireCloseableLock", args={})})
    protected Monitor.CloseableLock postAcquireCloseableLock(Method m, Monitor.CloseableLock lock) {
        return lock;
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m, SQLException error) throws SQLException {
        return super.onErrorForAll(m, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void setReplayInitiationTimeout(int timeout) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setReplayInitiationTimeout", "On {0}, set ReplayInitiationTimeout: {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), timeout});
        this.failoverMngr.setReplayInitiationTimeout(timeout);
    }

    @Override
    public void initialize(OracleDataSource rds, OracleConnectionBuilderImpl connBuilder) throws SQLException {
        TxnFailoverManagerImpl failoverMngr = (TxnFailoverManagerImpl)TxnFailoverManagerImpl.getFailoverManager(this, rds);
        this.setFailoverManager(failoverMngr);
        this.originalConnectionBuilder = connBuilder;
        failoverMngr.setRequestSizeLimit(rds.getRequestSizeLimit());
    }

    @Override
    public void setSessionStateConsistency(boolean isStatic) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setSessionStateConsistency", "On {0}, set SessionStateConsistency: {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), isStatic ? "STATIC" : "DYNAMIC"});
        this.failoverMngr.setSessionStateConsistency(isStatic);
    }

    @Override
    public void setSessionStateRestoration(ReplayableConnection.StateRestorationType type) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setSessionStateRestoration", "On {0}, set SessionStateRestoration: {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), type});
        this.failoverMngr.setSessionStateRestoration(type);
    }

    @Override
    public void setAutoAC(boolean isAutoAC) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setAutoAC", "On {0}, set AutoAC: {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), isAutoAC});
        this.failoverMngr.setAutoAC(isAutoAC);
    }

    @Override
    public void setHybrid(boolean isHybrid) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setHybrid", "On {0}, set Hybrid: {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), isHybrid});
        this.failoverMngr.setHybrid(isHybrid);
    }

    @Override
    public void setSSSCursorEnabled(boolean isSSSCursorEnabled) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "setSSSCursorEnabled", "On {0}, set SSSCursorEnabled: {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), isSSSCursorEnabled});
        this.failoverMngr.setSSSCursorEnabled(isSSSCursorEnabled);
    }

    @Override
    public Object getProxyObject() throws SQLException {
        return this.logicalProxy;
    }

    @Override
    public void setProxyObject(Object pxy) throws SQLException {
        this.logicalProxy = pxy;
    }

    @Override
    public void setProxyObject(Object pxy, OracleConnectionBuilderImpl connBldr) throws SQLException {
        this.logicalProxy = pxy;
        this.originalConnectionBuilder = connBldr;
    }

    @Override
    public OracleConnectionBuilderImpl getConnectionBuilder() {
        return this.originalConnectionBuilder;
    }

    @Override
    public void beginRequest() throws SQLException {
        this.beginRequest(false);
    }

    @Override
    public void beginRequest(boolean implicit) throws SQLException {
        this.failoverMngr.beginRequest(implicit);
    }

    @Override
    public void endRequest() throws SQLException {
        this.endRequest(false);
    }

    public void endRequest(boolean implicit) throws SQLException {
        this.failoverMngr.endRequest(implicit);
        this.failoverMngr.checkStateSignatureSyncUp();
        this.abortCalledBeforeLatestClose = false;
    }

    public void checkImplicitRequestBoundary() throws SQLException {
        OracleConnection oconn = (OracleConnection)this.getDelegate();
        if (this.failoverMngr.isAutoAC && this.failoverMngr.inExplicitRequest && oconn.hasNoOpenHandles()) {
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "checkImplicitRequestBoundary", "On {0}, detected implicit request boundary", (String)null, (Throwable)null, (Object)this.hashCode());
            this.endRequest(true);
            this.beginRequest(true);
        }
    }

    @Override
    public void disableReplay() throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "disableReplay", "On {0}, calling disableReplay()", (String)null, (Throwable)null, (Object)this.hashCode());
        this.failoverMngr.disableReplay();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public ARRAY createARRAY(String typeName, Object elements) throws SQLException {
        Object elementsToUse = elements != null ? (!elements.getClass().isArray() || this.isElementTypePrimitive(elements) ? elements : this.unwrapProxies(elements)) : null;
        if (CREATEARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        Method m = CREATEARRAY_METHOD;
        this.preForAll(m, this, typeName, elementsToUse);
        try {
            OracleConnection oconn = (OracleConnection)this.getDelegate();
            ARRAY result = oconn.createARRAY(typeName, elementsToUse);
            return (ARRAY)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (ARRAY)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public ARRAY ARRAYConstructorRecording(String typeName, Object elements, ARRAY result) throws SQLException {
        Object elementsToUse = elements != null ? (!elements.getClass().isArray() || this.isElementTypePrimitive(elements) ? elements : this.unwrapProxies(elements)) : null;
        if (CREATEARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        Method m = CREATEARRAY_METHOD;
        this.preForAll(m, this, typeName, elementsToUse);
        return (ARRAY)this.postForAll(m, result);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array createOracleArray(String arrayTypeName, Object elements) throws SQLException {
        return this.createARRAY(arrayTypeName, elements);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        Object[] elementsToUse = (Object[])this.unwrapProxies(elements);
        if (CREATEARRAYOF_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Array instance");
        }
        Method m = CREATEARRAYOF_METHOD;
        this.preForAll(m, this, typeName, elementsToUse);
        try {
            Connection oconn = (Connection)this.getDelegate();
            Array result = oconn.createArrayOf(typeName, elementsToUse);
            return (Array)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Array)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        Object[] attributesToUse;
        if (attributes != null && attributes.length > 0) {
            attributesToUse = new Object[attributes.length];
            int i = 0;
            for (Object attr : attributes) {
                attributesToUse[i++] = attr instanceof TxnReplayableBase ? ((TxnReplayableBase)attr).getDelegate() : attr;
            }
        } else {
            attributesToUse = attributes;
        }
        if (CREATESTRUCT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        Method m = CREATESTRUCT_METHOD;
        this.preForAll(m, this, typeName, attributesToUse);
        try {
            Connection oconn = (Connection)this.getDelegate();
            Struct result = oconn.createStruct(typeName, attributesToUse);
            return (Struct)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Struct)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public STRUCT STRUCTConstructorRecording(String typeName, Object[] attributes, STRUCT result) throws SQLException {
        Object[] attributesToUse;
        if (attributes != null && attributes.length > 0) {
            attributesToUse = new Object[attributes.length];
            int i = 0;
            for (Object attr : attributes) {
                attributesToUse[i++] = attr instanceof TxnReplayableBase ? ((TxnReplayableBase)attr).getDelegate() : attr;
            }
        } else {
            attributesToUse = attributes;
        }
        if (CREATESTRUCT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        Method m = CREATESTRUCT_METHOD;
        this.preForAll(m, this, typeName, attributesToUse);
        return (STRUCT)this.postForAll(m, result);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob createClob() throws SQLException {
        if (CREATECLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB instance");
        }
        Method m = CREATECLOB_METHOD;
        this.preForAll(m, this, new Object[0]);
        try {
            Connection oconn = (Connection)this.getDelegate();
            Clob result = oconn.createClob();
            return (Clob)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Clob)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB createClob(byte[] locator_bytes) throws SQLException {
        if (CREATECLOB_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with locater bytes instance");
        }
        Method m = CREATECLOB_WITH_LOCATOR_METHOD;
        this.preForAll(m, this, new Object[]{locator_bytes});
        try {
            OracleConnection oconn = (OracleConnection)this.getDelegate();
            CLOB result = oconn.createClob(locator_bytes);
            return (CLOB)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (CLOB)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB createClob(byte[] locator_bytes, short csform) throws SQLException {
        if (CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with locater bytes and csform instance");
        }
        Method m = CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD;
        this.preForAll(m, this, locator_bytes, csform);
        try {
            OracleConnection oconn = (OracleConnection)this.getDelegate();
            CLOB result = oconn.createClob(locator_bytes, csform);
            return (CLOB)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (CLOB)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB CLOBConstructorRecording(byte[] locator_bytes, short csform, CLOB result) throws SQLException {
        if (CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with locater bytes and csform instance");
        }
        Method m = CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD;
        this.preForAll(m, this, locator_bytes, csform);
        return (CLOB)this.postForAll(m, result);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB createClobWithUnpickledBytes(byte[] locator_bytes) throws SQLException {
        if (CREATECLOB_WITH_UNPICKLEDBYTES_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with unpickled bytes instance");
        }
        Method m = CREATECLOB_WITH_UNPICKLEDBYTES_METHOD;
        this.preForAll(m, this, new Object[]{locator_bytes});
        try {
            OracleConnection oconn = (OracleConnection)this.getDelegate();
            CLOB result = oconn.createClobWithUnpickledBytes(locator_bytes);
            return (CLOB)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (CLOB)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob createNClob() throws SQLException {
        if (CREATENCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create NCLOB instance");
        }
        Method m = CREATENCLOB_METHOD;
        this.preForAll(m, this, new Object[0]);
        try {
            Connection oconn = (Connection)this.getDelegate();
            NClob result = oconn.createNClob();
            return (NClob)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (NClob)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob createBlob() throws SQLException {
        if (CREATEBLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB instance");
        }
        Method m = CREATEBLOB_METHOD;
        this.preForAll(m, this, new Object[0]);
        try {
            Connection oconn = (Connection)this.getDelegate();
            Blob result = oconn.createBlob();
            return (Blob)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (Blob)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BLOB createBlob(byte[] locator_bytes) throws SQLException {
        if (CREATEBLOB_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB with locater bytes instance");
        }
        Method m = CREATEBLOB_WITH_LOCATOR_METHOD;
        this.preForAll(m, this, new Object[]{locator_bytes});
        try {
            OracleConnection oconn = (OracleConnection)this.getDelegate();
            BLOB result = oconn.createBlob(locator_bytes);
            return (BLOB)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (BLOB)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BLOB createBlobWithUnpickledBytes(byte[] locator_bytes) throws SQLException {
        if (CREATEBLOB_WITH_UNPICKLEDBYTES_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB with unpickled bytes instance");
        }
        Method m = CREATEBLOB_WITH_UNPICKLEDBYTES_METHOD;
        this.preForAll(m, this, new Object[]{locator_bytes});
        try {
            OracleConnection oconn = (OracleConnection)this.getDelegate();
            BLOB result = oconn.createBlobWithUnpickledBytes(locator_bytes);
            return (BLOB)this.postForAll(m, (Clob)((Object)result));
        }
        catch (SQLException sqlexc) {
            return (BLOB)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BLOB BLOBConstructorRecording(byte[] locator_bytes, BLOB result) throws SQLException {
        if (CREATEBLOB_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB with locater bytes instance");
        }
        Method m = CREATEBLOB_WITH_LOCATOR_METHOD;
        this.preForAll(m, this, new Object[]{locator_bytes});
        return (BLOB)this.postForAll(m, result);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE createBfile(byte[] locator_bytes) throws SQLException {
        if (CREATEBFILE_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BFILE with locater bytes instance");
        }
        Method m = CREATEBFILE_WITH_LOCATOR_METHOD;
        this.preForAll(m, this, new Object[]{locator_bytes});
        try {
            OracleConnection oconn = (OracleConnection)this.getDelegate();
            BFILE result = oconn.createBfile(locator_bytes);
            return (BFILE)this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return (BFILE)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE BFILEConstructorRecording(byte[] locator_bytes, BFILE result) throws SQLException {
        if (CREATEBFILE_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BFILE with locater bytes instance");
        }
        Method m = CREATEBFILE_WITH_LOCATOR_METHOD;
        this.preForAll(m, this, new Object[]{locator_bytes});
        return (BFILE)this.postForAll(m, result);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getDescriptor(String sql_name) throws SQLException {
        if (GETDESCRIPTOR_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get getDescriptor method");
        }
        Method m = GETDESCRIPTOR_WITH_NAME_METHOD;
        this.preForAll(m, this, sql_name);
        try {
            ProxyFactory pxyFactory;
            OracleConnection oconn = (OracleConnection)this.getDelegate();
            Object result = oconn.getDescriptor(sql_name);
            if (!(result instanceof StructDescriptor) && !(result instanceof ArrayDescriptor) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    Object unwrapProxies(Object origObj) {
        if (origObj == null) {
            return null;
        }
        if (origObj.getClass().isArray()) {
            Object[] origArr = (Object[])origObj;
            int len = origArr.length;
            if (len > 0) {
                Object[] newArr = new Object[len];
                for (int i = 0; i < len; ++i) {
                    newArr[i] = this.unwrapProxies(origArr[i]);
                }
                return newArr;
            }
            return origObj;
        }
        if (origObj instanceof TxnReplayableBase) {
            return ((TxnReplayableBase)origObj).getDelegate();
        }
        return origObj;
    }

    boolean isElementTypePrimitive(Object arr) {
        Class<?> arrType = arr.getClass();
        while (arrType.isArray()) {
            arrType = arrType.getComponentType();
        }
        return arrType.isPrimitive();
    }

    @Override
    public ReplayStatistics getReplayStatistics(ReplayableConnection.StatisticsReportType reportType) {
        return this.failoverMngr.getReplayStatistics(reportType);
    }

    @Override
    public void clearReplayStatistics(ReplayableConnection.StatisticsReportType reportType) {
        this.failoverMngr.clearReplayStatistics(reportType);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getLogicalConnection(OraclePooledConnection opc, boolean autoCommit) throws SQLException {
        LogicalConnectionImpl logicalConn = new LogicalConnectionImpl(opc, (OracleConnection)((Object)this), autoCommit);
        return logicalConn;
    }

    public LogicalTransactionId getLogicalTransactionId() throws SQLException {
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case REPLAYING_CALLBACK: {
                throw (SQLException)DatabaseError.createSqlException(368).fillInStackTrace();
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: {
                OracleConnection oconn = (OracleConnection)this.getDelegate();
                return oconn.isUsable(false) ? this.failoverMngr.getLogicalTransactionId() : this.failoverMngr.getLtxidAtOriginalOutage();
            }
        }
        return this.failoverMngr.getLogicalTransactionId();
    }
}

