/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.Parameter;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.ProxyHelper;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpFastOpen;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;

class TimeoutSocketChannel
extends SocketChannelWrapper {
    private static final String CLASS_NAME = TimeoutSocketChannel.class.getName();
    private int soTimeout = 0;
    NetStatImpl netStat = null;
    private final Proxy proxy;
    private final InetSocketAddress serverAddress;
    private Socket socket = null;
    private InputStream ipStream = null;
    private OutputStream opStream = null;
    private boolean isWriteQueueEnabled = false;
    private boolean enqueueAllWrites = false;
    private final Queue<ByteBuffer> writeQueue = new ArrayDeque<ByteBuffer>(0);
    private byte[] tcpFastOpenBytes;

    private TimeoutSocketChannel(InetSocketAddress serverAddress, NetStatImpl netStat, Proxy proxy, Diagnosable diagnosable) {
        super(null, diagnosable);
        this.serverAddress = serverAddress;
        this.netStat = netStat;
        this.proxy = proxy;
    }

    public TimeoutSocketChannel(InetSocketAddress serverAddress, int connectTimeout, NetStatImpl netStat, Proxy proxy, Diagnosable diagnosable, byte[] tcpFastOpenBytes) throws IOException, InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        this(serverAddress, netStat, proxy, diagnosable);
        this.tcpFastOpenBytes = tcpFastOpenBytes;
        try {
            this.connect(serverAddress, connectTimeout);
        }
        catch (IOException ioException) {
            this.disconnect();
            throw ioException;
        }
    }

    private void connect(InetSocketAddress socketAddress, int connectTimeout) throws IOException, InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        if (this.proxy == null) {
            this.initializeSocketChannel(this.serverAddress, connectTimeout);
        } else {
            this.initializeSocketChannel(this.proxy.address(), connectTimeout);
            ProxyHelper.connectViaProxy(this.proxy, this.serverAddress, this);
        }
    }

    private void initializeSocketChannel(SocketAddress remote, int connectTimeoutInMillis) throws IOException {
        long startTime = System.currentTimeMillis();
        try {
            this.socketChannel = SocketChannel.open();
            this.socketChannel.configureBlocking(true);
            this.socket = this.socketChannel.socket();
            this.doConnect(remote, connectTimeoutInMillis);
            this.ipStream = this.socket.getInputStream();
            this.opStream = this.socket.getOutputStream();
        }
        catch (SocketTimeoutException ste) {
            throw TimeoutSocketChannel.newTimeoutException(ste);
        }
        catch (ClosedByInterruptException e) {
            throw new InterruptedIOException("Socket read interrupted");
        }
    }

    private void doConnect(SocketAddress remote, int connectTimeoutInMillis) throws IOException {
        if (this.tcpFastOpenBytes == null) {
            this.socket.connect(remote, connectTimeoutInMillis);
        } else {
            this.doTfoConnect(remote, connectTimeoutInMillis);
        }
    }

    private void doTfoConnect(SocketAddress remote, int connectTimeoutInMillis) throws IOException {
        InetSocketAddress virtualSocketAddress = TcpFastOpen.setTcpFastOpenBytes((InetSocketAddress)remote, this.tcpFastOpenBytes);
        try {
            this.socket.connect(virtualSocketAddress, connectTimeoutInMillis);
        }
        catch (Throwable ex) {
            String errorMsg = TcpFastOpen.getErrorMessage(virtualSocketAddress);
            if (errorMsg != null) {
                throw new IOException(errorMsg, ex);
            }
            throw ex;
        }
        finally {
            int sentLength = TcpFastOpen.getBytesSentAndRemove(virtualSocketAddress);
            if (this.socket.isConnected() && sentLength < this.tcpFastOpenBytes.length && sentLength != -1) {
                this.socket.getOutputStream().write(this.tcpFastOpenBytes, sentLength, this.tcpFastOpenBytes.length - sentLength);
            }
        }
    }

    static CompletionStage<TimeoutSocketChannel> openAsync(InetSocketAddress serverAddress, int connectTimeout, NetStatImpl netStat, Diagnosable diagnosable, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        TimeoutSocketChannel newChannel = new TimeoutSocketChannel(serverAddress, netStat, null, diagnosable);
        return newChannel.connectAsync(connectTimeout, outboundTimeout, asyncExecutor).thenApply(nil -> newChannel);
    }

    private final CompletionStage<Void> connectAsync(int connectTimeout, AsyncOutboundTimeoutHandler outboundTimeout, Executor asyncExecutor) {
        if (this.proxy != null) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous proxy connection is not supported"));
        }
        try {
            SocketChannel newChannel = SocketChannel.open();
            outboundTimeout.setChannel(newChannel);
            this.socketChannel = newChannel;
            this.socketChannel.configureBlocking(false);
            this.socket = this.socketChannel.socket();
            if (this.socketChannel.connect(this.serverAddress)) {
                this.socketChannel.configureBlocking(true);
                this.ipStream = this.socket.getInputStream();
                this.opStream = this.socket.getOutputStream();
                return CompletionStageUtil.completedStage(null);
            }
        }
        catch (IOException initializationFailure) {
            return CompletionStageUtil.failedStage(initializationFailure);
        }
        AsyncConnectTask connectTask = new AsyncConnectTask(asyncExecutor);
        connectTask.start();
        CompletionStage connectStage = connectTask.getConnectStage();
        if (connectTimeout > 0) {
            TimerTask keyCancellingTask = TimeoutInterruptHandler.scheduleTask(() -> connectTask.setTimeoutExpired(), connectTimeout);
            return connectStage.whenComplete((nil, err) -> keyCancellingTask.cancel());
        }
        return connectStage;
    }

    void setNetStat(NetStatImpl netStat) {
        this.netStat = netStat;
    }

    @Override
    public void disconnect() throws IOException {
        if (this.socketChannel != null && this.socketChannel.isOpen()) {
            try {
                this.socketChannel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setSoTimeout(int soTimeout) throws SocketException {
        this.soTimeout = soTimeout;
        this.socket.setSoTimeout(soTimeout >= 0 ? soTimeout : 0);
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public int read(ByteBuffer dst) throws NetException, IOException {
        this.ensureOpen();
        try {
            int bytesRead = !this.blockingReadMode ? this.doNonBlockedRead(dst) : (this.isRegisteredWithMultiplexer() ? this.doRegisteredRead(dst) : this.doBlockedRead(dst));
            this.logRead(dst, bytesRead);
            return bytesRead;
        }
        catch (IOException e) {
            throw this.handleIOFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doNonBlockedRead(ByteBuffer dst) throws IOException {
        boolean isBlockingBefore = this.socketChannel.isBlocking();
        if (isBlockingBefore) {
            this.socketChannel.configureBlocking(false);
        }
        try {
            int n = this.socketChannel.read(dst);
            return n;
        }
        finally {
            if (isBlockingBefore) {
                this.socketChannel.configureBlocking(true);
            }
        }
    }

    private int doBlockedRead(ByteBuffer dst) throws IOException {
        try {
            byte[] readBuffer = dst.array();
            int offset = dst.position();
            int maxLen = dst.remaining();
            int bytesRead = this.ipStream.read(readBuffer, offset, maxLen);
            if (bytesRead >= 0) {
                dst.position(offset + bytesRead);
            }
            return bytesRead;
        }
        catch (SocketTimeoutException ste) {
            throw TimeoutSocketChannel.newTimeoutException(ste);
        }
        catch (ClosedByInterruptException cie) {
            throw new InterruptedIOException("Socket read interrupted");
        }
    }

    @Override
    protected void enqueueAllWrites(boolean isEnabled) {
        this.enqueueAllWrites = isEnabled;
    }

    @Override
    protected boolean getEnqueueAllWrites() {
        return this.enqueueAllWrites;
    }

    @Override
    protected void completeWrites() throws IOException {
        assert (this.getEnqueueAllWrites()) : "enqueueAllWrites is false";
        this.enqueueAllWrites = false;
        if (this.writeQueue.isEmpty()) {
            return;
        }
        int writeSize = this.writeQueue.stream().mapToInt(Buffer::remaining).sum();
        ByteBuffer writeBuffer = ByteBuffer.allocate(writeSize);
        while (!this.writeQueue.isEmpty()) {
            writeBuffer.put(this.writeQueue.remove());
        }
        writeBuffer.flip();
        while (writeBuffer.hasRemaining()) {
            this.write(writeBuffer);
        }
    }

    @Override
    public int write(ByteBuffer src) throws NetException, IOException {
        this.ensureOpen();
        try {
            int bytesWritten;
            if (this.enqueueAllWrites) {
                bytesWritten = src.remaining();
                this.enqueueWrite(src);
            } else if (this.isWriteQueueEnabled) {
                bytesWritten = src.remaining();
                this.tryNonBlockingWrite(src);
            } else {
                bytesWritten = this.isRegisteredWithMultiplexer() ? this.doRegisteredWrite(src) : this.doBlockedWrite(src);
            }
            return bytesWritten;
        }
        catch (IOException e) {
            throw this.handleIOFailure(e);
        }
    }

    private void tryNonBlockingWrite(ByteBuffer src) throws IOException {
        while (!this.writeQueue.isEmpty()) {
            ByteBuffer srcBuffer = this.writeQueue.peek();
            int length = this.socketChannel.write(srcBuffer);
            this.logWrite(srcBuffer, length);
            if (srcBuffer.hasRemaining()) break;
            this.writeQueue.remove();
        }
        if (this.writeQueue.isEmpty()) {
            int length = this.socketChannel.write(src);
            this.logWrite(src, length);
        }
        if (src.hasRemaining()) {
            this.enqueueWrite(src);
        }
    }

    private int doBlockedWrite(ByteBuffer src) throws IOException {
        try {
            if (src.hasRemaining()) {
                int offset = src.position();
                int length = src.remaining();
                byte[] buffer = src.array();
                this.opStream.write(buffer, offset, length);
                src.position(offset + length);
                this.logWrite(src, length);
                return length;
            }
            return 0;
        }
        catch (SocketTimeoutException ste) {
            throw TimeoutSocketChannel.newTimeoutException(ste);
        }
        catch (ClosedByInterruptException cie) {
            throw new InterruptedIOException("Socket write interrupted");
        }
    }

    private void logRead(ByteBuffer dst, int length) throws IOException {
        if (length < 1) {
            return;
        }
        if (this.netStat != null) {
            this.netStat.incrementBytesReceived(length);
        }
        this.tracep(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "readFromSocket", "{0} bytes", "{0} bytes\n{1}", null, () -> {
            if (this.isSensitiveEnabled()) {
                Parameter<?> dumpBuffer = Parameter.arg(Format.Style.PACKET_DUMP, TimeoutSocketChannel.copy(dst, length), 0L, length);
                return new Object[]{length, dumpBuffer};
            }
            return new Object[]{length};
        });
    }

    private void logWrite(ByteBuffer src, int length) throws IOException {
        if (length < 1) {
            return;
        }
        if (this.netStat != null) {
            this.netStat.incrementBytesSent(length);
        }
        this.tracep(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "writeToSocket", "{0} bytes written to the Socket.", "{0} bytes written to the Socket. Packet Dump : \n{1}", null, () -> {
            if (this.isSensitiveEnabled()) {
                Parameter<?> dumpBuffer = Parameter.arg(Format.Style.PACKET_DUMP, TimeoutSocketChannel.copy(src, length), 0L, length);
                return new Object[]{length, dumpBuffer};
            }
            return new Object[]{length};
        });
    }

    private IOException handleIOFailure(IOException e) {
        try {
            this.disconnect();
        }
        catch (Exception ex) {
            e.addSuppressed(ex);
        }
        return e;
    }

    private void ensureOpen() throws NetException, IOException {
        if (this.socketChannel == null || !this.socketChannel.isOpen()) {
            throw new NetException(17909);
        }
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new IOException("Unsupported feature");
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new IOException("Unsupported feature");
    }

    public String toString() {
        return "TimeoutSocketChannel[" + this.socket().toString() + "]";
    }

    @Override
    final void registerForNonBlockingRead(Consumer<Throwable> onReadReady) throws IOException {
        SocketChannel socketChannel = this.requireOpenChannel();
        if (this.soTimeout > 0) {
            AtomicBoolean isRegistered = new AtomicBoolean(false);
            TimerTask cancelTask = TimeoutSocketChannel.scheduleRegistrationCancel(socketChannel, this.soTimeout, isRegistered);
            try {
                TcpMultiplexer.registerForReadEvent(socketChannel, err -> {
                    cancelTask.cancel();
                    onReadReady.accept((Throwable)err);
                });
                isRegistered.set(true);
            }
            catch (IOException registrationException) {
                cancelTask.cancel();
                throw registrationException;
            }
        } else {
            TcpMultiplexer.registerForReadEvent(socketChannel, onReadReady);
        }
    }

    @Override
    final void registerForNonBlockingWrite(Consumer<Throwable> onWriteReady) throws IOException {
        SocketChannel socketChannel = this.requireOpenChannel();
        if (this.soTimeout > 0) {
            AtomicBoolean isRegistered = new AtomicBoolean(false);
            TimerTask cancelTask = TimeoutSocketChannel.scheduleRegistrationCancel(socketChannel, this.soTimeout, isRegistered);
            try {
                TcpMultiplexer.registerForWriteEvent(socketChannel, err -> {
                    cancelTask.cancel();
                    onWriteReady.accept((Throwable)err);
                });
                isRegistered.set(true);
            }
            catch (IOException registrationException) {
                cancelTask.cancel();
                throw registrationException;
            }
        } else {
            TcpMultiplexer.registerForWriteEvent(socketChannel, onWriteReady);
        }
    }

    private static TimerTask scheduleRegistrationCancel(SocketChannel socketChannel, int soTimeout, AtomicBoolean isRegistered) {
        return TimeoutInterruptHandler.scheduleTask(() -> {
            while (!isRegistered.get() && !Thread.currentThread().isInterrupted()) {
            }
            TcpMultiplexer.forceCallback(socketChannel, TimeoutSocketChannel.newTimeoutException(null));
        }, soTimeout);
    }

    @Override
    protected void enqueueBlockedWrites(boolean isEnabled) {
        this.isWriteQueueEnabled = isEnabled;
    }

    @Override
    protected boolean completeBlockedWrites() throws IOException {
        ByteBuffer buffer;
        while ((buffer = this.writeQueue.peek()) != null) {
            this.socketChannel.write(buffer);
            if (buffer.hasRemaining()) {
                return false;
            }
            this.writeQueue.remove();
        }
        return true;
    }

    private boolean enqueueWrite(ByteBuffer buffer) {
        if (!this.isWriteQueueEnabled && !this.enqueueAllWrites) {
            return false;
        }
        ByteBuffer copy = ByteBuffer.allocate(buffer.remaining());
        copy.put(buffer).flip();
        this.writeQueue.add(copy);
        return true;
    }

    private static TimeoutInterruptHandler.IOReadTimeoutException newTimeoutException(Throwable cause) {
        TimeoutInterruptHandler.IOReadTimeoutException ioReadTimeoutException = new TimeoutInterruptHandler.IOReadTimeoutException("Socket read timed out");
        ioReadTimeoutException.initCause(cause);
        return ioReadTimeoutException;
    }

    private boolean isRegisteredWithMultiplexer() {
        return TcpMultiplexer.isRegistered(this.socketChannel);
    }

    private int doRegisteredRead(ByteBuffer dst) throws IOException {
        int bytesRead = this.socketChannel.read(dst);
        if (bytesRead != 0) {
            return bytesRead;
        }
        CompletableFuture readReadyFuture = new CompletableFuture();
        TcpMultiplexer.registerForReadEvent(this.socketChannel, error -> {
            if (error == null) {
                readReadyFuture.complete(null);
            } else {
                readReadyFuture.completeExceptionally((Throwable)error);
            }
        });
        this.awaitSocketTimeout(readReadyFuture, this.soTimeout);
        return this.socketChannel.read(dst);
    }

    private int doRegisteredWrite(ByteBuffer src) throws IOException {
        int bytesWritten = this.socketChannel.write(src);
        if (!src.hasRemaining()) {
            return bytesWritten;
        }
        int timeoutRemaining = this.soTimeout;
        while (src.hasRemaining()) {
            CompletableFuture writeReadyFuture = new CompletableFuture();
            TcpMultiplexer.registerForWriteEvent(this.socketChannel, error -> {
                if (error == null) {
                    writeReadyFuture.complete(null);
                } else {
                    writeReadyFuture.completeExceptionally((Throwable)error);
                }
            });
            long startTime = System.currentTimeMillis();
            this.awaitSocketTimeout(writeReadyFuture, timeoutRemaining);
            timeoutRemaining = (int)((long)timeoutRemaining - (System.currentTimeMillis() - startTime));
            bytesWritten += this.socketChannel.write(src);
        }
        return bytesWritten;
    }

    private <T> T awaitSocketTimeout(Future<T> future, int timeout) throws IOException {
        try {
            return timeout > 0 ? future.get(timeout, TimeUnit.MILLISECONDS) : future.get();
        }
        catch (ExecutionException executionException) {
            Throwable cause = executionException.getCause();
            throw cause instanceof IOException ? (IOException)cause : new IOException(cause);
        }
        catch (InterruptedException interruptedException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("Socket read interrupted");
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
        catch (TimeoutException timeoutException) {
            throw TimeoutSocketChannel.newTimeoutException(timeoutException);
        }
    }

    static {
        TcpFastOpen.init();
    }

    private class AsyncConnectTask
    implements Consumer<Throwable> {
        private final Executor asyncExecutor;
        private final Monitor cancellationLock = Monitor.newInstance();
        private final CompletableFuture<Void> connectFuture = new CompletableFuture();
        private boolean isTimeoutExpired = false;

        private AsyncConnectTask(Executor asyncExecutor) {
            this.asyncExecutor = asyncExecutor;
        }

        private void start() {
            try {
                TcpMultiplexer.registerForConnectEvent(TimeoutSocketChannel.this.socketChannel, this);
            }
            catch (IOException registrationFailure) {
                this.connectFuture.completeExceptionally(registrationFailure);
            }
        }

        @Override
        public void accept(Throwable err) {
            this.asyncExecutor.execute(() -> this.handleReadiness(err));
        }

        private final void handleReadiness(Throwable err) {
            try (Monitor.CloseableLock lock = this.cancellationLock.acquireCloseableLock();){
                if (err != null) {
                    this.connectFuture.completeExceptionally(err);
                } else if (!this.isTimeoutExpired) {
                    TimeoutSocketChannel.this.socketChannel.configureBlocking(false);
                    if (TimeoutSocketChannel.this.socketChannel.finishConnect()) {
                        TcpMultiplexer.restoreBlockingMode(TimeoutSocketChannel.this.socketChannel);
                        TimeoutSocketChannel.this.ipStream = TimeoutSocketChannel.this.socket.getInputStream();
                        TimeoutSocketChannel.this.opStream = TimeoutSocketChannel.this.socket.getOutputStream();
                        this.connectFuture.complete(null);
                    } else {
                        TcpMultiplexer.registerForConnectEvent(TimeoutSocketChannel.this.socketChannel, this);
                    }
                }
            }
            catch (IOException connectFailure) {
                this.connectFuture.completeExceptionally(connectFailure);
            }
        }

        private final void setTimeoutExpired() {
            this.isTimeoutExpired = true;
            try (Monitor.CloseableLock lock = this.cancellationLock.acquireCloseableLock();){
                TimeoutInterruptHandler.IOReadTimeoutException timeoutException = new TimeoutInterruptHandler.IOReadTimeoutException("Socket connect timed out");
                this.asyncExecutor.execute(() -> this.connectFuture.completeExceptionally(timeoutException));
                try {
                    TcpMultiplexer.forceCallback(TimeoutSocketChannel.this.socketChannel, timeoutException);
                    TimeoutSocketChannel.this.socketChannel.close();
                }
                catch (IOException closeException) {
                    this.connectFuture.completeExceptionally(timeoutException);
                }
            }
        }

        private final CompletionStage<Void> getConnectStage() {
            return this.connectFuture;
        }
    }
}

