/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.actors.InterruptableActor;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionCreationBroker;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.CoreConnectionImpl;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.SelectorsUtil;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.Topology;
import oracle.ucp.common.WLSJTAPlugin;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.routing.DataDependentRoutingCache;
import oracle.ucp.routing.RACDataAffinityRoutingCache;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

public class Service
implements Diagnosable {
    static final String CLASS_NAME = Service.class.getName();
    private static final short DB_VERSION_122 = 12200;
    private final String logicalServiceName;
    private final String fullServiceName;
    private final String regionName;
    private final AtomicBoolean active = new AtomicBoolean(true);
    final Set<String> placement = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Topology connectionSource;
    final FailoverDriver failoverDriver;
    final LoadBalancer loadBalancer;
    final AtomicInteger activeCount = new AtomicInteger(0);
    final AtomicInteger borrowedCount = new AtomicInteger(0);
    final AtomicInteger pendingCreateCount = new AtomicInteger(0);
    private final ConcurrentMap<ServiceMember.Key, ServiceMember> serviceMembers = new ConcurrentHashMap<ServiceMember.Key, ServiceMember>();
    final AtomicInteger activeMembers = new AtomicInteger(0);
    final AtomicInteger idCount = new AtomicInteger(0);
    final LoadBalancer.Stats lbStats = new LoadBalancer.Stats();
    final FailoverDriver.Stats fdStats = new FailoverDriver.Stats();
    final AtomicReference<ConnectionSource.RebalanceCallback.Result> pendingRebalance = new AtomicReference<ConnectionSource.RebalanceCallback.Result>(new ConnectionSource.RebalanceCallback.Result());
    final AtomicInteger pendingCloseCount = new AtomicInteger(0);
    private String containerName = null;
    private final AtomicInteger lastDrainTimeout = new AtomicInteger(0);
    private volatile CountDownLatch registered = null;
    private final AtomicBoolean rlbEnabled = new AtomicBoolean(true);
    private final AtomicBoolean allowInstNameAtConnect = new AtomicBoolean(true);
    private final AtomicReference<DataDependentRoutingCache> routingCache = new AtomicReference<Object>(null);
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private String hostName = null;
    private AtomicReference<String[]> distributionTable = new AtomicReference<String[]>(new String[0]);
    private static Random rand = new Random();
    private final AtomicReference<Object> mostRecentONSEvent = new AtomicReference<Object>(null);
    private final ConnectionCreationBroker connectionCreationBroker;
    final AtomicBoolean onsStarted = new AtomicBoolean(false);

    Service(Topology connectionSource, String fullServiceName, ConnectionSource.FailoverCallback failoverCallback, ConnectionSource.RebalanceCallback rebalanceCallback, Diagnosable diagnosticsCollector) {
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
        this.connectionSource = Objects.requireNonNull(connectionSource);
        this.fullServiceName = Objects.requireNonNull(fullServiceName).toLowerCase();
        this.logicalServiceName = Service.extractLogicalPart(this.fullServiceName);
        this.regionName = Service.extractRegionName(this.fullServiceName);
        this.failoverDriver = this.prepareFailoverDriver(failoverCallback);
        this.loadBalancer = this.prepareLoadBalancer(rebalanceCallback);
        this.connectionCreationBroker = new ConnectionCreationBroker(diagnosticsCollector);
        this.trace(Level.FINEST, CLASS_NAME, "Service", "service {0} registered", null, null, fullServiceName);
    }

    private static String extractLogicalPart(String fullServiceName) {
        if (fullServiceName == null) {
            return null;
        }
        if (!fullServiceName.contains("%")) {
            return fullServiceName;
        }
        return fullServiceName.substring(fullServiceName.indexOf(37) + 1);
    }

    private static String extractRegionName(String fullServiceName) {
        if (fullServiceName == null || !fullServiceName.contains("%")) {
            return null;
        }
        return fullServiceName.substring(0, fullServiceName.indexOf(37));
    }

    void onRegister() {
        if (this.registered != null) {
            this.registered.countDown();
        }
    }

    private void awaitRegister() {
        try {
            if (this.registered == null) {
                return;
            }
            this.registered.await();
        }
        catch (InterruptedException e) {
            this.trace(Level.WARNING, CLASS_NAME, "awaitRegister", "", null, e, new Object[0]);
        }
    }

    private void checkAndRegister() {
        if (this.registered == null) {
            this.registered = new CountDownLatch(1);
        }
    }

    int activeMembersCount() {
        if (!this.active.get()) {
            return 0;
        }
        return this.activeMembers.get();
    }

    String containerName() {
        return this.containerName;
    }

    void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public boolean areNamesMatched(String serviceName) {
        Objects.requireNonNull(serviceName, "serviceName is null");
        if (serviceName.equalsIgnoreCase(this.fullServiceName)) {
            return true;
        }
        if (serviceName.equalsIgnoreCase(this.logicalServiceName)) {
            return true;
        }
        String nServiceName = serviceName.contains("%") ? serviceName.substring(this.fullServiceName.indexOf(37) + 1) : serviceName;
        nServiceName = nServiceName.contains(".") ? nServiceName.substring(0, nServiceName.indexOf(46)) : nServiceName;
        String nThisServiceName = this.logicalServiceName.contains(".") ? this.logicalServiceName.substring(0, this.logicalServiceName.indexOf(46)) : this.logicalServiceName;
        return nServiceName.equalsIgnoreCase(nThisServiceName);
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public ServiceMember insertMember(ServiceMember serviceMember) {
        try {
            String h;
            void memberToInsert;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "insertMember", "entering args ({0})", null, null, serviceMember);
            Objects.requireNonNull(memberToInsert, "memberToInsert is null");
            assert (this.equals(memberToInsert.serviceRef)) : "services mismatch: this=" + this + ", memberToInsert.serviceRef=" + memberToInsert.serviceRef;
            if (null == this.hostName) {
                this.hostName = memberToInsert.host();
            }
            String host = null == (h = memberToInsert.host()) || "".equals(h) ? this.hostName : h;
            ServiceMember inst = this.getMember(memberToInsert.name(), memberToInsert.database(), memberToInsert.service());
            if (null != inst) {
                if (!inst.host().equals("")) {
                    ServiceMember serviceMember2 = inst;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "insertMember", "returning {0}", null, null, serviceMember2);
                    return serviceMember2;
                }
                if (!memberToInsert.host().equals("")) {
                    this.serviceMembers.remove(inst.key());
                    this.serviceMembers.putIfAbsent(memberToInsert.key(), (ServiceMember)memberToInsert);
                    void var6_6 = memberToInsert;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "insertMember", "returning {0}", null, null, var6_6);
                    return var6_6;
                }
                ServiceMember serviceMember3 = inst;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "insertMember", "returning {0}", null, null, serviceMember3);
                return serviceMember3;
            }
            if (null == this.serviceMembers.putIfAbsent(memberToInsert.key(), (ServiceMember)memberToInsert)) {
                memberToInsert.initId();
                this.activeMembers.incrementAndGet();
            }
            void var6_8 = memberToInsert;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "insertMember", "returning {0}", null, null, var6_8);
            return var6_8;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "insertMember", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public ServiceMember getMember(String instName, String dbName, String hostName, String serviceName) {
        return (ServiceMember)this.serviceMembers.get(new ServiceMember.Key(instName, dbName, hostName, serviceName));
    }

    public ServiceMember getMember(String instName, String dbName, String serviceName) {
        for (ServiceMember inst : this.getAllMembers()) {
            if (!inst.name().equals(instName) || !inst.database().equals(dbName) || !inst.service().equals(serviceName)) continue;
            return inst;
        }
        return null;
    }

    Collection<ServiceMember> getAllMembers() {
        return this.serviceMembers.values();
    }

    Collection<ServiceMember> getAllMembers(ConnectionRetrievalInfo cri) {
        return this.getAllMembers(cri, false);
    }

    Collection<ServiceMember> getAllMembers(ConnectionRetrievalInfo cri, boolean checkRoomToGrow) {
        if (!this.connectionSource.isDataDependentRoutingEnabled() || cri == null || this.routingCache() == null) {
            return this.getAllMembers();
        }
        if (checkRoomToGrow) {
            return this.routingCache().instancesToGrow(cri);
        }
        return this.routingCache().allInstances(cri);
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    void markup(FailoverDriver.Event event) {
        try {
            void event2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "markup", "entering args ({0})", null, null, event);
            FailoverDriver.Event.Status status = event2.status();
            String instname = event2.instance();
            String hostname = event2.host();
            String service = event2.serviceName();
            String database = event2.database();
            FailoverDriver.Event.EventType eventType = event2.event_type();
            String msg = "FF markup:" + " event=" + event2.toString();
            this.trace(Level.FINEST, CLASS_NAME, "markup", msg, null, null, new Object[0]);
            if ((FailoverDriver.Event.EventType.INSTANCE == eventType || FailoverDriver.Event.EventType.SERVICEMEMBER == eventType) && null != instname) {
                this.insertMember(new ServiceMember(instname, database, hostname, service, this));
            }
            for (ServiceMember instance : this.serviceMembers.values()) {
                instance.clearRLBHistory();
                if ((FailoverDriver.Event.EventType.INSTANCE == eventType || FailoverDriver.Event.EventType.SERVICEMEMBER == eventType) && instname.equals(instance.name()) && database.equals(instance.database()) && service.equals(instance.service())) {
                    if (FailoverDriver.Event.Status.UP == status) {
                        this.active.compareAndSet(false, true);
                    }
                    instance.markActive(FailoverDriver.Event.Status.UP == status);
                    continue;
                }
                if (FailoverDriver.Event.EventType.SERVICE == eventType && database.equals(instance.database()) && service.equals(instance.service())) {
                    this.active.set(FailoverDriver.Event.Status.UP == status);
                    continue;
                }
                if (FailoverDriver.Event.EventType.NODE != eventType || !hostname.equals(instance.host())) continue;
                instance.markActive(FailoverDriver.Event.Status.UP == status);
            }
            if (FailoverDriver.Event.Status.DOWN == status && (FailoverDriver.Event.EventType.INSTANCE == eventType || FailoverDriver.Event.EventType.SERVICEMEMBER == eventType || FailoverDriver.Event.EventType.NODE == eventType) && 0 == this.activeMembers.get()) {
                this.active.set(false);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "markup", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "markup", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    void markup(LoadBalancer.Event event) {
        try {
            void event2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "markup", "entering args ({0})", null, null, event);
            String msg = "load balancer markup:" + " event=" + event2.toString();
            this.trace(Level.FINEST, CLASS_NAME, "markup", msg, null, null, new Object[0]);
            for (String instname : event2.instances()) {
                if (null == instname) {
                    this.trace(Level.FINE, CLASS_NAME, "markup", "instance name is null, skipping", null, null, new Object[0]);
                    continue;
                }
                ServiceMember instance = this.insertMember(new ServiceMember(instname, event2.database(), event2.host(), event2.service(), this));
                instance.markAffined(event2.affinity(instname));
                String msg2 = " instance " + instance.toString() + " marked as affined";
                this.trace(Level.FINEST, CLASS_NAME, "markup", msg2, null, null, new Object[0]);
                LoadBalancer.Event.Flag flag = event2.flag(instname);
                instance.markActive(LoadBalancer.Event.Flag.NO_DATA != flag && LoadBalancer.Event.Flag.BLOCKED != flag);
                instance.markViolating(LoadBalancer.Event.Flag.VIOLATING == flag);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "markup", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "markup", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    int activeCount() {
        return this.activeCount.get();
    }

    int borrowedCount() {
        return this.borrowedCount.get();
    }

    private static int gcd(Integer ... n) {
        switch (n.length) {
            case 0: {
                return 1;
            }
            case 1: {
                return n[0];
            }
            case 2: {
                return 0 == n[1] ? n[0] : Service.gcd(n[1], n[0] % n[1]);
            }
        }
        Integer[] rest = new Integer[n.length - 1];
        rest[0] = Service.gcd(n[0], n[1]);
        System.arraycopy(n, 2, rest, 1, rest.length - 1);
        return Service.gcd(rest);
    }

    void buildDistributionTable() {
        ArrayList<String> listNames = new ArrayList<String>();
        ArrayList<Integer> listConns = new ArrayList<Integer>();
        for (ServiceMember inst : this.getAllMembers()) {
            int count = inst.activeCount.get();
            if (count <= 0) continue;
            listConns.add(count);
            listNames.add(inst.name());
        }
        Integer[] conns = listConns.toArray(new Integer[0]);
        String[] names = listNames.toArray(new String[0]);
        int gcd = Service.gcd(conns);
        ArrayList<String> dt = new ArrayList<String>();
        for (int i = 0; i < conns.length; ++i) {
            dt.addAll(Collections.nCopies(conns[i] / gcd, names[i]));
        }
        this.distributionTable.set(dt.toArray(new String[0]));
    }

    Predicate<CoreConnection> proportionalDistributionSelector() {
        return conn -> {
            String[] dt = this.distributionTable.get();
            return 0 == dt.length ? true : conn.serviceMember().name().equals(dt[rand.nextInt(dt.length)]);
        };
    }

    public Topology connectionSource() {
        return this.connectionSource;
    }

    DataDependentRoutingCache routingCache() {
        if (this.routingCache.get() != null) {
            return this.routingCache.get();
        }
        this.routingCache.compareAndSet(null, this.prepareRoutingCache());
        return this.routingCache.get();
    }

    public String getLogicalServiceName() {
        assert (null != this.logicalServiceName);
        return this.logicalServiceName;
    }

    public String getFullServiceName() {
        assert (null != this.fullServiceName);
        return this.fullServiceName;
    }

    public boolean isThisServiceName(String serviceName) {
        if (Objects.isNull(serviceName)) {
            return false;
        }
        return serviceName.equalsIgnoreCase(this.fullServiceName) || serviceName.equalsIgnoreCase(this.logicalServiceName);
    }

    @Debug(level=Debug.Level.FINEST)
    void markConnCreationBrokerOperable() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "markConnCreationBrokerOperable", "entering args ()", null, null, new Object[0]);
            this.connectionCreationBroker.markDbAsOperable();
            this.trace(Level.FINEST, CLASS_NAME, "markConnCreationBrokerOperable", "switching off Connection Creation Broker", null, null, new Object[0]);
            this.connectionSource.getConnectionCreationAttemptsSinceLastOutage().reset();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "markConnCreationBrokerOperable", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "markConnCreationBrokerOperable", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Debug(level=Debug.Level.FINEST)
    public CoreConnection create(ConnectionRetrievalInfo var1_1, EnumSet<ConnectionSource.CreateMode> var2_2, long var3_3) throws UniversalConnectionPoolException {
        try {
            block30: {
                block31: {
                    block32: {
                        this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "create", "entering args ({0}, {1}, {2})", null, null, new Object[]{var1_1, var2_2, var3_3});
                        timeToRetry = Math.max(0L, timeToRetry);
                        createdUpc = null;
                        try {
                            this.trace(Level.FINEST, Service.CLASS_NAME, "create", "create:  cri={0}, createModes={1}, timeToRetry={2}", null, null, new Object[]{cri.toString(), createModes, timeToRetry});
                            giveUp = Clock.clock() + timeToRetry;
                            ucpEx = null;
                            this.trace(Level.FINEST, Service.CLASS_NAME, "create", "about to do cycle of retries: timeToRetry={0}, now={1}, giveUp={2}", null, null, new Object[]{timeToRetry, Clock.clock(), giveUp});
lbl13:
                            // 2 sources

                            while (true) {
                                interval = this.connectionCreationBroker.appointNextAttempt();
                                this.trace(Level.FINEST, Service.CLASS_NAME, "create", "waiting for broker appointment: interval={0}", null, null, new Object[]{interval});
                                if (0L == interval) {
                                    this.trace(Level.FINEST, Service.CLASS_NAME, "create", "got an appointment for connection creation re-attempt", null, null, new Object[0]);
                                } else {
                                    sleepTime = Math.min(Math.max(0L, giveUp - Clock.clock()), interval);
                                    if (0L == sleepTime) {
                                        this.trace(Level.FINEST, Service.CLASS_NAME, "create", "given up to create a connection within timeToRetry", null, null, new Object[0]);
                                    } else {
                                        this.trace(Level.FINEST, Service.CLASS_NAME, "create", "about to sleep for sleepTime={0} milliseconds", null, null, new Object[]{sleepTime});
                                        this.connectionCreationBroker.waitOnBroker(sleepTime);
                                        continue;
                                    }
                                }
                                this.pendingCreateCount.incrementAndGet();
                                try {
                                    if (this.activeCount.get() + this.pendingCreateCount.get() > this.connectionSource.limits().getMaxPerService()) {
                                        this.trace(Level.FINEST, Service.CLASS_NAME, "create", "Cannot create new connections, max connections per service limit reached", null, null, new Object[0]);
                                        interval = null;
                                        return interval;
                                    }
                                }
                                catch (UniversalConnectionPoolException e) {
                                    this.trace(Level.WARNING, Service.CLASS_NAME, "create", "", null, e, new Object[0]);
                                    ucpEx = e;
                                    if (!(e.getCause() instanceof SQLRecoverableException)) {
                                        if (Service.isUnableToCreateConnection(e) == false) throw e;
                                    }
                                    if (Service.isUnableToCreateConnection(e) && createModes.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE)) {
                                        createModes = EnumSet.noneOf(ConnectionSource.CreateMode.class);
                                        this.trace(Level.FINE, Service.CLASS_NAME, "create", "unable to connect to specific instance, setting createModes = EnumSet.noneOf(CreateMode.class)", null, null, new Object[0]);
                                        break block30;
                                    }
                                    if (!this.connectionSource.failoverEnabled() || this.active.get()) {
                                        this.connectionCreationBroker.markDbAsInoperable();
                                        this.trace(Level.FINE, Service.CLASS_NAME, "create", "temporarily unable to create a connection: starting attempting to create connection with Connection Creation Broker", null, null, new Object[0]);
                                        this.loadBalancer.disableRLBGravitation();
                                        this.trace(Level.FINE, Service.CLASS_NAME, "create", "disabling RLB gravitation for the next {0} seconds", null, null, new Object[]{Util.getRLBGravitationInoperablePeriod()});
                                        this.connectionSource.getCumulativeConnectionCreationAttempts().increment();
                                        this.connectionSource.getConnectionCreationAttemptsSinceLastOutage().increment();
                                    }
                                    break block30;
                                }
                                break;
                            }
                        }
                        catch (Throwable var14_17) {
                            this.trace(Level.FINEST, Service.CLASS_NAME, "create", "created:  cri={0}, createModes={1}, timeToRetry={2}, createdUpc={3}", null, null, new Object[]{cri.toString(), createModes, timeToRetry, createdUpc});
                            throw var14_17;
                        }
                        this.trace(Level.FINEST, Service.CLASS_NAME, "create", "about to create a connection", null, null, new Object[0]);
                        conn = this.create((ConnectionRetrievalInfo)cri, createModes);
                        if (null == conn) ** GOTO lbl-1000
                        this.trace(Level.FINEST, Service.CLASS_NAME, "create", "{0} created", null, null, new Object[]{conn});
                        this.connectionCreationBroker.markDbAsOperable();
                        this.trace(Level.FINEST, Service.CLASS_NAME, "create", "switching off Connection Creation Broker", null, null, new Object[0]);
                        this.connectionSource.getConnectionCreationAttemptsSinceLastOutage().reset();
                        var10_15 = createdUpc = conn;
                        this.pendingCreateCount.decrementAndGet();
                        this.trace(Level.FINEST, Service.CLASS_NAME, "create", "created:  cri={0}, createModes={1}, timeToRetry={2}, createdUpc={3}", null, null, new Object[]{cri.toString(), createModes, timeToRetry, createdUpc});
                        var16_13 = var10_15;
                        this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "create", "returning {0}", null, null, new Object[]{var16_13});
                        return var16_13;
lbl-1000:
                        // 1 sources

                        {
                            this.trace(Level.WARNING, Service.CLASS_NAME, "create", "failed to create", null, null, new Object[0]);
                            this.pendingCreateCount.decrementAndGet();
                        }
                        if (!this.connectionSource.failoverEnabled()) break block31;
                        break block32;
                        finally {
                            this.pendingCreateCount.decrementAndGet();
                        }
                    }
                    if (!this.active.get()) break block30;
                }
                this.connectionCreationBroker.markDbAsInoperable();
                this.trace(Level.FINE, Service.CLASS_NAME, "createAsync", "temporarily unable to create a connection: starting attempting to create connection with Connection Creation Broker", null, null, new Object[0]);
                this.loadBalancer.disableRLBGravitation();
                this.trace(Level.FINE, Service.CLASS_NAME, "createAsync", "disabling RLB gravitation for the next {0} seconds", null, null, new Object[]{Util.getRLBGravitationInoperablePeriod()});
                this.connectionSource.getCumulativeConnectionCreationAttempts().increment();
                this.connectionSource.getConnectionCreationAttemptsSinceLastOutage().increment();
            }
            if (Clock.clock() >= giveUp) ** break;
            ** continue;
            if (ucpEx != null) {
                throw ucpEx;
            }
            this.trace(Level.FINEST, Service.CLASS_NAME, "create", "gave up to create a connection", null, null, new Object[0]);
            var9_9 = null;
            this.trace(Level.FINEST, Service.CLASS_NAME, "create", "created:  cri={0}, createModes={1}, timeToRetry={2}, createdUpc={3}", null, null, new Object[]{cri.toString(), createModes, timeToRetry, createdUpc});
            var16_14 = var9_9;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "create", "returning {0}", null, null, new Object[]{var16_14});
            return var16_14;
        }
        catch (Throwable var15_18) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "create", "throwing", null, var15_18, new Object[0]);
            throw var15_18;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public CompletionStage<CoreConnection> createAsync(ConnectionRetrievalInfo connectionRetrievalInfo, EnumSet<ConnectionSource.CreateMode> enumSet, long l, Executor executor) {
        try {
            void executor2;
            void cri;
            long timeToRetry;
            void createModes;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createAsync", "entering args ({0}, {1}, {2}, {3})", null, null, connectionRetrievalInfo, enumSet, l, executor);
            CompletableFuture<CoreConnection> cf = new CompletableFuture<CoreConnection>();
            EnumSet[] aCreateModes = new EnumSet[]{createModes};
            timeToRetry = Math.max(0L, timeToRetry);
            long giveUp = Clock.clock() + timeToRetry;
            long interval = this.connectionCreationBroker.appointNextAttempt();
            if (interval > 0L) {
                long sleepTime = Math.min(Math.max(0L, giveUp - Clock.clock()), interval);
                if (sleepTime > 0L) {
                    this.trace(Level.FINEST, CLASS_NAME, "createAsync", "given up to create a connection within timeToRetry", null, null, new Object[0]);
                    UniversalConnectionPoolManagerBase.getTimerManager().schedule(() -> this.lambda$createAsync$2((ConnectionRetrievalInfo)cri, aCreateModes, giveUp, (Executor)executor2, cf), sleepTime, 0L);
                }
            } else {
                if (this.activeCount.get() + this.pendingCreateCount.get() > this.connectionSource.limits().getMaxPerService()) {
                    this.trace(Level.FINEST, CLASS_NAME, "createAsync", "cannot create new connections, max connections per service limit reached", null, null, new Object[0]);
                    cf.complete(null);
                    CompletableFuture<CoreConnection> completableFuture = cf;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createAsync", "returning {0}", null, null, completableFuture);
                    return completableFuture;
                }
                this.pendingCreateCount.incrementAndGet();
                this.createAsync((ConnectionRetrievalInfo)cri, aCreateModes[0], (Executor)executor2).whenCompleteAsync((arg_0, arg_1) -> this.lambda$createAsync$4(cf, aCreateModes, (ConnectionRetrievalInfo)cri, giveUp, (Executor)executor2, arg_0, arg_1), (Executor)executor2);
            }
            CompletableFuture<CoreConnection> completableFuture = cf;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createAsync", "returning {0}", null, null, completableFuture);
            return completableFuture;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createAsync", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private static boolean isUnableToCreateConnection(UniversalConnectionPoolException e) {
        return e.getErrorCode() == 45067;
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private UniversalPooledConnection createConnectionInterruptably(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createConnectionInterruptably", "entering args ({0})", null, null, connectionRetrievalInfo);
            UniversalPooledConnection universalPooledConnection = InterruptableActor.doAction(new InterruptableActor.Action((ConnectionRetrievalInfo)cri){
                final /* synthetic */ ConnectionRetrievalInfo val$cri;
                {
                    this.val$cri = connectionRetrievalInfo;
                }

                @Override
                public UniversalPooledConnection exec() throws UniversalConnectionPoolException {
                    return Service.this.connectionSource.createPooledConnection(this.val$cri);
                }

                @Override
                public String getDescriptor() {
                    return ((OracleJDBCConnectionRetrievalInfo)this.val$cri).getInstanceName();
                }
            });
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createConnectionInterruptably", "returning {0}", null, null, universalPooledConnection);
            return universalPooledConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createConnectionInterruptably", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private CompletionStage<UniversalPooledConnection> createConnectionInterruptablyAsync(ConnectionRetrievalInfo connectionRetrievalInfo, Executor executor) {
        try {
            void executor2;
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createConnectionInterruptablyAsync", "entering args ({0}, {1})", null, null, connectionRetrievalInfo, executor);
            CompletionStage<UniversalPooledConnection> completionStage = this.connectionSource.createPooledConnectionAsync((ConnectionRetrievalInfo)cri, (Executor)executor2);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createConnectionInterruptablyAsync", "returning {0}", null, null, completionStage);
            return completionStage;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createConnectionInterruptablyAsync", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    void interruptPendingCreations() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "interruptPendingCreations", "entering args ()", null, null, new Object[0]);
            Map<String, ServiceMember> memberMap = this.getAllMembers().stream().collect(Collectors.toMap(ServiceMember::name, p -> p));
            this.trace(Level.FINEST, CLASS_NAME, "interruptPendingCreations", "memberMap: {0}", null, null, memberMap.toString());
            InterruptableActor.registerPredicate(p -> {
                String instName = ((InterruptableActor.Action)p.get1st()).getDescriptor();
                if (null == instName) {
                    return false;
                }
                ServiceMember sm = (ServiceMember)memberMap.get(instName);
                return null == sm ? false : !sm.active();
            });
            InterruptableActor.triggerInterrupts();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "interruptPendingCreations", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "interruptPendingCreations", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private CoreConnection create(ConnectionRetrievalInfo connectionRetrievalInfo, EnumSet<ConnectionSource.CreateMode> enumSet) throws UniversalConnectionPoolException {
        try {
            UniversalPooledConnection upc;
            Object context;
            EnumSet<ConnectionSource.CreateMode> createModes;
            Set<Object> possibleInstances;
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "create", "entering args ({0}, {1})", null, null, connectionRetrievalInfo, enumSet);
            ServiceMember[] bestInstance = new ServiceMember[]{null};
            boolean isRoutingEnabled = this.connectionSource.isDataDependentRoutingEnabled();
            if (isRoutingEnabled && !this.routingCache().hasInstanceToGrow((ConnectionRetrievalInfo)cri)) {
                CoreConnection coreConnection = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "create", "returning {0}", null, null, coreConnection);
                return coreConnection;
            }
            Set<Object> set = possibleInstances = isRoutingEnabled ? this.routingCache().instancesToGrow((ConnectionRetrievalInfo)cri) : new HashSet();
            if (this.connectionSource.isColocation()) {
                this.trace(Level.FINE, CLASS_NAME, "create", "Using COLOCATION, disable UP-event LB", null, null, new Object[0]);
                createModes = EnumSet.noneOf(ConnectionSource.CreateMode.class);
                this.allowInstNameAtConnect.set(false);
            }
            if (isRoutingEnabled && possibleInstances.size() == 0) {
                createModes = EnumSet.noneOf(ConnectionSource.CreateMode.class);
            }
            ConnectionAffinityCallback affinityCallback = cri.getConnectionAffinityCallback();
            if (createModes.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && null != affinityCallback && null != (context = affinityCallback.getConnectionAffinityContext()) && context instanceof AffinityContext) {
                AffinityContext affinityContext = (AffinityContext)context;
                String affInstName = affinityContext.getInstanceName();
                if (null != affInstName) {
                    int upperLimit;
                    Object event = this.mostRecentONSEvent.get();
                    if (null == event || event instanceof FailoverDriver.Event) {
                        upperLimit = this.connectionSource.limits().getMax();
                    } else if (event instanceof LoadBalancer.Event) {
                        int max = this.connectionSource.limits().getMax();
                        if (max < Integer.MAX_VALUE) {
                            switch (affinityCallback.getAffinityPolicy()) {
                                case WEBSESSION_BASED_AFFINITY: 
                                case DATA_BASED_AFFINITY: {
                                    LoadBalancer.Event lbEvent = (LoadBalancer.Event)event;
                                    upperLimit = (int)((float)max * lbEvent.normalizedPercent(affInstName) / 100.0f);
                                    break;
                                }
                                case TRANSACTION_BASED_AFFINITY: {
                                    upperLimit = max;
                                    break;
                                }
                                default: {
                                    this.trace(Level.FINE, CLASS_NAME, "create", "unknown affinity policy", null, null, new Object[0]);
                                    upperLimit = max;
                                    break;
                                }
                            }
                        } else {
                            upperLimit = Integer.MAX_VALUE;
                        }
                    } else {
                        throw new IllegalStateException("wrong ONS event object");
                    }
                    ServiceMember inst = this.getMember(affInstName, affinityContext.getDatabaseUniqueName(), affinityContext.getServiceName());
                    if (null != inst && inst.activeCount.get() < upperLimit) {
                        if (!possibleInstances.stream().anyMatch(k -> k.name().equals(affInstName))) {
                            this.lbStats.onFailedAffBorrowed();
                            inst.lbStats.onFailedAffBorrowed();
                            affinityCallback.setConnectionAffinityContext(null);
                        } else {
                            bestInstance[0] = inst;
                            this.lbStats.onSuccessfulAffBorrowed();
                            inst.lbStats.onSuccessfulAffBorrowed();
                        }
                    } else {
                        this.lbStats.onFailedAffBorrowed();
                        if (inst != null) {
                            inst.lbStats.onFailedAffBorrowed();
                        }
                        affinityCallback.setConnectionAffinityContext(null);
                    }
                } else {
                    affinityCallback.setConnectionAffinityContext(null);
                    throw new IllegalStateException("wrong affinity context (missing instance name)");
                }
            }
            if (createModes.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && null == bestInstance[0]) {
                bestInstance[0] = WLSJTAPlugin.getXAInstance();
                this.trace(Level.FINEST, CLASS_NAME, "create", "##### XA-affinity instance from WLS JTA as BEST_INSTANCE for creating connection: {0}", null, null, bestInstance[0]);
                if (bestInstance[0] == null) {
                    bestInstance[0] = this.underloadedInstance((ConnectionRetrievalInfo)cri);
                }
            }
            try {
                if (createModes.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && bestInstance[0] == null && isRoutingEnabled) {
                    bestInstance[0] = this.routingCache().getBestInstanceToGrow((ConnectionRetrievalInfo)cri);
                }
                if (bestInstance[0] != null && isRoutingEnabled) {
                    this.routingCache().onConnectionRequest(bestInstance[0]);
                }
                String targetInst = bestInstance[0] != null && !"***noname***".equals(bestInstance[0].name()) ? bestInstance[0].name() : null;
                this.trace(Level.FINEST, CLASS_NAME, "create", "targetInst={0}, instances={1}", null, null, targetInst, this.serviceMembers.values().toString());
                OracleJDBCConnectionRetrievalInfo targetCri = cri instanceof JDBCConnectionRetrievalInfo ? new OracleJDBCConnectionRetrievalInfo((JDBCConnectionRetrievalInfo)cri, targetInst) : cri;
                this.trace(Level.FINEST, CLASS_NAME, "create", "about to make an attempt to create a connection", null, null, new Object[0]);
                UniversalPooledConnection lupc = null;
                try {
                    lupc = this.createConnectionInterruptably(targetCri);
                }
                catch (UniversalConnectionPoolException ucpe) {
                    this.trace(Level.WARNING, CLASS_NAME, "create", "Creating connection hit exception:", null, ucpe, new Object[0]);
                    SQLException sqle = ucpe.traverseToSQLExceptionCause();
                    if (Objects.nonNull(sqle)) {
                        int errorCode = sqle.getErrorCode();
                        this.trace(Level.FINEST, CLASS_NAME, "create", "errorCode={0}", null, null, errorCode);
                        if (12521 == errorCode || 12514 == errorCode || 12757 == errorCode || 12523 == errorCode) {
                            UCPErrorHandler.throwUniversalConnectionPoolException(67, ucpe);
                        }
                    }
                    throw ucpe;
                }
                upc = lupc;
            }
            finally {
                if (isRoutingEnabled && bestInstance[0] != null) {
                    this.routingCache().onConnectionRequestComplete(bestInstance[0]);
                }
            }
            if (null == upc) {
                this.trace(Level.FINE, CLASS_NAME, "create", "unable to create a connection", null, null, new Object[0]);
                CoreConnection coreConnection = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "create", "returning {0}", null, null, coreConnection);
                return coreConnection;
            }
            this.checkAndRegister();
            upc.plugDelegator(CoreConnectionImpl.create(this, upc, this.getDiagnosable()));
            CoreConnection coreConnection = upc.getDelegator();
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "create", "returning {0}", null, null, coreConnection);
            return coreConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "create", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public CompletionStage<CoreConnection> createAsync(ConnectionRetrievalInfo connectionRetrievalInfo, EnumSet<ConnectionSource.CreateMode> enumSet, Executor executor) {
        try {
            void executor2;
            Object context;
            EnumSet<ConnectionSource.CreateMode> createModes;
            Set<Object> possibleInstances;
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createAsync", "entering args ({0}, {1}, {2})", null, null, connectionRetrievalInfo, enumSet, executor);
            CompletableFuture<CoreConnection> cf = new CompletableFuture<CoreConnection>();
            ServiceMember[] bestInstance = new ServiceMember[]{null};
            boolean isRoutingEnabled = this.connectionSource.isDataDependentRoutingEnabled();
            if (isRoutingEnabled && !this.routingCache().hasInstanceToGrow((ConnectionRetrievalInfo)cri)) {
                cf.complete(null);
                CompletableFuture<CoreConnection> completableFuture = cf;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createAsync", "returning {0}", null, null, completableFuture);
                return completableFuture;
            }
            Set<Object> set = possibleInstances = isRoutingEnabled ? this.routingCache().instancesToGrow((ConnectionRetrievalInfo)cri) : new HashSet();
            if (this.connectionSource.isColocation()) {
                this.trace(Level.FINE, CLASS_NAME, "createAsync", "Using COLOCATION, disable UP-event LB", null, null, new Object[0]);
                createModes = EnumSet.noneOf(ConnectionSource.CreateMode.class);
                this.allowInstNameAtConnect.set(false);
            }
            if (isRoutingEnabled && possibleInstances.size() == 0) {
                createModes = EnumSet.noneOf(ConnectionSource.CreateMode.class);
            }
            ConnectionAffinityCallback affinityCallback = cri.getConnectionAffinityCallback();
            if (createModes.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && null != affinityCallback && null != (context = affinityCallback.getConnectionAffinityContext()) && context instanceof AffinityContext) {
                AffinityContext affinityContext = (AffinityContext)context;
                String affInstName = affinityContext.getInstanceName();
                if (null != affInstName) {
                    int upperLimit;
                    Object event = this.mostRecentONSEvent.get();
                    if (null == event || event instanceof FailoverDriver.Event) {
                        upperLimit = this.connectionSource.limits().getMax();
                    } else if (event instanceof LoadBalancer.Event) {
                        int max = this.connectionSource.limits().getMax();
                        if (max < Integer.MAX_VALUE) {
                            switch (affinityCallback.getAffinityPolicy()) {
                                case WEBSESSION_BASED_AFFINITY: 
                                case DATA_BASED_AFFINITY: {
                                    LoadBalancer.Event lbEvent = (LoadBalancer.Event)event;
                                    upperLimit = (int)((float)max * lbEvent.normalizedPercent(affInstName) / 100.0f);
                                    break;
                                }
                                case TRANSACTION_BASED_AFFINITY: {
                                    upperLimit = max;
                                    break;
                                }
                                default: {
                                    this.trace(Level.FINE, CLASS_NAME, "createAsync", "unknown affinity policy", null, null, new Object[0]);
                                    upperLimit = max;
                                    break;
                                }
                            }
                        } else {
                            upperLimit = Integer.MAX_VALUE;
                        }
                    } else {
                        cf.completeExceptionally(new IllegalStateException("wrong ONS event object"));
                        CompletableFuture<CoreConnection> completableFuture = cf;
                        this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createAsync", "returning {0}", null, null, completableFuture);
                        return completableFuture;
                    }
                    ServiceMember inst = this.getMember(affInstName, affinityContext.getDatabaseUniqueName(), affinityContext.getServiceName());
                    if (null != inst && inst.activeCount.get() < upperLimit) {
                        if (!possibleInstances.stream().anyMatch(k -> k.name().equals(affInstName))) {
                            this.lbStats.onFailedAffBorrowed();
                            inst.lbStats.onFailedAffBorrowed();
                            affinityCallback.setConnectionAffinityContext(null);
                        } else {
                            bestInstance[0] = inst;
                            this.lbStats.onSuccessfulAffBorrowed();
                            inst.lbStats.onSuccessfulAffBorrowed();
                        }
                    } else {
                        this.lbStats.onFailedAffBorrowed();
                        inst.lbStats.onFailedAffBorrowed();
                        affinityCallback.setConnectionAffinityContext(null);
                    }
                } else {
                    affinityCallback.setConnectionAffinityContext(null);
                    cf.completeExceptionally(new IllegalStateException("wrong affinity context (missing instance name)"));
                    CompletableFuture<CoreConnection> completableFuture = cf;
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createAsync", "returning {0}", null, null, completableFuture);
                    return completableFuture;
                }
            }
            if (createModes.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && null == bestInstance[0]) {
                bestInstance[0] = this.underloadedInstance((ConnectionRetrievalInfo)cri);
            }
            if (createModes.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && bestInstance[0] == null && isRoutingEnabled) {
                bestInstance[0] = this.routingCache().getBestInstanceToGrow((ConnectionRetrievalInfo)cri);
                if (bestInstance[0] != null) {
                    this.routingCache().onConnectionRequest(bestInstance[0]);
                }
            }
            String targetInst = bestInstance[0] != null ? bestInstance[0].name() : null;
            this.trace(Level.FINEST, CLASS_NAME, "createAsync", "targetInst={0}, instances={1}", null, null, targetInst, this.serviceMembers.values());
            OracleJDBCConnectionRetrievalInfo targetCri = cri instanceof JDBCConnectionRetrievalInfo ? new OracleJDBCConnectionRetrievalInfo((JDBCConnectionRetrievalInfo)cri, targetInst) : cri;
            this.trace(Level.FINEST, CLASS_NAME, "createAsync", "about to make an attempt to create a connection", null, null, new Object[0]);
            this.createConnectionInterruptablyAsync(targetCri, (Executor)executor2).whenCompleteAsync((lupc, e) -> {
                if (isRoutingEnabled && bestInstance[0] != null) {
                    this.routingCache().onConnectionRequestComplete(bestInstance[0]);
                }
                if (Objects.nonNull(e) && e instanceof UniversalConnectionPoolException) {
                    UniversalConnectionPoolException ucpe = (UniversalConnectionPoolException)e;
                    SQLException sqle = ucpe.traverseToSQLExceptionCause();
                    if (Objects.isNull(sqle)) {
                        cf.completeExceptionally((Throwable)e);
                        return;
                    }
                    int errorCode = sqle.getErrorCode();
                    this.trace(Level.FINEST, CLASS_NAME, "createAsync", "errorCode={0}", null, null, errorCode);
                    if (12521 == errorCode || 12514 == errorCode || 12757 == errorCode || 12523 == errorCode) {
                        this.trace(Level.FINEST, CLASS_NAME, "createAsync", "caught {0}", null, null, sqle.getMessage());
                        cf.completeExceptionally(UCPErrorHandler.newUniversalConnectionPoolException(67, e));
                        return;
                    }
                    this.trace(Level.FINEST, CLASS_NAME, "createAsync", "errorCode={0}", null, null, errorCode);
                    cf.completeExceptionally((Throwable)e);
                    return;
                }
                if (Objects.isNull(lupc)) {
                    cf.complete(null);
                    return;
                }
                this.checkAndRegister();
                try {
                    lupc.plugDelegator(CoreConnectionImpl.create(this, lupc, this.getDiagnosable()));
                    cf.complete(lupc.getDelegator());
                }
                catch (UniversalConnectionPoolException ucpe) {
                    cf.completeExceptionally(ucpe);
                    return;
                }
            }, (Executor)executor2);
            CompletableFuture<CoreConnection> completableFuture = cf;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createAsync", "returning {0}", null, null, completableFuture);
            return completableFuture;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Service", "createAsync", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private FailoverDriver prepareFailoverDriver(final ConnectionSource.FailoverCallback failoverCallback) {
        return new FailoverDriver(this.diagnosticsCollector){

            @Override
            protected ConnectionSource.FailoverCallback.Result onEvent(FailoverDriver.Event event, Predicate<CoreConnection> cleanupSelector, Predicate<CoreConnection> markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
                Service.this.mostRecentONSEvent.set(event);
                if (Service.this.connectionSource.isDataDependentRoutingEnabled()) {
                    Service.this.routingCache().onHAEvent(event);
                }
                return null != failoverCallback ? failoverCallback.handle(cleanupSelector, markupSelector, isGracefulDraining, restoreAfterCleanup) : new ConnectionSource.FailoverCallback.Result();
            }

            @Override
            protected Service service() {
                return Service.this;
            }
        };
    }

    private LoadBalancer prepareLoadBalancer(final ConnectionSource.RebalanceCallback rebalanceCallback) {
        if (this.connectionSource.isColocation()) {
            return new LoadBalancer(this.diagnosticsCollector){

                @Override
                protected ConnectionSource.RebalanceCallback.Result onEvent(LoadBalancer.Event event, Predicate<CoreConnection> gravitationCleanupSelector, Predicate<CoreConnection> gravitationMarkupSelector) {
                    return new ConnectionSource.RebalanceCallback.Result();
                }

                @Override
                protected Service service() {
                    return Service.this;
                }
            };
        }
        return new LoadBalancer(this.diagnosticsCollector){

            @Override
            protected ConnectionSource.RebalanceCallback.Result onEvent(LoadBalancer.Event event, Predicate<CoreConnection> gravitationCleanupSelector, Predicate<CoreConnection> gravitationMarkupSelector) {
                Service.this.mostRecentONSEvent.set(event);
                return null != rebalanceCallback ? rebalanceCallback.handle(gravitationCleanupSelector, gravitationMarkupSelector) : new ConnectionSource.RebalanceCallback.Result();
            }

            @Override
            protected Service service() {
                return Service.this;
            }
        };
    }

    public FailoverDriver.Stats failoverDriverStats() {
        return this.fdStats;
    }

    public LoadBalancer.Stats loadBalancerStats() {
        return this.lbStats;
    }

    ServiceMember underloadedInstance() {
        return this.underloadedInstance(null);
    }

    ServiceMember underloadedInstance(ConnectionRetrievalInfo cri) {
        Object event = this.mostRecentONSEvent.get();
        if (null == event) {
            return null;
        }
        ServiceMember underloadedInstance = null;
        if (event instanceof LoadBalancer.Event) {
            underloadedInstance = this.loadBalancer.underloadedInstance(cri);
        } else if (event instanceof FailoverDriver.Event) {
            underloadedInstance = this.failoverDriver.underloadedInstance(cri);
        } else {
            throw new IllegalStateException("wrong ONS event object");
        }
        return underloadedInstance;
    }

    public Predicate<CoreConnection> loadBalancedBorrowSelector(ConnectionRetrievalInfo cri) {
        return this.loadBalancer.borrowSelector(cri);
    }

    private Properties getProperties(CoreConnection conn) {
        UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
        return upc.getDatabaseConnectionProperties();
    }

    void stop() {
        this.failoverDriver.stop();
        this.loadBalancer.stop();
    }

    public String toString() {
        return this.fullServiceName == null ? "Unnamed Service" : this.fullServiceName;
    }

    public long totalBorrowTimes(ConnectionRetrievalInfo cri, Collection<ServiceMember> allMembers) {
        if (cri == null) {
            return this.lbStats.borrowTimes.totalDelta();
        }
        return allMembers.stream().mapToLong(sm -> sm.lbStats.borrowTimes.totalDelta()).sum();
    }

    int getLastDrainTimeout() {
        return this.lastDrainTimeout.get();
    }

    void setLastDrainTimeout(int drainTimeout) {
        this.lastDrainTimeout.set(drainTimeout);
    }

    private DataDependentRoutingCache prepareRoutingCache() {
        if (this.connectionSource.isShardedDatabase()) {
            return new ShardRoutingCache(this.diagnosticsCollector){

                @Override
                protected Service service() {
                    return Service.this;
                }
            };
        }
        return new RACDataAffinityRoutingCache(this.diagnosticsCollector){

            @Override
            protected Service service() {
                return Service.this;
            }
        };
    }

    Predicate<CoreConnection> serviceBasedRepurposeSelector(ConnectionRetrievalInfo cri, boolean balanced) {
        this.awaitRegister();
        if (this.activeCount.get() + this.pendingCreateCount.get() >= this.connectionSource.limits().getMaxPerService()) {
            return c -> false;
        }
        ServiceMember underloadedInst = this.underloadedInstance();
        String underloadedInstName = Objects.nonNull(underloadedInst) ? underloadedInst.name() : null;
        Set<String> dbInstsForRepurpose = Service.buildInstsForRepurpose(balanced, underloadedInstName, this.placement);
        return SelectorsUtil.availableSelector.and(SelectorsUtil.notBadSelector).and(conn -> dbInstsForRepurpose.size() > 0 && dbInstsForRepurpose.contains(conn.serviceMember().name()));
    }

    boolean isRLBEnabled() {
        return this.rlbEnabled.get();
    }

    void setRLBEnabled(boolean enabled) {
        this.rlbEnabled.set(enabled);
    }

    boolean allowInstanceNameAtConnect() {
        return this.allowInstNameAtConnect.get();
    }

    public static Set<String> buildInstsForRepurpose(boolean balanced, String underloadedInstName, Set<String> placementInsts) {
        assert (Objects.nonNull(placementInsts));
        HashSet<String> instsForRepurpose = new HashSet<String>();
        if (balanced) {
            if (Objects.nonNull(underloadedInstName) && placementInsts.contains(underloadedInstName)) {
                instsForRepurpose.add(underloadedInstName);
            }
        } else {
            instsForRepurpose.addAll(placementInsts);
        }
        return instsForRepurpose;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (!(other instanceof Service)) {
            return false;
        }
        Service otherService = (Service)other;
        if (this == otherService) {
            return true;
        }
        assert (null != this.fullServiceName);
        assert (null != otherService.fullServiceName);
        return this.areNamesMatched(otherService.fullServiceName);
    }

    public int hashCode() {
        return this.fullServiceName.hashCode();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    private /* synthetic */ void lambda$createAsync$4(CompletableFuture cf, EnumSet[] aCreateModes, ConnectionRetrievalInfo cri, long giveUp, Executor executor, CoreConnection conn, Throwable e) {
        this.pendingCreateCount.getAndDecrement();
        if (Objects.nonNull(conn)) {
            this.connectionCreationBroker.markDbAsOperable();
            this.trace(Level.FINEST, CLASS_NAME, "createAsync", "connection was successfully created: switching Connection Creation Broker off", null, null, new Object[0]);
            this.connectionSource.getConnectionCreationAttemptsSinceLastOutage().reset();
            cf.complete(conn);
            return;
        }
        if (Objects.nonNull(e)) {
            UniversalConnectionPoolException ucpe = (UniversalConnectionPoolException)e;
            if (e.getCause() instanceof SQLRecoverableException || Service.isUnableToCreateConnection(ucpe)) {
                if (Service.isUnableToCreateConnection(ucpe) && aCreateModes[0].contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE)) {
                    aCreateModes[0] = EnumSet.noneOf(ConnectionSource.CreateMode.class);
                    this.trace(Level.FINEST, CLASS_NAME, "createAsync", "unable to connect to specific instance, setting createModes = EnumSet.noneOf(CreateMode.class)", null, null, new Object[0]);
                } else if (!this.connectionSource.failoverEnabled() || this.active.get()) {
                    this.connectionCreationBroker.markDbAsInoperable();
                    this.trace(Level.FINE, CLASS_NAME, "createAsync", "temporarily unable to create a connection: starting attempting to create connection with Connection Creation Broker", null, null, new Object[0]);
                    this.loadBalancer.disableRLBGravitation();
                    this.trace(Level.FINE, CLASS_NAME, "createAsync", "disabling RLB gravitation for the next {0} seconds", null, null, Util.getRLBGravitationInoperablePeriod());
                    this.connectionSource.getCumulativeConnectionCreationAttempts().increment();
                    this.connectionSource.getConnectionCreationAttemptsSinceLastOutage().increment();
                }
                this.createAsync(cri, aCreateModes[0], Math.max(0L, giveUp - Clock.clock()), executor).whenCompleteAsync((conn2, e2) -> {
                    if (Objects.nonNull(e2)) {
                        cf.completeExceptionally((Throwable)e2);
                        return;
                    }
                    if (Objects.nonNull(conn2)) {
                        cf.complete(conn2);
                    }
                }, executor);
            }
        }
    }

    private /* synthetic */ void lambda$createAsync$2(ConnectionRetrievalInfo cri, EnumSet[] aCreateModes, long giveUp, Executor executor, CompletableFuture cf) {
        this.createAsync(cri, aCreateModes[0], Math.max(0L, giveUp - Clock.clock()), executor).whenComplete((conn, e) -> {
            if (Objects.nonNull(conn)) {
                cf.complete(conn);
                return;
            }
        });
    }
}

