/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORADataFactory;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLLECTION_DATUM})
@Deprecated
public class OracleArray
extends DatumWithConnection
implements oracle.jdbc.internal.OracleArray {
    static final byte KOPUP_INLINE_COLL = 1;
    ArrayDescriptor descriptor;
    Object objArray;
    Map<?, ?> javaMap = null;
    Datum[] datumArray;
    byte[] locator;
    byte prefixFlag;
    byte[] prefixSegment;
    int numElems = -1;
    boolean enableBuffering = false;
    boolean enableIndexing = false;
    boolean isFreed = false;
    public static final int ACCESS_FORWARD = 1;
    public static final int ACCESS_REVERSE = 2;
    public static final int ACCESS_UNKNOWN = 3;
    int accessDirection = 3;
    long lastIndex;
    long lastOffset;
    long[] indexArray;
    long imageOffset;
    long imageLength;
    Object acProxy;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;

    public OracleArray(ArrayDescriptor arrayDescriptor, Connection connection, Object object) throws SQLException {
        OracleArray.assertNotNull(arrayDescriptor);
        this.descriptor = arrayDescriptor;
        OracleArray.assertNotNull(connection);
        if (!arrayDescriptor.getInternalConnection().isDescriptorSharable(((OracleConnection)connection).physicalConnectionWithin())) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct ARRAY instance, invalid connection").fillInStackTrace();
        }
        arrayDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.datumArray = object == null ? new Datum[0] : this.descriptor.toOracleArray(object, 1L, -1);
    }

    public OracleArray(ArrayDescriptor arrayDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        OracleArray.assertNotNull(arrayDescriptor);
        this.descriptor = arrayDescriptor;
        OracleArray.assertNotNull(connection);
        if (!arrayDescriptor.getInternalConnection().isDescriptorSharable(((OracleConnection)connection).physicalConnectionWithin())) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct ARRAY instance, invalid connection").fillInStackTrace();
        }
        arrayDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.datumArray = null;
        this.locator = null;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            String string = this.descriptor.getBaseName();
            return string;
        }
    }

    @Override
    public int getBaseType() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            int n2 = this.descriptor.getBaseType();
            return n2;
        }
    }

    @Override
    public Object getArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            Object[] objectArray = this.descriptor.toJavaArray(this, this, 1L, -1, this.getMap(), this.enableBuffering);
            return objectArray;
        }
    }

    @Override
    public Map<?, ?> getJavaMap() throws SQLException {
        this.getArray();
        return this.javaMap;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            Object[] objectArray = this.descriptor.toJavaArray(this, this, 1L, -1, map, this.enableBuffering);
            return objectArray;
        }
    }

    @Override
    public Object getArray(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            if (l2 < 1L || n2 < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid arguments, 'index' should be >= 1 and 'count' >= 0. An exception is thrown.").fillInStackTrace();
            }
            Object[] objectArray = this.descriptor.toJavaArray(this, this, l2, n2, this.getMap(), false);
            return objectArray;
        }
    }

    @Override
    public Object getArray(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            if (l2 < 1L || n2 < 0) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid arguments, 'index' should be >= 1 and 'count' >= 0. An exception is thrown.");
            }
            Object[] objectArray = this.descriptor.toJavaArray(this, this, l2, n2, map, false);
            return objectArray;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            ResultSet resultSet = this.getResultSet(this.getInternalConnection().getTypeMap());
            return resultSet;
        }
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            ResultSet resultSet = this.descriptor.toResultSet(this, this, 1L, -1, map, this.enableBuffering);
            return resultSet;
        }
    }

    @Override
    public ResultSet getResultSet(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            ResultSet resultSet = this.getResultSet(l2, n2, this.getInternalConnection().getTypeMap());
            return resultSet;
        }
    }

    @Override
    public ResultSet getResultSet(long l2, int n2, Map<String, Class<?>> map) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            if (l2 < 1L || n2 < -1) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getResultSet()");
            }
            ResultSet resultSet = this.descriptor.toResultSet(this, this, l2, n2, map, false);
            return resultSet;
        }
    }

    @Override
    public Datum[] getOracleArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            Datum[] datumArray = this.descriptor.toOracleArray(this, this, 1L, -1, this.enableBuffering);
            return datumArray;
        }
    }

    @Override
    public int length() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            int n2 = this.descriptor.toLength(this, this);
            return n2;
        }
    }

    @Override
    public Datum[] getOracleArray(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            if (l2 < 1L || n2 < 0) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getOracleArray()");
            }
            Datum[] datumArray = this.descriptor.toOracleArray(this, this, l2, n2, false);
            return datumArray;
        }
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            String string = null;
            if (this.descriptor == null) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61, "ARRAY");
            }
            string = this.descriptor.getName();
            String string2 = string;
            return string2;
        }
    }

    @Override
    public Map<String, Class<?>> getMap() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.getInternalConnection().getTypeMap();
    }

    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.getDescriptor();
    }

    @Override
    public ArrayDescriptor getDescriptor() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.descriptor;
    }

    @Override
    public byte[] toBytes() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            byte[] byArray = this.descriptor.toBytes(this, this, this.enableBuffering);
            return byArray;
        }
    }

    @Override
    public void setDatumArray(Datum[] datumArray) {
        this.datumArray = datumArray;
    }

    @Override
    public void setObjArray(Object object) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            if (object == null) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid argument, 'oarray' should not be null. An exception is thrown.");
            }
            this.objArray = object;
        }
    }

    @Override
    public void setJavaMap(Map<?, ?> map) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            this.javaMap = map;
        }
    }

    @Override
    public void setLocator(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.locator = byArray;
        }
    }

    @Override
    public void setPrefixSegment(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.prefixSegment = byArray;
        }
    }

    @Override
    public void setPrefixFlag(byte by) {
        this.prefixFlag = by;
    }

    @Override
    public byte[] getLocator() {
        return this.locator;
    }

    @Override
    public void setLength(int n2) {
        this.numElems = n2;
    }

    @Override
    public boolean hasDataSeg() {
        return this.locator == null;
    }

    @Override
    public boolean isInline() {
        return (this.prefixFlag & 1) == 1;
    }

    @Override
    public Object toJdbc() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return null;
    }

    public Object toJdbc(Map<String, Class<?>> map) throws SQLException {
        Class clazz;
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        Object object = this;
        if (map != null && (clazz = this.descriptor.getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    Object toClass(Class<?> clazz, Map<String, Class<?>> map) throws SQLException {
        Object object;
        block7: {
            if (this.isFreed) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
            }
            object = null;
            try {
                if (clazz == null || clazz == ARRAY.class || clazz == Array.class || clazz == oracle.jdbc.OracleArray.class || clazz == oracle.jdbc.internal.OracleArray.class) {
                    object = this;
                    break block7;
                }
                Object obj = clazz.newInstance();
                if (obj instanceof ORADataFactory) {
                    ORADataFactory oRADataFactory = (ORADataFactory)obj;
                    object = oRADataFactory.create(this, 2003);
                    break block7;
                }
                if (obj instanceof OracleDataFactory) {
                    OracleDataFactory oracleDataFactory = (OracleDataFactory)obj;
                    object = oracleDataFactory.create(this, 2003);
                    break block7;
                }
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
            }
            catch (InstantiationException instantiationException) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + illegalAccessException.getMessage());
            }
        }
        return object;
    }

    @Override
    public boolean isConvertibleTo(Class<?> clazz) {
        return false;
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new Object[n2][];
    }

    @Override
    public int[] getIntArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            int[] nArray = (int[])this.descriptor.toNumericArray(this, this, 1L, -1, 4, this.enableBuffering);
            return nArray;
        }
    }

    @Override
    public int[] getIntArray(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            int[] nArray = (int[])this.descriptor.toNumericArray(this, this, l2, n2, 4, false);
            return nArray;
        }
    }

    @Override
    public double[] getDoubleArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            double[] dArray = (double[])this.descriptor.toNumericArray(this, this, 1L, -1, 5, this.enableBuffering);
            return dArray;
        }
    }

    @Override
    public double[] getDoubleArray(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            double[] dArray = (double[])this.descriptor.toNumericArray(this, this, l2, n2, 5, false);
            return dArray;
        }
    }

    @Override
    public short[] getShortArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            short[] sArray = (short[])this.descriptor.toNumericArray(this, this, 1L, -1, 8, this.enableBuffering);
            return sArray;
        }
    }

    @Override
    public short[] getShortArray(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            short[] sArray = (short[])this.descriptor.toNumericArray(this, this, l2, n2, 8, false);
            return sArray;
        }
    }

    @Override
    public long[] getLongArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            long[] lArray = (long[])this.descriptor.toNumericArray(this, this, 1L, -1, 7, this.enableBuffering);
            return lArray;
        }
    }

    @Override
    public long[] getLongArray(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            long[] lArray = (long[])this.descriptor.toNumericArray(this, this, l2, n2, 7, false);
            return lArray;
        }
    }

    @Override
    public float[] getFloatArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            float[] fArray = (float[])this.descriptor.toNumericArray(this, this, 1L, -1, 6, this.enableBuffering);
            return fArray;
        }
    }

    @Override
    public float[] getFloatArray(long l2, int n2) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            float[] fArray = (float[])this.descriptor.toNumericArray(this, this, l2, n2, 6, false);
            return fArray;
        }
    }

    @Override
    public void setAutoBuffering(boolean bl) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            this.enableBuffering = bl;
        }
    }

    @Override
    public boolean getAutoBuffering() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.enableBuffering;
    }

    @Override
    public void setAutoIndexing(boolean bl, int n2) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            this.enableIndexing = bl;
            this.accessDirection = n2;
        }
    }

    @Override
    public void setAutoIndexing(boolean bl) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            this.enableIndexing = bl;
            this.accessDirection = 3;
        }
    }

    @Override
    public boolean getAutoIndexing() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.enableIndexing;
    }

    @Override
    public int getAccessDirection() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.accessDirection;
    }

    @Override
    public void setLastIndexOffset(long l2, long l3) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        this.lastIndex = l2;
        this.lastOffset = l3;
    }

    @Override
    public void setIndexOffset(long l2, long l3) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        if (this.indexArray == null) {
            this.indexArray = new long[this.numElems];
        }
        this.indexArray[(int)l2 - 1] = l3;
    }

    @Override
    public long getLastIndex() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.lastIndex;
    }

    @Override
    public long getLastOffset() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.lastOffset;
    }

    @Override
    public long getOffset(long l2) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        long l3 = -1L;
        if (this.indexArray != null) {
            l3 = this.indexArray[(int)l2 - 1];
        }
        return l3;
    }

    @Override
    public void setImage(byte[] byArray, long l2, long l3) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        this.setShareBytes(byArray);
        this.imageOffset = l2;
        this.imageLength = l3;
    }

    @Override
    public void setImageLength(long l2) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        this.imageLength = l2;
    }

    @Override
    public long getImageOffset() {
        return this.imageOffset;
    }

    @Override
    public long getImageLength() {
        return this.imageLength;
    }

    @Override
    public String stringValue() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        Datum[] datumArray = this.getOracleArray();
        Object object = "[";
        for (int i2 = 0; i2 < datumArray.length; ++i2) {
            if (i2 != 0) {
                object = (String)object + ", ";
            }
            object = datumArray[i2] == null ? (String)object + "null" : (String)object + datumArray[i2].stringValue();
        }
        object = (String)object + "]";
        return object;
    }

    @Override
    public void free() throws SQLException {
        this.isFreed = true;
    }

    public boolean isFreed() {
        return this.isFreed;
    }

    @Override
    public int getNumElems() {
        return this.numElems;
    }

    @Override
    public Datum[] getDatumArray() {
        return this.datumArray;
    }

    @Override
    public Object getObjArray() {
        return this.objArray;
    }

    @Override
    public void setNullObjArray() {
        this.objArray = null;
    }

    @Override
    public void setACProxy(Object object) {
        this.acProxy = object;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    static {
        try {
            $$$methodRef$$$69 = OracleArray.class.getDeclaredConstructor(ArrayDescriptor.class, byte[].class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$68 = OracleArray.class.getDeclaredConstructor(ArrayDescriptor.class, Connection.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$67 = OracleArray.class.getDeclaredMethod("getACProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$66 = OracleArray.class.getDeclaredMethod("setACProxy", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$65 = OracleArray.class.getDeclaredMethod("setNullObjArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = OracleArray.class.getDeclaredMethod("getObjArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = OracleArray.class.getDeclaredMethod("getDatumArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = OracleArray.class.getDeclaredMethod("getNumElems", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = OracleArray.class.getDeclaredMethod("isFreed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = OracleArray.class.getDeclaredMethod("free", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = OracleArray.class.getDeclaredMethod("stringValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = OracleArray.class.getDeclaredMethod("getImageLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = OracleArray.class.getDeclaredMethod("getImageOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = OracleArray.class.getDeclaredMethod("setImageLength", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = OracleArray.class.getDeclaredMethod("setImage", byte[].class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = OracleArray.class.getDeclaredMethod("getOffset", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = OracleArray.class.getDeclaredMethod("getLastOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = OracleArray.class.getDeclaredMethod("getLastIndex", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = OracleArray.class.getDeclaredMethod("setIndexOffset", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = OracleArray.class.getDeclaredMethod("setLastIndexOffset", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OracleArray.class.getDeclaredMethod("getAccessDirection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OracleArray.class.getDeclaredMethod("getAutoIndexing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OracleArray.class.getDeclaredMethod("setAutoIndexing", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OracleArray.class.getDeclaredMethod("setAutoIndexing", Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OracleArray.class.getDeclaredMethod("getAutoBuffering", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OracleArray.class.getDeclaredMethod("setAutoBuffering", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OracleArray.class.getDeclaredMethod("getFloatArray", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OracleArray.class.getDeclaredMethod("getFloatArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OracleArray.class.getDeclaredMethod("getLongArray", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OracleArray.class.getDeclaredMethod("getLongArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleArray.class.getDeclaredMethod("getShortArray", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleArray.class.getDeclaredMethod("getShortArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleArray.class.getDeclaredMethod("getDoubleArray", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleArray.class.getDeclaredMethod("getDoubleArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleArray.class.getDeclaredMethod("getIntArray", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleArray.class.getDeclaredMethod("getIntArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleArray.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleArray.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleArray.class.getDeclaredMethod("toClass", Class.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleArray.class.getDeclaredMethod("toJdbc", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleArray.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleArray.class.getDeclaredMethod("isInline", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleArray.class.getDeclaredMethod("hasDataSeg", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleArray.class.getDeclaredMethod("setLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleArray.class.getDeclaredMethod("getLocator", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleArray.class.getDeclaredMethod("setPrefixFlag", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleArray.class.getDeclaredMethod("setPrefixSegment", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleArray.class.getDeclaredMethod("setLocator", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleArray.class.getDeclaredMethod("setJavaMap", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleArray.class.getDeclaredMethod("setObjArray", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleArray.class.getDeclaredMethod("setDatumArray", Datum[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleArray.class.getDeclaredMethod("toBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleArray.class.getDeclaredMethod("getDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleArray.class.getDeclaredMethod("getOracleMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleArray.class.getDeclaredMethod("getMap", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleArray.class.getDeclaredMethod("getSQLTypeName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleArray.class.getDeclaredMethod("getOracleArray", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleArray.class.getDeclaredMethod("length", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleArray.class.getDeclaredMethod("getOracleArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleArray.class.getDeclaredMethod("getResultSet", Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleArray.class.getDeclaredMethod("getResultSet", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleArray.class.getDeclaredMethod("getResultSet", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleArray.class.getDeclaredMethod("getResultSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleArray.class.getDeclaredMethod("getArray", Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleArray.class.getDeclaredMethod("getArray", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleArray.class.getDeclaredMethod("getArray", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleArray.class.getDeclaredMethod("getJavaMap", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleArray.class.getDeclaredMethod("getArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleArray.class.getDeclaredMethod("getBaseType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleArray.class.getDeclaredMethod("getBaseTypeName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

