/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={OracleBfile.class, oracle.jdbc.internal.OracleBfile.class})
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class NonTxnReplayableBfile
extends NonTxnReplayableBase
implements Replayable {
    private static final Method GETBINSTREAM_METHOD;
    private static final Method GETBINSTREAM_LONG_METHOD;
    private static final int MAX_CHUNK_SIZE = 32512;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    private static final Method getGetBinaryStreamMethod() {
        try {
            return oracle.jdbc.internal.OracleBfile.class.getMethod("getBinaryStream", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleBfile.class.getMethod("getBinaryStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        if (object instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase nonTxnReplayableBase = (NonTxnReplayableBase)object;
            nonTxnReplayableBase.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(method, object);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getBinaryStream() throws SQLException {
        if (GETBINSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleBfile oracleBfile = (oracle.jdbc.internal.OracleBfile)this.getDelegate();
            InputStream inputStream = oracleBfile.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBfile)((Object)this), 32512, 0L);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public InputStream getBinaryStream(long l2) throws SQLException {
        if (GETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_LONG_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleBfile oracleBfile = (oracle.jdbc.internal.OracleBfile)this.getDelegate();
            InputStream inputStream = oracleBfile.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBfile)((Object)this), 32512, l2);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        oracle.jdbc.internal.OracleBfile oracleBfile = (oracle.jdbc.internal.OracleBfile)this.getDelegate();
        return oracleBfile.getInternalConnection();
    }

    static {
        try {
            $$$methodRef$$$9 = NonTxnReplayableBfile.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = NonTxnReplayableBfile.class.getDeclaredMethod("getInternalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = NonTxnReplayableBfile.class.getDeclaredMethod("getBinaryStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = NonTxnReplayableBfile.class.getDeclaredMethod("getBinaryStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = NonTxnReplayableBfile.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = NonTxnReplayableBfile.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = NonTxnReplayableBfile.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = NonTxnReplayableBfile.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = NonTxnReplayableBfile.class.getDeclaredMethod("getGetBinaryStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = NonTxnReplayableBfile.class.getDeclaredMethod("getGetBinaryStreamMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        GETBINSTREAM_METHOD = NonTxnReplayableBfile.getGetBinaryStreamMethod();
        GETBINSTREAM_LONG_METHOD = NonTxnReplayableBfile.getGetBinaryStreamLongMethod();
    }
}

