/*-
 *
 *  This file is part of Oracle NoSQL Database
 *  Copyright (C) 2011, 2014 Oracle and/or its affiliates.  All rights reserved.
 *
 * If you have received this file as part of Oracle NoSQL Database the
 * following applies to the work as a whole:
 *
 *   Oracle NoSQL Database server software is free software: you can
 *   redistribute it and/or modify it under the terms of the GNU Affero
 *   General Public License as published by the Free Software Foundation,
 *   version 3.
 *
 *   Oracle NoSQL Database is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Affero General Public License for more details.
 *
 * If you have received this file as part of Oracle NoSQL Database Client or
 * distributed separately the following applies:
 *
 *   Oracle NoSQL Database client software is free software: you can
 *   redistribute it and/or modify it under the terms of the Apache License
 *   as published by the Apache Software Foundation, version 2.0.
 *
 * You should have received a copy of the GNU Affero General Public License
 * and/or the Apache License in the LICENSE file along with Oracle NoSQL
 * Database client or server distribution.  If not, see
 * <http://www.gnu.org/licenses/>
 * or
 * <http://www.apache.org/licenses/LICENSE-2.0>.
 *
 * An active Oracle commercial licensing agreement for this product supersedes
 * these licenses and in such case the license notices, but not the copyright
 * notice, may be removed by you in connection with your distribution that is
 * in accordance with the commercial licensing terms.
 *
 * For more information please contact:
 *
 * berkeleydb-info_us@oracle.com
 *
 */

package oracle.kv;

import java.util.Map;
import java.util.HashMap;

/**
 * @hidden
 * Constants representing all of the possible parameters that can be placed
 * in the External Table config file.
 */
public class ParamConstant {
    private final static Map<String, ParamConstant> allParams =
        new HashMap<String, ParamConstant>();

    /* Publish Parameters */
    public final static ParamConstant CONNECTION_URL =
        new ParamConstant("oracle.kv.exttab.connection.url");
    public final static ParamConstant CONNECTION_USER =
        new ParamConstant("oracle.kv.exttab.connection.user");
    public final static ParamConstant CONNECTION_TNS_ADMIN_PATH =
        new ParamConstant("oracle.kv.exttab.connection.tns_admin");
    public final static ParamConstant CONNECTION_TNS_ENTRY_NAME =
        new ParamConstant("oracle.kv.exttab.connection.tnsEntryName");
    public final static ParamConstant CONNECTION_WALLET_PATH =
        new ParamConstant("oracle.kv.exttab.connection.wallet_location");
    public final static ParamConstant TABLE_NAME =
        new ParamConstant("oracle.kv.exttab.tableName");

    /* Preprocessor Parameters */
    public final static ParamConstant KVSTORE_NAME =
        new ParamConstant("oracle.kv.kvstore");
    public final static ParamConstant KVSTORE_NODES =
        new ParamConstant("oracle.kv.hosts");
    public final static ParamConstant BATCH_SIZE =
        new ParamConstant("oracle.kv.batchSize");
    public final static ParamConstant PARENT_KEY =
        new ParamConstant("oracle.kv.parentKey");
    public final static ParamConstant SUB_RANGE =
        new ParamConstant("oracle.kv.subRange");
    public final static ParamConstant DEPTH =
        new ParamConstant("oracle.kv.depth");
    public final static ParamConstant CONSISTENCY =
        new ParamConstant("oracle.kv.consistency");
    public final static ParamConstant TIMEOUT =
        new ParamConstant("oracle.kv.timeout");
    public final static ParamConstant KEY_DELIMITER =
        new ParamConstant("oracle.kv.keyDelimiter");
    public final static ParamConstant VARIABLE_SIZE_BYTES =
        new ParamConstant("oracle.kv.variableSizeBytes");
    public final static ParamConstant FORMATTER_CLASS =
        new ParamConstant("oracle.kv.formatterClass");
    public final static ParamConstant KVSTORE_SECURITY =
        new ParamConstant("oracle.kv.security");

    /* Generated by Publish Utility. */
    public final static ParamConstant FILE_NUMBER =
        new ParamConstant("oracle.kv.exttab.externalTableFileNumber");
    public final static ParamConstant TOTAL_FILES =
        new ParamConstant("oracle.kv.exttab.totalExternalTableFiles");

    private String paramName;

    private ParamConstant(final String paramName) {
        this.paramName = paramName;
        allParams.put(paramName, this);
    }

    public String getName() {
        return paramName;
    }

    public static Map<String, ParamConstant> getAllParams() {
        return allParams;
    }
}
