/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.EnumSet;
import java.util.Iterator;
import oracle.kv.FaultException;
import oracle.kv.impl.util.FastExternalizable;

public class Durability
implements FastExternalizable {
    public static final Durability COMMIT_SYNC = new Durability(SyncPolicy.SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    public static final Durability COMMIT_NO_SYNC = new Durability(SyncPolicy.NO_SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    public static final Durability COMMIT_WRITE_NO_SYNC = new Durability(SyncPolicy.WRITE_NO_SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    private static final SyncPolicy[] SYNC_POLICIES_BY_ORDINAL;
    private static final ReplicaAckPolicy[] REPLICA_ACK_POLICIES_BY_ORDINAL;
    private final SyncPolicy masterSync;
    private final SyncPolicy replicaSync;
    private final ReplicaAckPolicy replicaAck;

    private static SyncPolicy getSyncPolicy(int ordinal) {
        if (ordinal < 0 || ordinal >= SYNC_POLICIES_BY_ORDINAL.length) {
            throw new RuntimeException("unknown SyncPolicy: " + ordinal);
        }
        return SYNC_POLICIES_BY_ORDINAL[ordinal];
    }

    private static ReplicaAckPolicy getReplicaAckPolicy(int ordinal) {
        if (ordinal < 0 || ordinal >= REPLICA_ACK_POLICIES_BY_ORDINAL.length) {
            throw new RuntimeException("unknown ReplicaAckPolicy: " + ordinal);
        }
        return REPLICA_ACK_POLICIES_BY_ORDINAL[ordinal];
    }

    public Durability(SyncPolicy masterSync, SyncPolicy replicaSync, ReplicaAckPolicy replicaAck) {
        this.masterSync = masterSync;
        this.replicaSync = replicaSync;
        this.replicaAck = replicaAck;
    }

    public Durability(ObjectInput in, short serialVersion) throws IOException {
        this.masterSync = Durability.getSyncPolicy(in.readUnsignedByte());
        this.replicaSync = Durability.getSyncPolicy(in.readUnsignedByte());
        this.replicaAck = Durability.getReplicaAckPolicy(in.readUnsignedByte());
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        out.writeByte(this.masterSync.ordinal());
        out.writeByte(this.replicaSync.ordinal());
        out.writeByte(this.replicaAck.ordinal());
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeShort(4);
            this.writeFastExternal(oos, (short)4);
            oos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new FaultException(e, false);
        }
    }

    public static Durability fromByteArray(byte[] keyBytes) {
        ByteArrayInputStream bais = new ByteArrayInputStream(keyBytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            short serialVersion = ois.readShort();
            return new Durability(ois, serialVersion);
        }
        catch (IOException e) {
            throw new FaultException(e, false);
        }
    }

    public String toString() {
        return this.masterSync.toString() + "," + this.replicaSync.toString() + "," + this.replicaAck.toString();
    }

    public SyncPolicy getMasterSync() {
        return this.masterSync;
    }

    public SyncPolicy getReplicaSync() {
        return this.replicaSync;
    }

    public ReplicaAckPolicy getReplicaAck() {
        return this.replicaAck;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.masterSync == null ? 0 : this.masterSync.hashCode());
        result = 31 * result + (this.replicaAck == null ? 0 : this.replicaAck.hashCode());
        result = 31 * result + (this.replicaSync == null ? 0 : this.replicaSync.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Durability)) {
            return false;
        }
        Durability other = (Durability)obj;
        if (this.masterSync == null ? other.masterSync != null : !this.masterSync.equals((Object)other.masterSync)) {
            return false;
        }
        if (this.replicaAck == null ? other.replicaAck != null : !this.replicaAck.equals((Object)other.replicaAck)) {
            return false;
        }
        return !(this.replicaSync == null ? other.replicaSync != null : !this.replicaSync.equals((Object)other.replicaSync));
    }

    static {
        EnumSet<Enum> set = EnumSet.allOf(SyncPolicy.class);
        SYNC_POLICIES_BY_ORDINAL = new SyncPolicy[set.size()];
        for (Enum op : set) {
            Durability.SYNC_POLICIES_BY_ORDINAL[op.ordinal()] = op;
        }
        set = EnumSet.allOf(ReplicaAckPolicy.class);
        REPLICA_ACK_POLICIES_BY_ORDINAL = new ReplicaAckPolicy[set.size()];
        Iterator i$ = set.iterator();
        while (i$.hasNext()) {
            Enum op;
            Durability.REPLICA_ACK_POLICIES_BY_ORDINAL[op.ordinal()] = op = (ReplicaAckPolicy)((Object)i$.next());
        }
    }

    public static enum ReplicaAckPolicy {
        ALL,
        NONE,
        SIMPLE_MAJORITY;

    }

    public static enum SyncPolicy {
        SYNC,
        NO_SYNC,
        WRITE_NO_SYNC;

    }
}

