/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.util.EnumSet;
import java.util.Iterator;
import oracle.kv.ValueVersion;

public class ReturnValueVersion
extends ValueVersion {
    private static final Choice[] CHOICES_BY_ORDINAL;
    private final Choice returnChoice;

    public static Choice getChoice(int ordinal) {
        if (ordinal < 0 || ordinal >= CHOICES_BY_ORDINAL.length) {
            throw new RuntimeException("unknown Choice: " + ordinal);
        }
        return CHOICES_BY_ORDINAL[ordinal];
    }

    public ReturnValueVersion(Choice returnChoice) {
        this.returnChoice = returnChoice;
    }

    public Choice getReturnChoice() {
        return this.returnChoice;
    }

    static {
        EnumSet<Choice> set = EnumSet.allOf(Choice.class);
        CHOICES_BY_ORDINAL = new Choice[set.size()];
        Iterator i$ = set.iterator();
        while (i$.hasNext()) {
            Choice op;
            ReturnValueVersion.CHOICES_BY_ORDINAL[op.ordinal()] = op = (Choice)((Object)i$.next());
        }
    }

    public static enum Choice {
        VALUE(true, false),
        VERSION(false, true),
        ALL(true, true),
        NONE(false, false);

        private boolean needValue;
        private boolean needVersion;

        private Choice(boolean needValue, boolean needVersion) {
            this.needValue = needValue;
            this.needVersion = needVersion;
        }

        public boolean needValue() {
            return this.needValue;
        }

        public boolean needVersion() {
            return this.needVersion;
        }

        public boolean needValueOrVersion() {
            return this.needValue || this.needVersion;
        }
    }
}

