/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop;

import java.io.IOException;
import java.util.Iterator;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.KeyValueVersion;
import oracle.kv.hadoop.KVInputSplit;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.security.util.KVStoreLogin;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class KVRecordReaderBase<K, V>
extends RecordReader<K, V> {
    protected KVStore kvstore;
    protected Iterator<KeyValueVersion> iter;
    protected KeyValueVersion current;
    protected long cnt = 0L;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (this.kvstore != null) {
            this.close();
        }
        KVInputSplit kvInputSplit = (KVInputSplit)split;
        String kvStoreName = kvInputSplit.getKVStoreName();
        String[] kvHelperHosts = kvInputSplit.getKVHelperHosts();
        String kvStoreSecurityFile = kvInputSplit.getKVStoreSecurityFile();
        KVStoreConfig storeConfig = new KVStoreConfig(kvStoreName, kvHelperHosts);
        storeConfig.setSecurityProperties(KVStoreLogin.createSecurityProperties(kvStoreSecurityFile));
        this.kvstore = KVStoreFactory.getStore(storeConfig);
        KVStoreImpl kvstoreImpl = (KVStoreImpl)this.kvstore;
        int singlePartId = kvInputSplit.getKVPart();
        this.iter = kvstoreImpl.partitionIterator(kvInputSplit.getDirection(), kvInputSplit.getBatchSize(), singlePartId, kvInputSplit.getParentKey(), kvInputSplit.getSubRange(), kvInputSplit.getDepth(), kvInputSplit.getConsistency(), kvInputSplit.getTimeout(), kvInputSplit.getTimeoutUnit());
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        try {
            boolean ret = this.iter.hasNext();
            this.current = ret ? this.iter.next() : null;
            return ret;
        }
        catch (Exception E) {
            System.out.println("KVRecordReaderBase " + (Object)((Object)this) + " caught: " + E);
            E.printStackTrace();
            return false;
        }
    }

    public float getProgress() throws IOException, InterruptedException {
        return 0.0f;
    }

    public void close() throws IOException {
        this.kvstore.close();
    }
}

