/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.avro;

import java.util.Collections;
import java.util.Map;
import oracle.kv.Consistency;
import oracle.kv.avro.AvroCatalog;
import oracle.kv.avro.GenericAvroBinding;
import oracle.kv.avro.JsonAvroBinding;
import oracle.kv.avro.RawAvroBinding;
import oracle.kv.avro.SchemaNotAllowedException;
import oracle.kv.avro.SpecificAvroBinding;
import oracle.kv.avro.UndefinedSchemaException;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.avro.CBindingBridge;
import oracle.kv.impl.api.avro.GenericBinding;
import oracle.kv.impl.api.avro.JsonBinding;
import oracle.kv.impl.api.avro.RawBinding;
import oracle.kv.impl.api.avro.SchemaAccessor;
import oracle.kv.impl.api.avro.SchemaCache;
import oracle.kv.impl.api.avro.SpecificBinding;
import oracle.kv.impl.test.TestHook;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;

public class AvroCatalogImpl
implements AvroCatalog {
    private final SchemaCache schemaCache;
    private final RawAvroBinding rawBinding;
    private final Consistency defaultConsistency;

    public AvroCatalogImpl(KVStoreImpl store) {
        this.schemaCache = new SchemaCache(new SchemaAccessor(store));
        this.rawBinding = new RawBinding(this.schemaCache);
        this.defaultConsistency = store.getDefaultConsistency();
    }

    public int getSchemaCacheByIdSize() {
        return this.schemaCache.getByIdSize();
    }

    public int getSchemaCacheByNameSize() {
        return this.schemaCache.getByNameSize();
    }

    public int getSchemaCacheByValueSize() {
        return this.schemaCache.getByValueSize();
    }

    public int getSchemaCacheByCSchemaSize() {
        return this.schemaCache.getByCSchemaSize();
    }

    public void setCacheMissHook(TestHook<Void> hook) {
        this.schemaCache.setCacheMissHook(hook);
    }

    @Override
    public <T extends SpecificRecord> SpecificAvroBinding<T> getSpecificBinding(Class<T> cls) {
        return new SpecificBinding<T>(this, cls);
    }

    @Override
    public SpecificAvroBinding<SpecificRecord> getSpecificMultiBinding() {
        return new SpecificBinding<SpecificRecord>(this, null);
    }

    @Override
    public GenericAvroBinding getGenericBinding(Schema schema) {
        return new GenericBinding(this, Collections.singletonMap(schema.getFullName(), schema));
    }

    @Override
    public GenericAvroBinding getGenericMultiBinding(Map<String, Schema> schemas) {
        return new GenericBinding(this, schemas);
    }

    @Override
    public JsonAvroBinding getJsonBinding(Schema schema) {
        return new JsonBinding(this, Collections.singletonMap(schema.getFullName(), schema));
    }

    @Override
    public JsonAvroBinding getJsonMultiBinding(Map<String, Schema> schemas) {
        return new JsonBinding(this, schemas);
    }

    @Override
    public RawAvroBinding getRawBinding() {
        return this.rawBinding;
    }

    @Override
    public Map<String, Schema> getCurrentSchemas() {
        return this.schemaCache.getCurrentSchemas();
    }

    @Override
    public void refreshSchemaCache(Consistency consistency) {
        this.schemaCache.updateStoredSchemas(consistency != null ? consistency : this.defaultConsistency);
    }

    public CBindingBridge getCBindingBridge() {
        return this.schemaCache.getCBindingBridge();
    }

    void checkDefinedSchemas(Map<String, Schema> schemas) throws UndefinedSchemaException {
        for (Schema schema : schemas.values()) {
            if (this.schemaCache.getSchemaInfoByValue(schema) != null) continue;
            throw AvroCatalogImpl.newUndefinedSchemaException(schema);
        }
    }

    static UndefinedSchemaException newUndefinedSchemaException(Schema sch) {
        String name = sch.getFullName();
        return new UndefinedSchemaException("Schema name: " + name + " has not been defined using the" + " administration interface as a top-level schema; note that" + " new and modified schemas must be added or changed using the" + " administration interface, before being used by clients.", name);
    }

    static Schema checkToObjectSchema(Schema writerSchema, Map<String, Schema> allowedSchemas) throws SchemaNotAllowedException {
        String name = writerSchema.getFullName();
        Schema schema = allowedSchemas.get(name);
        if (schema == null) {
            throw new SchemaNotAllowedException("The writer schema associated with the value param is not one of the schemas allowed by the binding: " + name, name);
        }
        return schema;
    }

    static void checkToValueSchema(Schema writerSchema, Map<String, Schema> allowedSchemas) throws SchemaNotAllowedException {
        String name = writerSchema.getFullName();
        Schema schema = allowedSchemas.get(name);
        if (schema == null || schema != writerSchema) {
            throw new SchemaNotAllowedException("The writer schema associated with the object param is not one of the schemas allowed by the binding: " + name, name);
        }
    }
}

