/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import oracle.kv.Value;
import oracle.kv.avro.GenericAvroBinding;
import oracle.kv.avro.RawAvroBinding;
import oracle.kv.avro.RawRecord;
import oracle.kv.avro.SchemaNotAllowedException;
import oracle.kv.avro.UndefinedSchemaException;
import oracle.kv.impl.api.avro.AvroCatalogImpl;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;

class GenericBinding
implements GenericAvroBinding {
    private final RawAvroBinding rawBinding;
    private final Map<String, Schema> allowedSchemas;

    GenericBinding(AvroCatalogImpl catalog, Map<String, Schema> allowedSchemas) throws UndefinedSchemaException {
        this.rawBinding = catalog.getRawBinding();
        this.allowedSchemas = new HashMap<String, Schema>(allowedSchemas);
        catalog.checkDefinedSchemas(allowedSchemas);
    }

    @Override
    public GenericRecord toObject(Value value) throws SchemaNotAllowedException, IllegalArgumentException {
        RawRecord raw = this.rawBinding.toObject(value);
        Schema writerSchema = raw.getSchema();
        Schema readerSchema = AvroCatalogImpl.checkToObjectSchema(writerSchema, this.allowedSchemas);
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(raw.getRawData(), null);
        try {
            return (GenericRecord)reader.read(null, (Decoder)decoder);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to deserialize GenericRecord", e);
        }
    }

    @Override
    public Value toValue(GenericRecord object) throws SchemaNotAllowedException, UndefinedSchemaException, IllegalArgumentException {
        Schema writerSchema = object.getSchema();
        AvroCatalogImpl.checkToValueSchema(writerSchema, this.allowedSchemas);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GenericWriter writer = new GenericWriter(writerSchema);
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
        try {
            writer.write(object, (Encoder)encoder);
            encoder.flush();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to serialize GenericRecord", e);
        }
        RawRecord raw = new RawRecord(out.toByteArray(), writerSchema);
        return this.rawBinding.toValue(raw);
    }

    static void writeInt(Object datum, Encoder out) throws IOException, AvroRuntimeException {
        out.writeInt(((Integer)datum).intValue());
    }

    static void writeFixed(Schema schema, byte[] bytes, Encoder out) throws IOException, AvroRuntimeException {
        int sizeInSchema = schema.getFixedSize();
        if (sizeInSchema != bytes.length) {
            throw new AvroRuntimeException("Schema for 'fixed' type: " + schema.getName() + " has length: " + sizeInSchema + " but byte array has length: " + bytes.length);
        }
        out.writeFixed(bytes, 0, sizeInSchema);
    }

    static class GenericWriter
    extends GenericDatumWriter<GenericRecord> {
        GenericWriter(Schema writerSchema) {
            super(writerSchema);
        }

        protected void writeFixed(Schema schema, Object datum, Encoder out) throws IOException {
            byte[] bytes = ((GenericFixed)datum).bytes();
            GenericBinding.writeFixed(schema, bytes, out);
        }

        protected void write(Schema schema, Object datum, Encoder out) throws IOException {
            switch (schema.getType()) {
                case INT: {
                    GenericBinding.writeInt(datum, out);
                    break;
                }
                default: {
                    super.write(schema, datum, out);
                }
            }
        }
    }
}

