/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.rep.migration.MigrationStreamHandle;
import oracle.kv.impl.topo.PartitionId;

public class MultiDeleteTable
extends MultiTableOperation {
    private final byte[] resumeKey;
    private final boolean majorPathComplete;
    private final int batchSize;
    private byte[] lastDeleted;

    public MultiDeleteTable(byte[] parentKey, TargetTables targetTables, KeyRange subRange) {
        super(InternalOperation.OpCode.MULTI_DELETE_TABLE, parentKey, targetTables, subRange);
        this.majorPathComplete = true;
        this.batchSize = 0;
        this.resumeKey = null;
    }

    MultiDeleteTable(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.MULTI_DELETE_TABLE, in, serialVersion);
        this.majorPathComplete = true;
        this.batchSize = 0;
        this.resumeKey = null;
    }

    public MultiDeleteTable(byte[] parentKey, long targetTableId, boolean majorPathComplete, int batchSize, byte[] resumeKey) {
        super(InternalOperation.OpCode.MULTI_DELETE_TABLE, parentKey, new TargetTables(targetTableId), null);
        this.majorPathComplete = majorPathComplete;
        this.batchSize = batchSize;
        this.resumeKey = resumeKey;
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, final OperationHandler operationHandler) {
        this.verifyTableAccess();
        final int[] nDeletions = new int[1];
        boolean moreElements = this.iterateTable(operationHandler, txn, partitionId, this.majorPathComplete, Direction.FORWARD, this.batchSize, this.resumeKey, CursorConfig.READ_COMMITTED, new OperationHandler.ScanVisitor(){

            @Override
            public int visit(Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
                int match = MultiDeleteTable.this.keyInTargetTable(operationHandler, keyEntry, dataEntry, cursor);
                if (match > 0) {
                    MultiDeleteTable.access$002(MultiDeleteTable.this, keyEntry.getData());
                    if (cursor.delete() == OperationStatus.SUCCESS) {
                        int num = 1;
                        if (MultiDeleteTable.this.isClientOperation()) {
                            MigrationStreamHandle.get().addDelete(keyEntry);
                            num += MultiDeleteTable.this.deleteAncestorKeys(cursor, keyEntry);
                        }
                        nDeletions[0] = nDeletions[0] + num;
                    }
                }
                return match;
            }
        });
        assert (!moreElements || this.batchSize > 0);
        return new Result.MultiDeleteResult(this.getOpCode(), nDeletions[0]);
    }

    public byte[] getLastDeleted() {
        return this.lastDeleted;
    }

    private boolean isClientOperation() {
        return this.batchSize == 0;
    }

    static /* synthetic */ byte[] access$002(MultiDeleteTable x0, byte[] x1) {
        x0.lastDeleted = x1;
        return x1;
    }
}

