/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.topo.PartitionId;

public class MultiGetTable
extends MultiTableOperation {
    public MultiGetTable(byte[] parentKey, TargetTables targetTables, KeyRange subRange) {
        super(InternalOperation.OpCode.MULTI_GET_TABLE, parentKey, targetTables, subRange);
    }

    MultiGetTable(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.MULTI_GET_TABLE, in, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, final OperationHandler operationHandler) {
        this.verifyTableAccess();
        final ArrayList<ResultKeyValueVersion> results = new ArrayList<ResultKeyValueVersion>();
        boolean moreElements = this.iterateTable(operationHandler, txn, partitionId, true, Direction.FORWARD, 0, null, CursorConfig.READ_COMMITTED, new OperationHandler.ScanVisitor(){

            @Override
            public int visit(Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
                DatabaseEntry dentry;
                int match = MultiGetTable.this.keyInTargetTable(operationHandler, keyEntry, dataEntry, cursor);
                if (match > 0 && cursor.getCurrent(keyEntry, dentry = new DatabaseEntry(), LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    if (!MultiGetTable.this.isTableData(dentry.getData(), null)) {
                        return 0;
                    }
                    match += MultiGetTable.this.addAncestorValues(cursor, results, keyEntry);
                    MultiTableOperation.addValueResult(operationHandler, results, cursor, keyEntry, dentry);
                }
                return match;
            }
        });
        assert (!moreElements);
        return new Result.IterateResult(this.getOpCode(), results, moreElements);
    }
}

