/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;
import oracle.kv.Direction;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiTableOperation;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.topo.PartitionId;

public class MultiGetTableKeys
extends MultiTableOperation {
    public MultiGetTableKeys(byte[] parentKey, TargetTables targetTables, KeyRange subRange) {
        super(InternalOperation.OpCode.MULTI_GET_TABLE_KEYS, parentKey, targetTables, subRange);
    }

    MultiGetTableKeys(ObjectInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.MULTI_GET_TABLE_KEYS, in, serialVersion);
    }

    @Override
    public Result execute(Transaction txn, PartitionId partitionId, final OperationHandler operationHandler) {
        this.verifyTableAccess();
        final ArrayList<byte[]> results = new ArrayList<byte[]>();
        boolean moreElements = this.iterateTable(operationHandler, txn, partitionId, true, Direction.FORWARD, 0, null, CursorConfig.READ_COMMITTED, new OperationHandler.ScanVisitor(){

            @Override
            public int visit(Cursor cursor, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
                int match = MultiGetTableKeys.this.keyInTargetTable(operationHandler, keyEntry, dataEntry, cursor);
                if (match > 0 && cursor.getCurrent(keyEntry, dataEntry, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    match += MultiGetTableKeys.this.addAncestorKeys(cursor, results, keyEntry);
                    MultiTableOperation.addKeyResult(results, keyEntry.getData());
                }
                return match;
            }
        });
        assert (!moreElements);
        return new Result.KeysIterateResult(this.getOpCode(), results, moreElements);
    }
}

