/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.util.UserDataControl;

public abstract class SingleKeyOperation
extends InternalOperation {
    private final byte[] keyBytes;

    public SingleKeyOperation(InternalOperation.OpCode opCode, byte[] keyBytes) {
        super(opCode);
        this.keyBytes = keyBytes;
    }

    SingleKeyOperation(InternalOperation.OpCode opCode, ObjectInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        short keyLen = in.readShort();
        this.keyBytes = new byte[keyLen];
        in.readFully(this.keyBytes);
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.keyBytes.length);
        out.write(this.keyBytes);
    }

    void checkPermission() {
        if (this.isPrivateAccess(this.keyBytes) && !this.isInternalRequestor()) {
            throw new UnauthorizedException("Illegal access to internal keyspace");
        }
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    @Override
    public String toString() {
        return super.toString() + " Key: " + UserDataControl.displayKey(this.keyBytes);
    }
}

