/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import oracle.kv.impl.api.table.BinaryValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.table.BinaryDef;
import oracle.kv.table.FieldDef;
import org.codehaus.jackson.JsonNode;

@Persistent(version=1)
class BinaryDefImpl
extends FieldDefImpl
implements BinaryDef {
    private static final long serialVersionUID = 1L;

    BinaryDefImpl(String description) {
        super(FieldDef.Type.BINARY);
    }

    BinaryDefImpl() {
        super(FieldDef.Type.BINARY);
    }

    private BinaryDefImpl(BinaryDefImpl impl) {
        super(impl);
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public BinaryDef asBinary() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof BinaryDefImpl;
    }

    @Override
    public BinaryDefImpl clone() {
        return new BinaryDefImpl(this);
    }

    @Override
    public BinaryValueImpl createBinary(byte[] value) {
        return new BinaryValueImpl(value);
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isBinary()) {
            throw new IllegalArgumentException("Default value for type BINARY is not binary");
        }
        try {
            return this.createBinary(node.getBinaryValue());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("IOException creating binary value: " + ioe, ioe);
        }
    }
}

