/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.DoubleNode;

@Persistent(version=1)
class DoubleValueImpl
extends FieldValueImpl
implements DoubleValue {
    private static final long serialVersionUID = 1L;
    private double value;

    DoubleValueImpl(double value) {
        this.value = value;
    }

    DoubleValueImpl(String keyValue) {
        this.value = SortableString.doubleFromSortable(keyValue);
    }

    private DoubleValueImpl() {
    }

    @Override
    public double get() {
        return this.value;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.DOUBLE;
    }

    @Override
    public DoubleValueImpl clone() {
        return new DoubleValueImpl(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof DoubleValueImpl) {
            return Double.compare(this.value, ((DoubleValueImpl)other).get()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof DoubleValueImpl) {
            return Double.compare(this.value, ((DoubleValueImpl)other).value);
        }
        throw new ClassCastException("Object is not an DoubleValue");
    }

    @Override
    public String formatForKey(FieldDef field) {
        return SortableString.toSortable(this.value);
    }

    @Override
    public FieldValueImpl getNextValue() {
        if (this.value == Double.MAX_VALUE) {
            return null;
        }
        return new DoubleValueImpl(Math.nextAfter(this.value, Double.MAX_VALUE));
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        return new DoubleValueImpl(Double.MIN_VALUE);
    }

    @Override
    public JsonNode toJsonNode() {
        return new DoubleNode(this.value);
    }

    @Override
    public DoubleValue asDouble() {
        return this;
    }

    @Override
    public boolean isDouble() {
        return true;
    }
}

