/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.EnumDef;
import oracle.kv.table.EnumValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.TextNode;

@Persistent(version=1)
class EnumValueImpl
extends FieldValueImpl
implements EnumValue {
    private static final long serialVersionUID = 1L;
    private final EnumDefImpl field;
    private final String value;

    EnumValueImpl(EnumDef field, String value) {
        this.field = (EnumDefImpl)field;
        this.value = value;
        this.validate();
    }

    private EnumValueImpl() {
        this.field = null;
        this.value = null;
    }

    @Override
    public EnumDef getDefinition() {
        return this.field;
    }

    @Override
    public String get() {
        return this.value;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.ENUM;
    }

    @Override
    public EnumValueImpl clone() {
        return new EnumValueImpl(this.field, this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof EnumValueImpl) {
            EnumDefImpl def = this.field;
            EnumValueImpl otherVal = (EnumValueImpl)other;
            EnumDefImpl otherDef = (EnumDefImpl)otherVal.getDefinition();
            return def.valuesEqual(otherDef) && this.value.equals(otherVal.get());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof EnumValueImpl) {
            int thisIndex = this.indexOf(this.value);
            int otherIndex = this.indexOf(((EnumValueImpl)other).value);
            return Integer.valueOf(thisIndex).compareTo(otherIndex);
        }
        throw new ClassCastException("Object is not an IntegerValue");
    }

    @Override
    public EnumValue asEnum() {
        return this;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public String formatForKey(FieldDef field1) {
        return SortableString.toSortable(this.getIndex(), this.field.getEncodingLen());
    }

    @Override
    public EnumValueImpl getNextValue() {
        EnumDefImpl def = this.field;
        int index = this.getIndex();
        if (def.isValidIndex(index + 1)) {
            return def.createEnum(index + 1);
        }
        return null;
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        return this.field.createEnum(0);
    }

    @Override
    public JsonNode toJsonNode() {
        return new TextNode(this.value);
    }

    @Override
    public int getIndex() {
        return this.field.indexOf(this.value);
    }

    @Override
    Object toAvroValue(Schema schema) {
        Schema toUse = EnumValueImpl.getUnionSchema(schema, Schema.Type.ENUM);
        return new GenericData.EnumSymbol(toUse, this.get());
    }

    int indexOf(String enumValue) {
        return this.field.indexOf(enumValue);
    }

    static EnumValueImpl createFromKey(EnumDef field, String indexString) {
        EnumDefImpl def = (EnumDefImpl)field;
        int index = SortableString.intFromSortable(indexString);
        return def.createEnum(index);
    }

    private void validate() {
        if (this.field != null && this.value != null) {
            this.field.validateValue(this.value);
            return;
        }
        throw new IllegalArgumentException("Value not valid for enumeration: " + this.value);
    }
}

