/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.table.ArrayDef;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.BinaryDef;
import oracle.kv.table.BinaryValue;
import oracle.kv.table.BooleanDef;
import oracle.kv.table.BooleanValue;
import oracle.kv.table.DoubleDef;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.EnumDef;
import oracle.kv.table.EnumValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FixedBinaryDef;
import oracle.kv.table.FixedBinaryValue;
import oracle.kv.table.FloatDef;
import oracle.kv.table.FloatValue;
import oracle.kv.table.IntegerDef;
import oracle.kv.table.IntegerValue;
import oracle.kv.table.LongDef;
import oracle.kv.table.LongValue;
import oracle.kv.table.MapDef;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import oracle.kv.table.StringDef;
import oracle.kv.table.StringValue;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;

@Persistent(version=1)
abstract class FieldDefImpl
implements FieldDef,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final FieldDef.Type type;
    private final String description;

    FieldDefImpl(FieldDef.Type type) {
        this(type, null);
    }

    FieldDefImpl(FieldDef.Type type, String description) {
        this.type = type;
        this.description = description;
    }

    FieldDefImpl(FieldDefImpl impl) {
        this.type = impl.type;
        this.description = impl.description;
    }

    FieldDefImpl() {
        this.type = null;
        this.description = null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FieldDef.Type getType() {
        return this.type;
    }

    @Override
    public boolean isType(FieldDef.Type type1) {
        return this.type == type1;
    }

    @Override
    public boolean isValidKeyField() {
        return false;
    }

    @Override
    public boolean isValidIndexField() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isFixedBinary() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isRecord() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public BinaryDef asBinary() {
        throw new ClassCastException("Field is not a Binary: " + this.getClass());
    }

    @Override
    public FixedBinaryDef asFixedBinary() {
        throw new ClassCastException("Field is not a FixedBinary: " + this.getClass());
    }

    @Override
    public BooleanDef asBoolean() {
        throw new ClassCastException("Field is not a Boolean: " + this.getClass());
    }

    @Override
    public DoubleDef asDouble() {
        throw new ClassCastException("Field is not a Double: " + this.getClass());
    }

    @Override
    public FloatDef asFloat() {
        throw new ClassCastException("Field is not a Float: " + this.getClass());
    }

    @Override
    public IntegerDef asInteger() {
        throw new ClassCastException("Field is not an Integer: " + this.getClass());
    }

    @Override
    public LongDef asLong() {
        throw new ClassCastException("Field is not a Long: " + this.getClass());
    }

    @Override
    public StringDef asString() {
        throw new ClassCastException("Field is not a String: " + this.getClass());
    }

    @Override
    public EnumDef asEnum() {
        throw new ClassCastException("Field is not an Enum: " + this.getClass());
    }

    @Override
    public ArrayDef asArray() {
        throw new ClassCastException("Field is not an Array: " + this.getClass());
    }

    @Override
    public MapDef asMap() {
        throw new ClassCastException("Field is not a Map: " + this.getClass());
    }

    @Override
    public RecordDef asRecord() {
        throw new ClassCastException("Field is not a Record: " + this.getClass());
    }

    @Override
    public FieldDefImpl clone() {
        try {
            return (FieldDefImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public ArrayValue createArray() {
        throw new ClassCastException("Field is not an Array: " + this.getClass());
    }

    @Override
    public BinaryValue createBinary(byte[] value) {
        throw new ClassCastException("Field is not a Binary: " + this.getClass());
    }

    @Override
    public FixedBinaryValue createFixedBinary(byte[] value) {
        throw new ClassCastException("Field is not a FixedBinary: " + this.getClass());
    }

    @Override
    public BooleanValue createBoolean(boolean value) {
        throw new ClassCastException("Field is not a Boolean: " + this.getClass());
    }

    @Override
    public DoubleValue createDouble(double value) {
        throw new ClassCastException("Field is not a Double: " + this.getClass());
    }

    @Override
    public FloatValue createFloat(float value) {
        throw new ClassCastException("Field is not a Float: " + this.getClass());
    }

    @Override
    public EnumValue createEnum(String value) {
        throw new ClassCastException("Field is not an Enum: " + this.getClass());
    }

    @Override
    public IntegerValue createInteger(int value) {
        throw new ClassCastException("Field is not an Integer: " + this.getClass());
    }

    @Override
    public LongValue createLong(long value) {
        throw new ClassCastException("Field is not a Long: " + this.getClass());
    }

    @Override
    public MapValue createMap() {
        throw new ClassCastException("Field is not a Map: " + this.getClass());
    }

    @Override
    public RecordValue createRecord() {
        throw new ClassCastException("Field is not a Record: " + this.getClass());
    }

    @Override
    public StringValue createString(String value) {
        throw new ClassCastException("Field is not a String: " + this.getClass());
    }

    FieldValueImpl createValue(JsonNode node) {
        return null;
    }

    public boolean equals(Object other) {
        throw new IllegalStateException("Classes that implement FieldDefImpl must override equals");
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    void toJson(ObjectNode node) {
        if (this.description != null) {
            node.put("description", this.description);
        }
        node.put("type", this.getType().toString());
    }

    int getEncodingLength() {
        return -1;
    }

    JsonNode mapTypeToAvro(ObjectNode node) {
        throw new IllegalArgumentException("Type must override mapTypeToAvro: " + (Object)((Object)this.getType()));
    }

    final JsonNode mapTypeToAvroJsonNode() {
        String textValue = null;
        switch (this.type) {
            case INTEGER: {
                textValue = "int";
                break;
            }
            case LONG: {
                textValue = "long";
                break;
            }
            case STRING: {
                textValue = "string";
                break;
            }
            case BOOLEAN: {
                textValue = "boolean";
                break;
            }
            case FLOAT: {
                textValue = "float";
                break;
            }
            case DOUBLE: {
                textValue = "double";
                break;
            }
            case BINARY: {
                textValue = "bytes";
                break;
            }
            case FIXED_BINARY: 
            case ENUM: 
            case MAP: 
            case RECORD: 
            case ARRAY: {
                return this.mapTypeToAvro(null);
            }
            default: {
                throw new IllegalStateException("Unknown type in mapTypeToAvroJsonNode: " + (Object)((Object)this.type));
            }
        }
        return new TextNode(textValue);
    }

    boolean compare(Object o, Object other) {
        if (o != null) {
            return o.equals(other);
        }
        return other == null;
    }
}

