/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.JsonUtils;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.BinaryValue;
import oracle.kv.table.BooleanValue;
import oracle.kv.table.DoubleValue;
import oracle.kv.table.EnumValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FixedBinaryValue;
import oracle.kv.table.FloatValue;
import oracle.kv.table.IndexKey;
import oracle.kv.table.IntegerValue;
import oracle.kv.table.LongValue;
import oracle.kv.table.MapValue;
import oracle.kv.table.PrimaryKey;
import oracle.kv.table.RecordValue;
import oracle.kv.table.Row;
import oracle.kv.table.StringValue;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectWriter;

@Persistent(version=1)
abstract class FieldValueImpl
implements FieldValue,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;

    FieldValueImpl() {
    }

    public abstract JsonNode toJsonNode();

    @Override
    public BinaryValue asBinary() {
        throw new ClassCastException("Field is not a Binary: " + this.getClass());
    }

    @Override
    public BooleanValue asBoolean() {
        throw new ClassCastException("Field is not a Boolean: " + this.getClass());
    }

    @Override
    public DoubleValue asDouble() {
        throw new ClassCastException("Field is not a Double: " + this.getClass());
    }

    @Override
    public FloatValue asFloat() {
        throw new ClassCastException("Field is not a Float: " + this.getClass());
    }

    @Override
    public IntegerValue asInteger() {
        throw new ClassCastException("Field is not an Integer: " + this.getClass());
    }

    @Override
    public LongValue asLong() {
        throw new ClassCastException("Field is not a Long: " + this.getClass());
    }

    @Override
    public StringValue asString() {
        throw new ClassCastException("Field is not a String: " + this.getClass());
    }

    @Override
    public EnumValue asEnum() {
        throw new ClassCastException("Field is not an Enum: " + this.getClass());
    }

    @Override
    public FixedBinaryValue asFixedBinary() {
        throw new ClassCastException("Field is not a FixedBinary: " + this.getClass());
    }

    @Override
    public ArrayValue asArray() {
        throw new ClassCastException("Field is not an Array: " + this.getClass());
    }

    @Override
    public MapValue asMap() {
        throw new ClassCastException("Field is not a Map: " + this.getClass());
    }

    @Override
    public RecordValue asRecord() {
        throw new ClassCastException("Field is not a Record: " + this.getClass());
    }

    @Override
    public Row asRow() {
        throw new ClassCastException("Field is not a Row: " + this.getClass());
    }

    @Override
    public PrimaryKey asPrimaryKey() {
        throw new ClassCastException("Field is not a PrimaryKey: " + this.getClass());
    }

    @Override
    public IndexKey asIndexKey() {
        throw new ClassCastException("Field is not an IndexKey: " + this.getClass());
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isFixedBinary() {
        return false;
    }

    @Override
    public boolean isLong() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isRecord() {
        return false;
    }

    @Override
    public boolean isRow() {
        return false;
    }

    @Override
    public boolean isPrimaryKey() {
        return false;
    }

    @Override
    public boolean isIndexKey() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public FieldValueImpl clone() {
        try {
            return (FieldValueImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public int compareTo(FieldValue o) {
        throw new IllegalArgumentException("FieldValueImpl objects must implement compareTo");
    }

    Object toAvroValue(Schema schema) {
        switch (this.getType()) {
            case INTEGER: {
                return this.asInteger().get();
            }
            case LONG: {
                return this.asLong().get();
            }
            case DOUBLE: {
                return this.asDouble().get();
            }
            case FLOAT: {
                return Float.valueOf(this.asFloat().get());
            }
            case STRING: {
                return this.asString().get();
            }
            case BINARY: {
                return ByteBuffer.wrap(this.asBinary().get());
            }
            case BOOLEAN: {
                return this.asBoolean().get();
            }
            case FIXED_BINARY: 
            case ENUM: 
            case RECORD: 
            case ARRAY: 
            case MAP: {
                throw new IllegalArgumentException("Complex classes must override toAvroValue");
            }
        }
        throw new IllegalStateException("Unknown type in toAvroValue " + (Object)((Object)this.getType()));
    }

    static FieldValue fromAvroValue(FieldDef def, Object o, Schema schema) {
        switch (def.getType()) {
            case INTEGER: {
                return def.createInteger((Integer)o);
            }
            case LONG: {
                return def.createLong((Long)o);
            }
            case DOUBLE: {
                return def.createDouble((Double)o);
            }
            case FLOAT: {
                return def.createFloat(((Float)o).floatValue());
            }
            case STRING: {
                return def.createString(((CharSequence)o).toString());
            }
            case BINARY: {
                return def.createBinary(((ByteBuffer)o).array());
            }
            case FIXED_BINARY: {
                return def.createFixedBinary(((GenericData.Fixed)o).bytes());
            }
            case BOOLEAN: {
                return def.createBoolean((Boolean)o);
            }
            case ENUM: {
                return def.createEnum(((GenericData.EnumSymbol)o).toString());
            }
            case RECORD: {
                return RecordValueImpl.fromAvroValue(def, o, schema);
            }
            case ARRAY: {
                return ArrayValueImpl.fromAvroValue(def, o, schema);
            }
            case MAP: {
                return MapValueImpl.fromAvroValue(def, o, schema);
            }
        }
        throw new IllegalArgumentException("Complex classes must override toAvroValue");
    }

    @Override
    public String toJsonString(boolean pretty) {
        ObjectWriter writer = JsonUtils.createWriter(pretty);
        try {
            return writer.writeValueAsString((Object)this.toJsonNode());
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
    }

    public String formatForKey(FieldDef field) {
        throw new IllegalArgumentException("Key components must be atomic types");
    }

    public FieldValueImpl getNextValue() {
        throw new IllegalArgumentException("Type does not implement getNextValue: " + this.getClass().getName());
    }

    public FieldValueImpl getMinimumValue() {
        throw new IllegalArgumentException("Type does not implement getMinimumValue: " + this.getClass().getName());
    }

    static Schema getUnionSchema(Schema schema, Schema.Type type) {
        if (schema.getType() == Schema.Type.UNION) {
            for (Schema s : schema.getTypes()) {
                if (s.getType() != type) continue;
                return s;
            }
            throw new IllegalArgumentException("Cannot find type in union schema: " + type);
        }
        return schema;
    }
}

