/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FloatValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FloatDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
class FloatDefImpl
extends FieldDefImpl
implements FloatDef {
    private static final long serialVersionUID = 1L;
    private final Float min;
    private final Float max;

    FloatDefImpl(String description, Float min, Float max) {
        super(FieldDef.Type.FLOAT, description);
        this.min = min;
        this.max = max;
        this.validate();
    }

    FloatDefImpl() {
        super(FieldDef.Type.FLOAT);
        this.min = null;
        this.max = null;
    }

    private FloatDefImpl(FloatDefImpl impl) {
        super(impl);
        this.min = impl.min;
        this.max = impl.max;
    }

    @Override
    public Float getMin() {
        return this.min;
    }

    @Override
    public Float getMax() {
        return this.max;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public FloatDef asFloat() {
        return this;
    }

    @Override
    public boolean isValidKeyField() {
        return true;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof FloatDefImpl) {
            FloatDefImpl otherDef = (FloatDefImpl)other;
            return this.compare(this.getMin(), otherDef.getMin()) && this.compare(this.getMax(), otherDef.getMax());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.min != null ? this.min.hashCode() : 0) + (this.max != null ? this.max.hashCode() : 0);
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        if (this.min != null) {
            node.put("min", this.min);
        }
        if (this.max != null) {
            node.put("max", this.max);
        }
    }

    @Override
    public FloatDefImpl clone() {
        return new FloatDefImpl(this);
    }

    @Override
    public FloatValueImpl createFloat(float value) {
        this.validateRange(value);
        return new FloatValueImpl(value);
    }

    private void validate() {
        if (this.min != null && this.max != null && this.min.floatValue() > this.max.floatValue()) {
            throw new IllegalArgumentException("Invalid min or max value");
        }
    }

    private void validateRange(float val) {
        if (this.min != null && val < this.min.floatValue() || this.max != null && val > this.max.floatValue()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Value, ");
            sb.append(val);
            sb.append(", is outside of the allowed range");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isNumber()) {
            throw new IllegalArgumentException("Default value for type FLOAT is not a number");
        }
        return this.createFloat(Float.valueOf(node.getValueAsText()).floatValue());
    }
}

