/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FloatValue;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.node.ValueNode;

@Persistent(version=1)
class FloatValueImpl
extends FieldValueImpl
implements FloatValue {
    private static final long serialVersionUID = 1L;
    private float value;

    FloatValueImpl(float value) {
        this.value = value;
    }

    FloatValueImpl(String keyValue) {
        this.value = SortableString.floatFromSortable(keyValue);
    }

    private FloatValueImpl() {
    }

    @Override
    public float get() {
        return this.value;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.FLOAT;
    }

    @Override
    public FloatValueImpl clone() {
        return new FloatValueImpl(this.value);
    }

    public boolean equals(Object other) {
        if (other instanceof FloatValueImpl) {
            return Float.compare(this.value, ((FloatValueImpl)other).get()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Float.valueOf(this.value).hashCode();
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof FloatValueImpl) {
            return Float.compare(this.value, ((FloatValueImpl)other).value);
        }
        throw new ClassCastException("Object is not an FloatValue");
    }

    @Override
    public String formatForKey(FieldDef field) {
        return SortableString.toSortable(this.value);
    }

    @Override
    public FieldValueImpl getNextValue() {
        if (this.value == Float.MAX_VALUE) {
            return null;
        }
        return new FloatValueImpl(Math.nextAfter(this.value, 3.4028234663852886E38));
    }

    @Override
    public FieldValueImpl getMinimumValue() {
        return new FloatValueImpl(Float.MIN_VALUE);
    }

    @Override
    public FloatValue asFloat() {
        return this;
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public JsonNode toJsonNode() {
        return new FloatNode(this.value);
    }

    private static final class FloatNode
    extends ValueNode {
        private final float value;

        FloatNode(float value) {
            this.value = value;
        }

        public final void serialize(JsonGenerator jg, SerializerProvider provider) throws IOException, JsonProcessingException {
            jg.writeNumber(this.value);
        }

        public JsonToken asToken() {
            return null;
        }

        public boolean equals(Object o) {
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String getValueAsText() {
            return this.asText();
        }

        public String asText() {
            return Float.valueOf(this.value).toString();
        }
    }
}

