/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.List;
import oracle.kv.impl.api.table.FieldMapEntry;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.RecordDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Index;
import oracle.kv.table.IndexKey;

public class IndexKeyImpl
extends RecordValueImpl
implements IndexKey {
    private static final long serialVersionUID = 1L;
    final IndexImpl index;

    IndexKeyImpl(IndexImpl index) {
        super(new RecordDefImpl(index.getTableImpl().getName(), index.getTableImpl().getFieldMap()));
        this.index = index;
    }

    private IndexKeyImpl(IndexKeyImpl other) {
        super(other);
        this.index = other.index;
    }

    @Override
    public Index getIndex() {
        return this.index;
    }

    @Override
    public IndexKeyImpl clone() {
        return new IndexKeyImpl(this);
    }

    @Override
    FieldDef validateNameAndType(String name, FieldDef.Type type) {
        FieldDef def = super.validateNameAndType(name, type);
        if (!this.index.containsField(name)) {
            throw new IllegalArgumentException("Field is not part of Index: " + name);
        }
        return def;
    }

    @Override
    public IndexKey asIndexKey() {
        return this;
    }

    @Override
    public boolean isIndexKey() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            return other instanceof IndexKeyImpl;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    int getNumFields() {
        return this.index.getFieldsInternal().size();
    }

    @Override
    FieldDef getField(String fieldName) {
        FieldDef def = this.getDefinition().getField(fieldName);
        if (def != null && this.index.containsField(fieldName)) {
            return def;
        }
        return null;
    }

    @Override
    FieldMapEntry getFieldMapEntry(String fieldName) {
        FieldMapEntry fme = this.getDefinition().getFieldMapEntry(fieldName, false);
        if (fme != null && this.index.containsField(fieldName)) {
            return fme;
        }
        return null;
    }

    @Override
    List<String> getFields() {
        return this.index.getFields();
    }

    public int getKeySize() {
        return this.index.serializeIndexKey(this).length;
    }

    TableImpl getTable() {
        return this.index.getTableImpl();
    }

    @Override
    void validate() {
        int numFound = 0;
        int i = 0;
        for (String s : this.index.getFields()) {
            if (this.get(s) != null) {
                if (i != numFound) {
                    throw new IllegalArgumentException("IndexKey is missing fields more significant than field: " + s);
                }
                if (!this.index.containsField(s)) {
                    throw new IllegalArgumentException("Field is not part of Index: " + s);
                }
                ++numFound;
            }
            ++i;
        }
        if (numFound != this.size()) {
            throw new IllegalArgumentException("IndexKey contains a field that is not part of the Index");
        }
    }

    public IndexImpl getIndexImpl() {
        return this.index;
    }

    boolean isComplete() {
        return this.size() == this.getNumFields();
    }

    public boolean incrementIndexKey() {
        List<String> indexFields = this.index.getFieldsInternal();
        FieldValue[] values = new FieldValue[indexFields.size()];
        int fieldIndex = 0;
        for (String s : indexFields) {
            values[fieldIndex] = this.get(s);
            if (values[fieldIndex] == null) break;
            ++fieldIndex;
        }
        assert (fieldIndex > 0);
        FieldValueImpl fvi = ((FieldValueImpl)values[--fieldIndex]).getNextValue();
        while (fvi == null) {
            fvi = ((FieldValueImpl)values[fieldIndex]).getMinimumValue();
            this.put(indexFields.get(fieldIndex), fvi);
            if (--fieldIndex >= 0) {
                fvi = ((FieldValueImpl)values[fieldIndex]).getNextValue();
                continue;
            }
            return false;
        }
        assert (fvi != null && fieldIndex >= 0);
        this.put(indexFields.get(fieldIndex), fvi);
        return true;
    }
}

