/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.je.tree.Key;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import oracle.kv.Direction;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.table.FieldRange;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.TableIteratorOptions;

public class IndexRange
implements FastExternalizable {
    private static final int FLAG_FORWARD = 1;
    private static final int FLAG_REVERSE = 2;
    private static final int FLAG_UNORDERED = 4;
    private static final int FLAG_EXACT = 8;
    private final byte[] prefixKey;
    private final byte[] startKey;
    private final byte[] endKey;
    private final boolean exactMatch;
    private final Direction direction;

    IndexRange(IndexKeyImpl indexKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        IndexKeyImpl startTarget = indexKey;
        IndexKeyImpl endTarget = null;
        boolean startInclusive = true;
        FieldRange range = getOptions != null ? getOptions.getFieldRange() : null;
        Direction direction = this.direction = iterateOptions == null ? Direction.FORWARD : iterateOptions.getDirection();
        if (indexKey.isComplete()) {
            if (range != null) {
                throw new IllegalArgumentException("FieldRange may not be used with a fully specified IndexKey");
            }
            this.exactMatch = true;
        } else if (range != null) {
            if (range.getStart() != null) {
                startTarget = indexKey.clone();
                startTarget.put(range.getFieldName(), range.getStart());
                startInclusive = range.getStartInclusive();
            }
            if (range.getEnd() != null) {
                endTarget = indexKey.clone();
                endTarget.put(range.getFieldName(), range.getEnd());
                endTarget.validate();
            }
            this.exactMatch = false;
        } else {
            this.exactMatch = false;
        }
        if (startTarget.size() != 0) {
            startTarget.validate();
            if (!startInclusive && !startTarget.incrementIndexKey()) {
                throw new IllegalArgumentException("Exclusive start value on an indexed field cannot be its maximum value");
            }
            byte[] start = startTarget.getIndexImpl().serializeIndexKey(startTarget);
            if (startTarget.size() == indexKey.size()) {
                this.prefixKey = start;
                this.startKey = start;
            } else {
                this.startKey = start;
                this.prefixKey = indexKey.size() > 0 ? indexKey.getIndexImpl().serializeIndexKey(indexKey) : null;
            }
        } else {
            this.prefixKey = null;
            this.startKey = null;
        }
        if (endTarget != null) {
            if (range.getEndInclusive() && !endTarget.incrementIndexKey()) {
                this.endKey = null;
                return;
            }
            this.endKey = endTarget.getIndexImpl().serializeIndexKey(endTarget);
        } else {
            this.endKey = null;
        }
    }

    public IndexRange(ObjectInput in, short serialVersion) throws IOException {
        int flags = in.readUnsignedByte();
        boolean bl = this.exactMatch = (flags & 8) != 0;
        if ((flags & 1) != 0) {
            this.direction = Direction.FORWARD;
        } else if ((flags & 2) != 0) {
            this.direction = Direction.REVERSE;
        } else if ((flags & 4) != 0) {
            this.direction = Direction.UNORDERED;
        } else {
            throw new AssertionError((Object)"Flags must have a direction");
        }
        short keyLen = in.readShort();
        if (keyLen < 0) {
            this.prefixKey = null;
        } else {
            this.prefixKey = new byte[keyLen];
            in.readFully(this.prefixKey);
        }
        keyLen = in.readShort();
        if (keyLen < 0) {
            this.startKey = null;
        } else {
            this.startKey = new byte[keyLen];
            in.readFully(this.startKey);
        }
        keyLen = in.readShort();
        if (keyLen < 0) {
            this.endKey = null;
        } else {
            this.endKey = new byte[keyLen];
            in.readFully(this.endKey);
        }
    }

    @Override
    public void writeFastExternal(ObjectOutput out, short serialVersion) throws IOException {
        int flags = 0;
        if (this.exactMatch) {
            flags |= 8;
        }
        if (this.direction == Direction.FORWARD) {
            flags |= 1;
        } else if (this.direction == Direction.REVERSE) {
            flags |= 2;
        } else if (this.direction == Direction.UNORDERED) {
            flags |= 4;
        } else {
            throw new AssertionError((Object)"Direction must be set");
        }
        out.writeByte(flags);
        if (this.prefixKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.prefixKey.length);
            out.write(this.prefixKey);
        }
        if (this.startKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.startKey.length);
            out.write(this.startKey);
        }
        if (this.endKey == null) {
            out.writeShort(-1);
        } else {
            out.writeShort(this.endKey.length);
            out.write(this.endKey);
        }
    }

    public byte[] getPrefixKey() {
        return this.prefixKey;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public byte[] getEndKey() {
        return this.endKey;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isForward() {
        return this.direction == Direction.FORWARD;
    }

    public boolean isReverse() {
        return this.direction == Direction.REVERSE;
    }

    public boolean isUnordered() {
        return this.direction == Direction.UNORDERED;
    }

    public boolean getExactMatch() {
        return this.exactMatch;
    }

    public boolean inRange(byte[] checkKey) {
        return this.inRange(checkKey, this.direction);
    }

    private boolean inRange(byte[] checkKey, Direction dir) {
        if (this.exactMatch && dir != Direction.REVERSE) {
            return true;
        }
        boolean in = true;
        if (this.prefixKey != null) {
            if (checkKey.length < this.prefixKey.length) {
                in = false;
            } else {
                boolean bl = in = Key.compareUnsignedBytes((byte[])checkKey, (int)0, (int)this.prefixKey.length, (byte[])this.prefixKey, (int)0, (int)this.prefixKey.length) == 0;
            }
        }
        if (in && this.endKey != null && (dir == Direction.FORWARD || dir == Direction.UNORDERED)) {
            boolean bl = in = Key.compareUnsignedBytes((byte[])checkKey, (int)0, (int)Math.min(this.endKey.length, checkKey.length), (byte[])this.endKey, (int)0, (int)this.endKey.length) < 0;
        }
        if (in && this.startKey != null && dir == Direction.REVERSE) {
            in = IndexRange.compareUnsignedBytes(checkKey, this.startKey) >= 0;
        }
        return in;
    }

    public static int compareUnsignedBytes(byte[] checkKey, byte[] borderKey) {
        return Key.compareUnsignedBytes((byte[])checkKey, (int)0, (int)checkKey.length, (byte[])borderKey, (int)0, (int)borderKey.length);
    }

    boolean inRange(IndexKeyImpl key) {
        byte[] bytes = key.getIndexImpl().serializeIndexKey(key);
        return this.inRange(bytes, Direction.FORWARD) && this.inRange(bytes, Direction.REVERSE);
    }

    private String format(byte[] bytes) {
        return Key.getNoFormatString((byte[])bytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("prefix key:");
        sb.append(this.prefixKey != null ? this.format(this.prefixKey) : "null");
        sb.append(", start key:");
        sb.append(this.startKey != null ? this.format(this.startKey) : "null");
        sb.append(", end key:");
        sb.append(this.endKey != null ? this.format(this.endKey) : "null");
        sb.append(", direction:" + (Object)((Object)this.direction));
        sb.append(", exactMatch:" + this.exactMatch);
        return sb.toString();
    }
}

